/*
 * Decompiled with CFR 0.152.
 */
package tr.imports.thoughts.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import tr.imports.thoughts.prefs.ImportThoughtsPrefs;
import tr.imports.thoughts.prefs.ImportThoughtsPrefsPanelController;

final class ImportThoughtsPrefsPanel
extends JPanel {
    private final ImportThoughtsPrefsPanelController controller;
    private JComboBox encodingCombo;
    private JLabel encodingLabel;

    ImportThoughtsPrefsPanel(ImportThoughtsPrefsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        this.encodingLabel = new JLabel(this.getMsg("Encoding"));
        this.encodingCombo = new JComboBox(this.getEncodingModel());
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[]0", "0[]0"));
        panel.add((Component)this.encodingLabel, "align right");
        panel.add((Component)this.encodingCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private ComboBoxModel getEncodingModel() {
        Vector<String> encodings = new Vector<String>();
        encodings.add("");
        encodings.addAll(Charset.availableCharsets().keySet());
        return new DefaultComboBoxModel(encodings);
    }

    void load() {
        this.encodingCombo.setSelectedItem(ImportThoughtsPrefs.getEncoding());
    }

    void store() {
        if (this.isValidEncoding()) {
            ImportThoughtsPrefs.setEncoding(this.getEncoding());
        }
    }

    boolean valid() {
        return this.isValidEncoding();
    }

    private boolean isValidEncoding() {
        String encoding = this.getEncoding();
        return encoding.length() == 0 || Charset.isSupported(encoding);
    }

    private String getEncoding() {
        String encoding = (String)this.encodingCombo.getSelectedItem();
        return encoding == null ? "" : encoding;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

