/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.CRC32;
import com.jcraft.jzlib.JZlib;
import java.util.zip.Adler32;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.zlib.JZlibDeflate;
import org.jruby.ext.zlib.JZlibInflate;
import org.jruby.ext.zlib.JZlibRubyGzipReader;
import org.jruby.ext.zlib.JZlibRubyGzipWriter;
import org.jruby.ext.zlib.RubyGzipFile;
import org.jruby.ext.zlib.ZStream;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Zlib"})
public class RubyZlib {
    public static final String ZLIB_VERSION = "1.2.3.3";
    public static final String VERSION = "0.6.0";

    public static RubyModule createZlibModule(Ruby runtime2) {
        RubyModule mZlib = runtime2.defineModule("Zlib");
        mZlib.defineAnnotatedMethods(RubyZlib.class);
        RubyClass cStandardError = runtime2.getStandardError();
        RubyClass cZlibError = mZlib.defineOrGetClassUnder("Error", cStandardError, cStandardError.getAllocator());
        mZlib.defineOrGetClassUnder("StreamEnd", cZlibError, cZlibError.getAllocator());
        mZlib.defineOrGetClassUnder("StreamError", cZlibError, cZlibError.getAllocator());
        mZlib.defineOrGetClassUnder("BufError", cZlibError, cZlibError.getAllocator());
        mZlib.defineOrGetClassUnder("NeedDict", cZlibError, cZlibError.getAllocator());
        mZlib.defineOrGetClassUnder("MemError", cZlibError, cZlibError.getAllocator());
        mZlib.defineOrGetClassUnder("VersionError", cZlibError, cZlibError.getAllocator());
        mZlib.defineOrGetClassUnder("DataError", cZlibError, cZlibError.getAllocator());
        RubyClass cGzFile = mZlib.defineOrGetClassUnder("GzipFile", runtime2.getObject(), RubyGzipFile.GZIPFILE_ALLOCATOR);
        cGzFile.defineAnnotatedMethods(RubyGzipFile.class);
        cGzFile.defineOrGetClassUnder("Error", cZlibError, cZlibError.getAllocator());
        RubyClass cGzError = cGzFile.defineOrGetClassUnder("Error", cZlibError, cZlibError.getAllocator());
        cGzError.addReadAttribute(runtime2.getCurrentContext(), "input");
        cGzFile.defineOrGetClassUnder("CRCError", cGzError, cGzError.getAllocator());
        cGzFile.defineOrGetClassUnder("NoFooter", cGzError, cGzError.getAllocator());
        cGzFile.defineOrGetClassUnder("LengthError", cGzError, cGzError.getAllocator());
        RubyClass cGzReader = mZlib.defineOrGetClassUnder("GzipReader", cGzFile, JZlibRubyGzipReader.GZIPREADER_ALLOCATOR);
        cGzReader.includeModule(runtime2.getEnumerable());
        cGzReader.defineAnnotatedMethods(JZlibRubyGzipReader.class);
        RubyClass cGzWriter = mZlib.defineOrGetClassUnder("GzipWriter", cGzFile, JZlibRubyGzipWriter.GZIPWRITER_ALLOCATOR);
        cGzWriter.defineAnnotatedMethods(JZlibRubyGzipWriter.class);
        mZlib.defineConstant("ZLIB_VERSION", runtime2.newString(ZLIB_VERSION));
        mZlib.defineConstant("VERSION", runtime2.newString(VERSION));
        mZlib.defineConstant("BINARY", runtime2.newFixnum(0));
        mZlib.defineConstant("ASCII", runtime2.newFixnum(1));
        mZlib.defineConstant("UNKNOWN", runtime2.newFixnum(2));
        mZlib.defineConstant("DEF_MEM_LEVEL", runtime2.newFixnum(8));
        mZlib.defineConstant("MAX_MEM_LEVEL", runtime2.newFixnum(9));
        mZlib.defineConstant("OS_UNIX", runtime2.newFixnum(3));
        mZlib.defineConstant("OS_UNKNOWN", runtime2.newFixnum(-1));
        mZlib.defineConstant("OS_CODE", runtime2.newFixnum(11));
        mZlib.defineConstant("OS_ZSYSTEM", runtime2.newFixnum(8));
        mZlib.defineConstant("OS_VMCMS", runtime2.newFixnum(4));
        mZlib.defineConstant("OS_VMS", runtime2.newFixnum(2));
        mZlib.defineConstant("OS_RISCOS", runtime2.newFixnum(13));
        mZlib.defineConstant("OS_MACOS", runtime2.newFixnum(7));
        mZlib.defineConstant("OS_OS2", runtime2.newFixnum(6));
        mZlib.defineConstant("OS_AMIGA", runtime2.newFixnum(1));
        mZlib.defineConstant("OS_QDOS", runtime2.newFixnum(12));
        mZlib.defineConstant("OS_WIN32", runtime2.newFixnum(11));
        mZlib.defineConstant("OS_ATARI", runtime2.newFixnum(5));
        mZlib.defineConstant("OS_MSDOS", runtime2.newFixnum(0));
        mZlib.defineConstant("OS_CPM", runtime2.newFixnum(9));
        mZlib.defineConstant("OS_TOPS20", runtime2.newFixnum(10));
        mZlib.defineConstant("DEFAULT_STRATEGY", runtime2.newFixnum(0));
        mZlib.defineConstant("FILTERED", runtime2.newFixnum(1));
        mZlib.defineConstant("HUFFMAN_ONLY", runtime2.newFixnum(2));
        mZlib.defineConstant("NO_FLUSH", runtime2.newFixnum(0));
        mZlib.defineConstant("SYNC_FLUSH", runtime2.newFixnum(2));
        mZlib.defineConstant("FULL_FLUSH", runtime2.newFixnum(3));
        mZlib.defineConstant("FINISH", runtime2.newFixnum(4));
        mZlib.defineConstant("NO_COMPRESSION", runtime2.newFixnum(0));
        mZlib.defineConstant("BEST_SPEED", runtime2.newFixnum(1));
        mZlib.defineConstant("DEFAULT_COMPRESSION", runtime2.newFixnum(-1));
        mZlib.defineConstant("BEST_COMPRESSION", runtime2.newFixnum(9));
        mZlib.defineConstant("MAX_WBITS", runtime2.newFixnum(15));
        RubyClass cZStream = mZlib.defineOrGetClassUnder("ZStream", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cZStream.defineAnnotatedMethods(ZStream.class);
        cZStream.undefineMethod("new");
        RubyClass cInflate = mZlib.defineOrGetClassUnder("Inflate", cZStream, JZlibInflate.INFLATE_ALLOCATOR);
        cInflate.defineAnnotatedMethods(JZlibInflate.class);
        RubyClass cDeflate = mZlib.defineOrGetClassUnder("Deflate", cZStream, JZlibDeflate.DEFLATE_ALLOCATOR);
        cDeflate.defineAnnotatedMethods(JZlibDeflate.class);
        runtime2.getKernel().callMethod(runtime2.getCurrentContext(), "require", (IRubyObject)runtime2.newString("stringio"));
        return mZlib;
    }

    @JRubyMethod(name={"zlib_version"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject zlib_version(IRubyObject recv2) {
        RubyBasicObject res = (RubyBasicObject)((RubyModule)recv2).getConstant("ZLIB_VERSION");
        res.setTaint(true);
        return res;
    }

    @JRubyMethod(name={"crc32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        long start2 = 0L;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            start2 = RubyNumeric.num2long(args2[1]);
        }
        boolean slowPath = (start2 &= 0xFFFFFFFFL) != 0L;
        int bytesLength = bytes2 == null ? 0 : bytes2.length();
        long result2 = 0L;
        if (bytes2 != null) {
            java.util.zip.CRC32 checksum = new java.util.zip.CRC32();
            checksum.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytesLength);
            result2 = checksum.getValue();
        }
        if (slowPath) {
            result2 = JZlib.crc32_combine(start2, result2, bytesLength);
        }
        return recv2.getRuntime().newFixnum(result2);
    }

    @JRubyMethod(name={"adler32"}, optional=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32(IRubyObject recv2, IRubyObject[] args2) {
        args2 = Arity.scanArgs(recv2.getRuntime(), args2, 0, 2);
        int start2 = 1;
        ByteList bytes2 = null;
        if (!args2[0].isNil()) {
            bytes2 = args2[0].convertToString().getByteList();
        }
        if (!args2[1].isNil()) {
            start2 = (int)RubyNumeric.num2long(args2[1]);
        }
        Adler32 checksum = new Adler32();
        if (bytes2 != null) {
            checksum.update(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        long result2 = checksum.getValue();
        if (start2 != 1) {
            result2 = JZlib.adler32_combine(start2, result2, bytes2.length());
        }
        return recv2.getRuntime().newFixnum(result2);
    }

    @JRubyMethod(module=true)
    public static IRubyObject inflate(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
        return JZlibInflate.s_inflate(context, recv2, string2);
    }

    @JRubyMethod(required=1, optional=1, module=true)
    public static IRubyObject deflate(IRubyObject recv2, IRubyObject[] args2) {
        return JZlibDeflate.s_deflate(recv2, args2);
    }

    @JRubyMethod(name={"crc_table"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc_table(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        int[] table = CRC32.getCRC32Table();
        RubyArray array2 = runtime2.newArray(table.length);
        for (int i2 = 0; i2 < table.length; ++i2) {
            array2.append(runtime2.newFixnum((long)table[i2] & 0xFFFFFFFFL));
        }
        return array2;
    }

    @JRubyMethod(name={"crc32_combine"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject crc32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long crc1 = RubyNumeric.num2long(arg0);
        long crc2 = RubyNumeric.num2long(arg1);
        long len2 = RubyNumeric.num2long(arg2);
        long crc3 = JZlib.crc32_combine(crc1, crc2, len2);
        return recv2.getRuntime().newFixnum(crc3);
    }

    @JRubyMethod(name={"adler32_combine"}, required=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject adler32_combine(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        long adler1 = RubyNumeric.num2long(arg0);
        long adler2 = RubyNumeric.num2long(arg1);
        long len2 = RubyNumeric.num2long(arg2);
        long adler3 = JZlib.adler32_combine(adler1, adler2, len2);
        return recv2.getRuntime().newFixnum(adler3);
    }

    static RaiseException newZlibError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "Error", message2);
    }

    static RaiseException newBufError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "BufError", message2);
    }

    static RaiseException newDictError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "NeedDict", message2);
    }

    static RaiseException newStreamError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "StreamError", message2);
    }

    static RaiseException newDataError(Ruby runtime2, String message2) {
        return RubyZlib.newZlibError(runtime2, "DataError", message2);
    }

    static RaiseException newZlibError(Ruby runtime2, String klass, String message2) {
        RubyClass errorClass = runtime2.getModule("Zlib").getClass(klass);
        return RaiseException.from(runtime2, errorClass, message2);
    }

    static RaiseException newGzipFileError(Ruby runtime2, String message2) {
        return RubyZlib.newGzipFileError(runtime2, "Error", message2);
    }

    static RaiseException newCRCError(Ruby runtime2, String message2) {
        return RubyZlib.newGzipFileError(runtime2, "CRCError", message2);
    }

    static RaiseException newNoFooter(Ruby runtime2, String message2) {
        return RubyZlib.newGzipFileError(runtime2, "NoFooter", message2);
    }

    static RaiseException newLengthError(Ruby runtime2, String message2) {
        return RubyZlib.newGzipFileError(runtime2, "LengthError", message2);
    }

    static RaiseException newGzipFileError(Ruby runtime2, String klass, String message2) {
        RubyClass errorClass = runtime2.getModule("Zlib").getClass("GzipFile").getClass(klass);
        RubyException excn = RubyException.newException(runtime2, errorClass, message2);
        excn.setInstanceVariable("@input", runtime2.getNil());
        return excn.toThrowable();
    }

    static int FIXNUMARG(IRubyObject obj, int ifnil) {
        if (obj.isNil()) {
            return ifnil;
        }
        return RubyNumeric.fix2int(obj);
    }

    @JRubyClass(name={"Zlib::DataError"}, parent="Zlib::Error")
    public static class DataError
    extends Error {
    }

    @JRubyClass(name={"Zlib::VersionError"}, parent="Zlib::Error")
    public static class VersionError
    extends Error {
    }

    @JRubyClass(name={"Zlib::MemError"}, parent="Zlib::Error")
    public static class MemError
    extends Error {
    }

    @JRubyClass(name={"Zlib::NeedDict"}, parent="Zlib::Error")
    public static class NeedDict
    extends Error {
    }

    @JRubyClass(name={"Zlib::BufError"}, parent="Zlib::Error")
    public static class BufError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamError"}, parent="Zlib::Error")
    public static class StreamError
    extends Error {
    }

    @JRubyClass(name={"Zlib::StreamEnd"}, parent="Zlib::Error")
    public static class StreamEnd
    extends Error {
    }

    @JRubyClass(name={"Zlib::Error"}, parent="StandardError")
    public static class Error {
    }
}

