/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.internals.NokogiriHelpers;
import org.cyberneko.html.HTMLElements;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class SaveContextVisitor {
    private final StringBuilder buffer = new StringBuilder();
    private final Stack<String> indentation;
    private String encoding;
    private final CharSequence indentString;
    private boolean format;
    private final boolean noDecl;
    private final boolean noEmpty;
    private final boolean noXhtml;
    private final boolean asXhtml;
    private boolean asXml;
    private final boolean asHtml;
    private final boolean asBuilder;
    private boolean htmlDoc;
    private final boolean fragment;
    private final boolean canonical;
    private final boolean incl_ns;
    private final boolean with_comments;
    private boolean subsets;
    private boolean exclusive;
    private final List<Node> c14nNodeList;
    private final Deque<Attr[]> c14nNamespaceStack;
    private final Deque<Attr[]> c14nAttrStack;
    public static final int FORMAT = 1;
    public static final int NO_DECL = 2;
    public static final int NO_EMPTY = 4;
    public static final int NO_XHTML = 8;
    public static final int AS_XHTML = 16;
    public static final int AS_XML = 32;
    public static final int AS_HTML = 64;
    public static final int AS_BUILDER = 128;
    public static final int CANONICAL = 1;
    public static final int INCL_NS = 2;
    public static final int WITH_COMMENTS = 4;
    public static final int SUBSETS = 8;
    public static final int EXCLUSIVE = 16;
    private static final Pattern CHARSET = Pattern.compile("charset(()|\\s+)=(()|\\s+)(\\w|\\_|\\.|\\-)+", 2);
    static final Set<String> HTML_BOOLEAN_ATTRS;

    public SaveContextVisitor(int n, CharSequence charSequence, String string, boolean bl, boolean bl2, int n2) {
        this.encoding = string;
        this.indentation = new Stack();
        this.indentation.push("");
        this.htmlDoc = bl;
        this.fragment = bl2;
        this.c14nNodeList = new ArrayList<Node>();
        this.c14nNamespaceStack = new ArrayDeque<Attr[]>();
        this.c14nAttrStack = new ArrayDeque<Attr[]>();
        this.format = (n & 1) == 1;
        this.noDecl = (n & 2) == 2;
        this.noEmpty = (n & 4) == 4;
        this.noXhtml = (n & 8) == 8;
        this.asXhtml = (n & 0x10) == 16;
        this.asXml = (n & 0x20) == 32;
        this.asHtml = (n & 0x40) == 64;
        this.asBuilder = (n & 0x80) == 128;
        this.canonical = (n2 & 1) == 1;
        this.incl_ns = (n2 & 2) == 2;
        this.with_comments = (n2 & 4) == 4;
        boolean bl3 = this.subsets = (n2 & 8) == 8;
        if (this.format && charSequence == null || this.format && charSequence.length() == 0) {
            charSequence = "  ";
        }
        if (!this.format && charSequence != null && charSequence.length() > 0) {
            this.format = true;
        }
        if (this.asBuilder && charSequence == null || this.asBuilder && charSequence.length() == 0) {
            charSequence = "  ";
        }
        this.indentString = charSequence;
        if (!(this.asXml || this.asHtml || this.asXhtml || this.asBuilder)) {
            this.asXml = true;
        }
    }

    public String toString() {
        return this.buffer.toString();
    }

    public StringBuilder getInternalBuffer() {
        return this.buffer;
    }

    public void setHtmlDoc(boolean bl) {
        this.htmlDoc = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public boolean enter(Node node) {
        if (node instanceof Document) {
            return this.enter((Document)node);
        }
        if (node instanceof Element) {
            return this.enter((Element)node);
        }
        if (node instanceof Attr) {
            return this.enter((Attr)node);
        }
        if (node instanceof Text) {
            return this.enter((Text)node);
        }
        if (node instanceof CDATASection) {
            return this.enter((CDATASection)node);
        }
        if (node instanceof Comment) {
            return this.enter((Comment)node);
        }
        if (node instanceof DocumentType) {
            return this.enter((DocumentType)node);
        }
        if (node instanceof Entity) {
            return this.enter((Entity)node);
        }
        if (node instanceof EntityReference) {
            return this.enter((EntityReference)node);
        }
        if (node instanceof Notation) {
            return this.enter((Notation)node);
        }
        if (node instanceof ProcessingInstruction) {
            return this.enter((ProcessingInstruction)node);
        }
        return false;
    }

    public void leave(Node node) {
        if (node instanceof Document) {
            this.leave((Document)node);
            return;
        }
        if (node instanceof Element) {
            this.leave((Element)node);
            return;
        }
        if (node instanceof Attr) {
            this.leave((Attr)node);
            return;
        }
        if (node instanceof Text) {
            return;
        }
        if (node instanceof CDATASection) {
            this.leave((CDATASection)node);
            return;
        }
        if (node instanceof Comment) {
            this.leave((Comment)node);
            return;
        }
        if (node instanceof DocumentType) {
            this.leave((DocumentType)node);
            return;
        }
        if (node instanceof Entity) {
            this.leave((Entity)node);
            return;
        }
        if (node instanceof EntityReference) {
            this.leave((EntityReference)node);
            return;
        }
        if (node instanceof Notation) {
            this.leave((Notation)node);
            return;
        }
        if (node instanceof ProcessingInstruction) {
            this.leave((ProcessingInstruction)node);
            return;
        }
    }

    public boolean enter(String string) {
        this.buffer.append(string);
        return true;
    }

    public void leave(String string) {
    }

    public boolean enter(Attr attr) {
        String string = attr.getName();
        this.buffer.append(string);
        if (!this.asHtml || !SaveContextVisitor.isHtmlBooleanAttr(string)) {
            this.buffer.append('=');
            this.buffer.append('\"');
            String string2 = this.replaceCharsetIfNecessary(attr);
            this.buffer.append(SaveContextVisitor.serializeAttrTextContent(string2, this.htmlDoc));
            this.buffer.append('\"');
        }
        return true;
    }

    private String replaceCharsetIfNecessary(Attr attr) {
        String string = attr.getValue();
        if (this.encoding == null) {
            return string;
        }
        if (!"content".equals(attr.getName().toLowerCase())) {
            return string;
        }
        if (!"meta".equals(attr.getOwnerElement().getNodeName().toLowerCase())) {
            return string;
        }
        Matcher matcher = CHARSET.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        if (string.contains(this.encoding)) {
            return string;
        }
        return string.replace(matcher.group(), "charset=" + this.encoding);
    }

    private static boolean isHtmlBooleanAttr(String string) {
        return HTML_BOOLEAN_ATTRS.contains(string);
    }

    private static CharSequence serializeAttrTextContent(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16);
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("&#10;");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("&#13;");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("&#9;");
                    continue block9;
                }
                case '\"': {
                    if (bl) {
                        stringBuilder.append("%22");
                        continue block9;
                    }
                    stringBuilder.append("&quot;");
                    continue block9;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder;
    }

    public void leave(Attr attr) {
    }

    public boolean enter(CDATASection cDATASection) {
        this.buffer.append("<![CDATA[");
        this.buffer.append(cDATASection.getData());
        this.buffer.append("]]>");
        return true;
    }

    public void leave(CDATASection cDATASection) {
    }

    public boolean enter(Comment comment) {
        if (this.canonical) {
            this.c14nNodeList.add(comment);
            if (!this.with_comments) {
                return true;
            }
        }
        this.buffer.append("<!--");
        this.buffer.append(comment.getData());
        this.buffer.append("-->");
        return true;
    }

    public void leave(Comment comment) {
    }

    public boolean enter(Document document) {
        if (!this.noDecl) {
            this.buffer.append("<?xml version=\"");
            this.buffer.append(document.getXmlVersion());
            this.buffer.append("\"");
            if (this.encoding != null) {
                this.buffer.append(" encoding=\"");
                this.buffer.append(this.encoding);
                this.buffer.append("\"");
            }
            this.buffer.append("?>\n");
        }
        return true;
    }

    public void leave(Document document) {
    }

    public boolean enter(DocumentType documentType) {
        if (this.canonical) {
            this.c14nNodeList.add(documentType);
            return true;
        }
        String string = documentType.getName();
        String string2 = documentType.getPublicId();
        String string3 = documentType.getSystemId();
        String string4 = documentType.getInternalSubset();
        if (documentType.getPreviousSibling() != null) {
            this.buffer.append('\n');
        }
        this.buffer.append("<!DOCTYPE ").append(string).append(' ');
        if (string2 != null) {
            this.buffer.append("PUBLIC \"").append(string2).append('\"');
            if (string3 != null) {
                this.buffer.append(" \"").append(string3).append('\"');
            }
        } else if (string3 != null) {
            this.buffer.append("SYSTEM \"").append(string3).append('\"');
        }
        if (string4 != null) {
            this.buffer.append(' ').append('[');
            this.buffer.append(string4);
            this.buffer.append(']');
        }
        this.buffer.append(">\n");
        return true;
    }

    public void leave(DocumentType documentType) {
    }

    public boolean enter(Element element) {
        Attr[] attrArray;
        if (this.canonical) {
            this.c14nNodeList.add(element);
            if (element == element.getOwnerDocument().getDocumentElement()) {
                this.c14nNodeList.add(element.getOwnerDocument());
            }
        }
        String string = this.indentation.peek();
        this.buffer.append(string);
        if (this.needIndent(element)) {
            this.indentation.push(string + this.indentString);
        }
        String string2 = element.getTagName();
        this.buffer.append('<').append(string2);
        for (Attr attr : attrArray = this.getAttrsAndNamespaces(element)) {
            if (!attr.getSpecified()) continue;
            this.buffer.append(' ');
            this.enter(attr);
            this.leave(attr);
        }
        if (element.hasChildNodes()) {
            this.buffer.append('>');
            if (this.needBreakInOpening(element)) {
                this.buffer.append('\n');
            }
            return true;
        }
        if (this.asHtml) {
            this.buffer.append('>');
        } else if (this.asXml && this.noEmpty) {
            this.buffer.append('>');
        } else if (this.asXhtml) {
            if (this.isEmpty(string2)) {
                this.buffer.append(" />");
            } else {
                this.buffer.append('>');
            }
        } else {
            this.buffer.append("/>");
        }
        if (this.needBreakInOpening(element)) {
            this.buffer.append('\n');
        }
        return true;
    }

    private boolean needIndent(Element element) {
        if (this.containsText(element)) {
            return false;
        }
        if (this.fragment) {
            return false;
        }
        return this.format || this.asBuilder;
    }

    private boolean needBreakInOpening(Element element) {
        if (this.containsText(element)) {
            return false;
        }
        if (this.fragment) {
            return false;
        }
        if (this.format) {
            return true;
        }
        if (this.asBuilder && element.getFirstChild() != null && element.getFirstChild().getNodeType() == 1) {
            return true;
        }
        return this.format && element.getNextSibling() == null && element.hasChildNodes();
    }

    private boolean isEmpty(String string) {
        HTMLElements.Element element = HTMLElements.getElement((String)string);
        return element.isEmpty();
    }

    private Attr[] getAttrsAndNamespaces(Element element) {
        Attr[] attrArray;
        Attr[] attrArray2;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (!this.canonical) {
            if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
                return new Attr[0];
            }
            Attr[] attrArray3 = new Attr[namedNodeMap.getLength()];
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                attrArray3[i] = (Attr)namedNodeMap.item(i);
            }
            return attrArray3;
        }
        ArrayList<Attr> arrayList = new ArrayList<Attr>();
        ArrayList<Attr> arrayList2 = new ArrayList<Attr>();
        if (this.subsets) {
            this.getAttrsOfAncestors(element.getParentNode(), arrayList, arrayList2);
            attrArray2 = this.getSortedArray(arrayList);
            attrArray = this.getSortedArray(arrayList2);
            this.c14nNamespaceStack.push(attrArray2);
            this.c14nAttrStack.push(attrArray);
            this.subsets = false;
        }
        this.getNamespacesAndAttrs(element, arrayList, arrayList2);
        attrArray2 = this.getSortedArray(arrayList);
        attrArray = this.getSortedArray(arrayList2);
        Attr[] attrArray4 = new Attr[attrArray2.length + attrArray.length];
        for (int i = 0; i < attrArray4.length; ++i) {
            attrArray4[i] = i < attrArray2.length ? attrArray2[i] : attrArray[i - attrArray2.length];
        }
        this.c14nNamespaceStack.push(attrArray2);
        this.c14nAttrStack.push(attrArray);
        return attrArray4;
    }

    private void getAttrsOfAncestors(Node node, List<Attr> list, List<Attr> list2) {
        if (node == null) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (NokogiriHelpers.isNamespace(attr.getNodeName())) {
                list.add(attr);
                continue;
            }
            list2.add(attr);
        }
        this.getAttrsOfAncestors(node.getParentNode(), list, list2);
    }

    private void getNamespacesAndAttrs(Node node, List<Attr> list, List<Attr> list2) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (NokogiriHelpers.isNamespace(attr.getNodeName())) {
                this.getNamespacesWithPropagated(list, attr);
            } else {
                this.getAttributesWithPropagated(list2, attr);
            }
            if (!this.exclusive) continue;
            this.verifyXmlSpace(list2, namedNodeMap);
        }
    }

    private void getNamespacesWithPropagated(List<Attr> list, Attr attr) {
        boolean bl = true;
        for (Attr[] attrArray : this.c14nNamespaceStack) {
            for (int i = 0; i < attrArray.length; ++i) {
                if (!attrArray[i].getNodeName().equals(attr.getNodeName())) continue;
                if (attrArray[i].getNodeValue().equals(attr.getNodeValue())) {
                    bl = false;
                    continue;
                }
                list.remove(attrArray[i]);
            }
            if (!bl || list.contains(attr)) continue;
            list.add(attr);
        }
    }

    private void getAttributesWithPropagated(List<Attr> list, Attr attr) {
        boolean bl = true;
        for (Attr[] attrArray : this.c14nAttrStack) {
            for (int i = 0; i < attrArray.length; ++i) {
                if (!attrArray[i].getNodeName().startsWith("xml:") || !attrArray[i].getNodeName().equals(attr.getNodeName())) continue;
                if (attrArray[i].getNodeValue().equals(attr.getNodeValue())) {
                    bl = false;
                    continue;
                }
                list.remove(attrArray[i]);
            }
            if (!bl) continue;
            list.add(attr);
        }
    }

    private void verifyXmlSpace(List<Attr> list, NamedNodeMap namedNodeMap) {
        Attr attr = (Attr)namedNodeMap.getNamedItem("xml:space");
        if (attr == null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).getNodeName().equals("xml:space")) continue;
                list.remove(i);
                break;
            }
        }
    }

    private Attr[] getSortedArray(List<Attr> list) {
        Attr[] attrArray = list.toArray(new Attr[0]);
        Arrays.sort(attrArray, new Comparator<Attr>(){

            @Override
            public int compare(Attr attr, Attr attr2) {
                return attr.getNodeName().compareTo(attr2.getNodeName());
            }
        });
        return attrArray;
    }

    public void leave(Element element) {
        if (this.canonical) {
            this.c14nNamespaceStack.poll();
            this.c14nAttrStack.poll();
        }
        String string = element.getTagName();
        if (element.hasChildNodes()) {
            if (this.needIndentInClosing(element)) {
                this.indentation.pop();
                this.buffer.append(this.indentation.peek());
            } else if (this.asBuilder && !this.containsText(element)) {
                this.indentation.pop();
            }
            this.buffer.append("</").append(string).append('>');
            if (this.needBreakInClosing(element)) {
                this.buffer.append('\n');
            }
            return;
        }
        if ((this.asHtml || this.noEmpty) && !this.isEmpty(string) && this.noEmpty) {
            this.buffer.append("</").append(string).append('>');
        }
        if (this.needBreakInClosing(element)) {
            if (!this.containsText(element)) {
                this.indentation.pop();
            }
            this.buffer.append('\n');
        }
    }

    private boolean needIndentInClosing(Element element) {
        if (this.containsText(element)) {
            return false;
        }
        if (this.fragment) {
            return false;
        }
        if (this.format) {
            return true;
        }
        return this.asBuilder && element.getFirstChild() != null && element.getFirstChild().getNodeType() == 1;
    }

    private boolean needBreakInClosing(Element element) {
        if (this.fragment) {
            return false;
        }
        return this.format || this.asBuilder;
    }

    private boolean containsText(Element element) {
        return element.getFirstChild() != null && element.getFirstChild().getNodeType() == 3;
    }

    public boolean enter(Entity entity) {
        String string = entity.getNodeName();
        String string2 = entity.getPublicId();
        String string3 = entity.getSystemId();
        String string4 = entity.getNotationName();
        this.buffer.append("<!ENTITY ");
        this.buffer.append(string);
        if (string2 != null) {
            this.buffer.append(" PUBLIC \"");
            this.buffer.append(string2);
            this.buffer.append("\"");
        }
        if (string3 != null) {
            this.buffer.append(" SYSTEM \"");
            this.buffer.append(string3);
            this.buffer.append("\"");
        }
        if (string4 != null) {
            this.buffer.append(" NDATA ");
            this.buffer.append(string4);
        }
        this.buffer.append(">");
        return true;
    }

    public void leave(Entity entity) {
    }

    public boolean enter(EntityReference entityReference) {
        this.buffer.append('&').append(entityReference.getNodeName()).append(';');
        return true;
    }

    public void leave(EntityReference entityReference) {
    }

    public boolean enter(Notation notation) {
        String string = notation.getNodeName();
        String string2 = notation.getPublicId();
        String string3 = notation.getSystemId();
        this.buffer.append("<!NOTATION ");
        this.buffer.append(string);
        if (string2 != null) {
            this.buffer.append(" PUBLIC \"");
            this.buffer.append(string2);
            this.buffer.append("\"");
            if (string3 != null) {
                this.buffer.append(" \"");
                this.buffer.append(string3);
                this.buffer.append("\"");
            }
        } else if (string3 != null) {
            this.buffer.append(" SYSTEM \"");
            this.buffer.append(string3);
            this.buffer.append("\"");
        }
        this.buffer.append(">");
        return true;
    }

    public void leave(Notation notation) {
    }

    public boolean enter(ProcessingInstruction processingInstruction) {
        this.buffer.append("<?");
        this.buffer.append(processingInstruction.getTarget());
        this.buffer.append(" ");
        this.buffer.append(processingInstruction.getData());
        if (this.asHtml) {
            this.buffer.append(">");
        } else {
            this.buffer.append("?>");
        }
        this.buffer.append("\n");
        if (this.canonical) {
            this.c14nNodeList.add(processingInstruction);
        }
        return true;
    }

    public void leave(ProcessingInstruction processingInstruction) {
    }

    private boolean isHtmlScript(Text text) {
        return this.htmlDoc && text.getParentNode().getNodeName().equals("script");
    }

    private boolean isHtmlStyle(Text text) {
        return this.htmlDoc && text.getParentNode().getNodeName().equals("style");
    }

    public boolean enter(Text text) {
        CharSequence charSequence = text.getNodeValue();
        if (this.canonical) {
            this.c14nNodeList.add(text);
            if (NokogiriHelpers.isBlank(charSequence)) {
                this.buffer.append(NokogiriHelpers.canonicalizeWhitespace(charSequence));
                return true;
            }
        }
        if (NokogiriHelpers.shouldEncode(text) && !this.isHtmlScript(text) && !this.isHtmlStyle(text)) {
            charSequence = NokogiriHelpers.encodeJavaString(charSequence);
        }
        charSequence = this.encodeStringToHtmlEntity(charSequence);
        this.buffer.append(charSequence);
        return true;
    }

    private CharSequence encodeStringToHtmlEntity(CharSequence charSequence) {
        int n;
        if (this.encoding == null) {
            return charSequence;
        }
        CharsetEncoder charsetEncoder = Charset.forName(this.encoding).newEncoder();
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() + 16);
        for (int i = 0; i < charSequence.length(); i += n) {
            int n2 = Character.codePointAt(charSequence, i);
            n = n2 > 65535 ? 2 : 1;
            CharSequence charSequence2 = charSequence.subSequence(i, i + n);
            boolean bl = charsetEncoder.canEncode(charSequence2);
            if (bl) {
                stringBuilder.append(charSequence2);
                continue;
            }
            stringBuilder.append("&#x").append(Integer.toHexString(n2)).append(';');
        }
        return stringBuilder;
    }

    static {
        String[] stringArray = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};
        HTML_BOOLEAN_ATTRS = new HashSet<String>(Arrays.asList(stringArray));
    }
}

