/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.Ruby;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.BlockJITClassGenerator;
import org.jruby.compiler.JITCompiler;
import org.jruby.compiler.MethodJITTask;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.MixedModeIRBlockBody;

class BlockJITTask
extends JITCompiler.Task {
    private final String className;
    private final MixedModeIRBlockBody body;
    private final String blockId;
    private final String methodName;

    public BlockJITTask(JITCompiler jitCompiler, MixedModeIRBlockBody body, String className) {
        super(jitCompiler);
        this.body = body;
        this.className = className;
        this.blockId = body.getName();
        IRMethod method2 = body.getIRScope().getNearestMethod();
        this.methodName = method2 != null ? method2.getByteName().toString() : null;
    }

    @Override
    public void exec() throws NoSuchMethodException, IllegalAccessException {
        String excludeModuleName = MethodJITTask.checkExcludedMethod(this.jitCompiler.config, this.className, this.methodName, this.body);
        if (excludeModuleName != null) {
            this.body.setCallCount(-1);
            if (this.jitCompiler.config.isJitLogging()) {
                JITCompiler.log(this.body, this.blockId, "skipping block in " + excludeModuleName, new Object[0]);
            }
            return;
        }
        String key2 = SexpMaker.sha1(this.body.getIRScope());
        Ruby runtime2 = this.jitCompiler.runtime;
        JVMVisitor visitor = new JVMVisitor(runtime2);
        BlockJITClassGenerator generator = new BlockJITClassGenerator(this.className, this.blockId, key2, runtime2, this.body, visitor);
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        generator.compile(context);
        Class<?> sourceClass = this.defineClass(generator, visitor, this.body.getIRScope(), this.body.ensureInstrsReady());
        if (sourceClass == null) {
            return;
        }
        String jittedName = context.getVariableName();
        this.body.completeBuild(new CompiledIRBlockBody(JITCompiler.PUBLIC_LOOKUP.findStatic(sourceClass, jittedName, JVMVisitor.CLOSURE_SIGNATURE.type()), this.body.getIRScope(), ((IRClosure)this.body.getIRScope()).getSignature().encode()));
    }

    @Override
    protected String getSourceFile() {
        return this.body.getFile();
    }

    @Override
    protected void logJitted() {
        this.logImpl("block done jitting", new Object[0]);
    }

    @Override
    protected void logFailed(Throwable ex) {
        this.logImpl("could not compile block; passes run: " + this.body.getIRScope().getExecutedPasses(), ex);
    }

    @Override
    protected void logImpl(String message2, Object ... reason2) {
        JITCompiler.log(this.body, this.blockId, message2, reason2);
    }
}

