/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.RSAUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaTlsRSAPSSSigner
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private final short signatureAlgorithm;

    public JcaTlsRSAPSSSigner(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, short s) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        if (!SignatureAlgorithm.isRSAPSS(s)) {
            throw new IllegalArgumentException("signatureAlgorithm");
        }
        this.crypto = jcaTlsCrypto;
        this.privateKey = privateKey;
        this.signatureAlgorithm = s;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        if (signatureAndHashAlgorithm == null || signatureAndHashAlgorithm.getSignature() != this.signatureAlgorithm || signatureAndHashAlgorithm.getHash() != 8) {
            throw new IllegalStateException();
        }
        short s = SignatureAlgorithm.getRSAPSSHashAlgorithm(this.signatureAlgorithm);
        String string = this.crypto.getDigestName(s);
        String string2 = RSAUtil.getDigestSigAlgName(string) + "WITHRSAANDMGF1";
        try {
            AlgorithmParameterSpec algorithmParameterSpec = RSAUtil.getPSSParameterSpec(s, string, this.crypto.getHelper());
            final Signature signature = this.crypto.getHelper().createSignature(string2);
            signature.setParameter(algorithmParameterSpec);
            signature.initSign(this.privateKey, this.crypto.getSecureRandom());
            final OutputStream outputStream = OutputStreamFactory.createStream((Signature)signature);
            return new TlsStreamSigner(){

                @Override
                public OutputStream getOutputStream() throws IOException {
                    return outputStream;
                }

                @Override
                public byte[] getSignature() throws IOException {
                    try {
                        return signature.sign();
                    }
                    catch (SignatureException signatureException) {
                        throw new IOException(signatureException.getMessage());
                    }
                }
            };
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException(string2 + " signature failed", generalSecurityException);
        }
    }
}

