"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../utils/commons");
var dimensions_1 = require("../../../utils/dimensions");
var spec_1 = require("../state/utils/spec");
var axis_utils_1 = require("./axis_utils");
function computeChartDimensions(parentDimensions, _a, axisDimensions, axesStyles, axisSpecs, legendSizing) {
    var chartMargins = _a.chartMargins, chartPaddings = _a.chartPaddings, sharedAxesStyles = _a.axes;
    if (parentDimensions.width <= 0 || parentDimensions.height <= 0) {
        return {
            chartDimensions: {
                width: 0,
                height: 0,
                left: 0,
                top: 0,
            },
            leftMargin: 0,
            offset: {
                left: 0,
                top: 0,
            },
        };
    }
    var vLeftAxisSpecWidth = 0;
    var vRightAxisSpecWidth = 0;
    var hTopAxisSpecHeight = 0;
    var hBottomAxisSpecHeight = 0;
    var horizontalEdgeLabelOverflow = 0;
    var verticalEdgeLabelOverflow = 0;
    axisDimensions.forEach(function (_a, id) {
        var _b = _a.maxLabelBboxWidth, maxLabelBboxWidth = _b === void 0 ? 0 : _b, _c = _a.maxLabelBboxHeight, maxLabelBboxHeight = _c === void 0 ? 0 : _c;
        var _d;
        var axisSpec = spec_1.getSpecsById(axisSpecs, id);
        if (!axisSpec || axisSpec.hide) {
            return;
        }
        var _e = (_d = axesStyles.get(id), (_d !== null && _d !== void 0 ? _d : sharedAxesStyles)), tickLine = _e.tickLine, axisTitle = _e.axisTitle, tickLabel = _e.tickLabel;
        var showTicks = axis_utils_1.shouldShowTicks(tickLine, axisSpec.hide);
        var position = axisSpec.position, title = axisSpec.title;
        var titlePadding = dimensions_1.getSimplePadding(axisTitle.padding);
        var labelPadding = dimensions_1.getSimplePadding(tickLabel.padding);
        var labelPaddingSum = tickLabel.visible ? labelPadding.inner + labelPadding.outer : 0;
        var tickDimension = showTicks ? tickLine.size + tickLine.padding : 0;
        var titleHeight = title !== undefined && axisTitle.visible ? axisTitle.fontSize + titlePadding.outer + titlePadding.inner : 0;
        var axisDimension = labelPaddingSum + tickDimension + titleHeight;
        var maxAxisHeight = tickLabel.visible ? maxLabelBboxHeight + axisDimension : axisDimension;
        var maxAxisWidth = tickLabel.visible ? maxLabelBboxWidth + axisDimension : axisDimension;
        switch (position) {
            case commons_1.Position.Top:
                hTopAxisSpecHeight += maxAxisHeight + chartMargins.top;
                horizontalEdgeLabelOverflow = Math.max(horizontalEdgeLabelOverflow, maxLabelBboxWidth / 2);
                break;
            case commons_1.Position.Bottom:
                hBottomAxisSpecHeight += maxAxisHeight + chartMargins.bottom;
                horizontalEdgeLabelOverflow = Math.max(horizontalEdgeLabelOverflow, maxLabelBboxWidth / 2);
                break;
            case commons_1.Position.Right:
                vRightAxisSpecWidth += maxAxisWidth + chartMargins.right;
                verticalEdgeLabelOverflow = Math.max(verticalEdgeLabelOverflow, maxLabelBboxHeight / 2);
                break;
            case commons_1.Position.Left:
            default:
                vLeftAxisSpecWidth += maxAxisWidth + chartMargins.left;
                verticalEdgeLabelOverflow = Math.max(verticalEdgeLabelOverflow, maxLabelBboxHeight / 2);
        }
    });
    var chartLeftAxisMaxWidth = Math.max(vLeftAxisSpecWidth, horizontalEdgeLabelOverflow + chartMargins.left);
    var chartRightAxisMaxWidth = Math.max(vRightAxisSpecWidth, horizontalEdgeLabelOverflow + chartMargins.right);
    var chartTopAxisMaxHeight = Math.max(hTopAxisSpecHeight, verticalEdgeLabelOverflow + chartMargins.top);
    var chartBottomAxisMaxHeight = Math.max(hBottomAxisSpecHeight, verticalEdgeLabelOverflow + chartMargins.bottom);
    var chartWidth = parentDimensions.width - chartLeftAxisMaxWidth - chartRightAxisMaxWidth;
    var chartHeight = parentDimensions.height - chartTopAxisMaxHeight - chartBottomAxisMaxHeight;
    var top = chartTopAxisMaxHeight + chartPaddings.top;
    var left = chartLeftAxisMaxWidth + chartPaddings.left;
    return {
        leftMargin: chartLeftAxisMaxWidth - vLeftAxisSpecWidth,
        chartDimensions: {
            top: top,
            left: left,
            width: chartWidth - chartPaddings.left - chartPaddings.right,
            height: chartHeight - chartPaddings.top - chartPaddings.bottom,
        },
        offset: {
            top: legendSizing.top,
            left: legendSizing.left,
        },
    };
}
exports.computeChartDimensions = computeChartDimensions;
//# sourceMappingURL=dimensions.js.map