"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../../../utils/commons");
var color_library_wrappers_1 = require("../../../../partition_chart/layout/utils/color_library_wrappers");
var axis_type_utils_1 = require("../../../utils/axis_type_utils");
var line_1 = require("../primitives/line");
function renderTick(ctx, tick, props) {
    var position = props.axisSpec.position, axisPosition = props.axisPosition, tickLine = props.axisStyle.tickLine;
    if (axis_type_utils_1.isVerticalAxis(position)) {
        renderVerticalTick(ctx, position, axisPosition.width, tickLine.size, tick.position, tickLine);
    }
    else {
        renderHorizontalTick(ctx, position, axisPosition.height, tickLine.size, tick.position, tickLine);
    }
}
exports.renderTick = renderTick;
function renderVerticalTick(ctx, position, axisWidth, tickSize, tickPosition, tickStyle) {
    var isLeftAxis = position === commons_1.Position.Left;
    var x1 = isLeftAxis ? axisWidth : 0;
    var x2 = isLeftAxis ? axisWidth - tickSize : tickSize;
    line_1.renderLine(ctx, { x1: x1, y1: tickPosition, x2: x2, y2: tickPosition }, {
        color: color_library_wrappers_1.stringToRGB(tickStyle.stroke),
        width: tickStyle.strokeWidth,
    });
}
function renderHorizontalTick(ctx, position, axisHeight, tickSize, tickPosition, tickStyle) {
    var isTopAxis = position === commons_1.Position.Top;
    var y1 = isTopAxis ? axisHeight - tickSize : 0;
    var y2 = isTopAxis ? axisHeight : tickSize;
    line_1.renderLine(ctx, { x1: tickPosition, y1: y1, x2: tickPosition, y2: y2 }, {
        color: color_library_wrappers_1.stringToRGB(tickStyle.stroke),
        width: tickStyle.strokeWidth,
    });
}
//# sourceMappingURL=tick.js.map