/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final long REG_SUCCESS = 0L;
    private static final int KEY_READ = 131097;
    private static final Preferences userRoot = Preferences.userRoot();
    private static final Preferences systemRoot = Preferences.systemRoot();
    private static final Class<? extends Preferences> userClass = userRoot.getClass();
    private static final Method regOpenKey = WinRegistry.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
    private static final Method regCloseKey = WinRegistry.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
    private static final Method regQueryValueEx = WinRegistry.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
    private static final Method regEnumValue = WinRegistry.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static final Method regQueryInfoKey = WinRegistry.getDeclaredMethod("WindowsRegQueryInfoKey1", Integer.TYPE);
    private static final Method regEnumKeyEx = WinRegistry.getDeclaredMethod("WindowsRegEnumKeyEx", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static boolean java11;

    private static Method getDeclaredMethod(String name, Class<?> ... parameterTypes) {
        try {
            return userClass.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (parameterTypes.length > 0 && parameterTypes[0] == Integer.TYPE) {
                Class<?>[] parameterTypesCopy = Utils.copyArray(parameterTypes);
                parameterTypesCopy[0] = Long.TYPE;
                java11 = true;
                return WinRegistry.getDeclaredMethod(name, parameterTypesCopy);
            }
            Logging.log(Logging.LEVEL_ERROR, "Unable to find WindowsReg method", e);
            return null;
        }
        catch (RuntimeException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to get WindowsReg method", e);
            return null;
        }
    }

    private static Number hkey(int key) {
        return java11 ? (Number)Long.valueOf(key) : (Number)key;
    }

    private WinRegistry() {
    }

    public static String readString(int hkey, String key, String valueName) throws IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WinRegistry.readString(systemRoot, hkey, key, valueName);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readString(userRoot, hkey, key, valueName);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static Map<String, String> readStringValues(int hkey, String key) throws IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WinRegistry.readStringValues(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readStringValues(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    public static List<String> readStringSubKeys(int hkey, String key) throws IllegalAccessException, InvocationTargetException {
        if (hkey == -2147483646) {
            return WinRegistry.readStringSubKeys(systemRoot, hkey, key);
        }
        if (hkey == -2147483647) {
            return WinRegistry.readStringSubKeys(userRoot, hkey, key);
        }
        throw new IllegalArgumentException("hkey=" + hkey);
    }

    private static Number getNumber(Object array, int index) {
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        throw new IllegalArgumentException();
    }

    private static String readString(Preferences root, int hkey, String key, String value) throws IllegalAccessException, InvocationTargetException {
        if (regOpenKey == null || regQueryValueEx == null || regCloseKey == null) {
            return null;
        }
        Object handles = regOpenKey.invoke((Object)root, WinRegistry.hkey(hkey), WinRegistry.toCstr(key), 131097);
        if (WinRegistry.getNumber(handles, 1).longValue() != 0L) {
            return null;
        }
        byte[] valb = (byte[])regQueryValueEx.invoke((Object)root, WinRegistry.getNumber(handles, 0), WinRegistry.toCstr(value));
        regCloseKey.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        return valb != null ? new String(valb, StandardCharsets.UTF_8).trim() : null;
    }

    private static Map<String, String> readStringValues(Preferences root, int hkey, String key) throws IllegalAccessException, InvocationTargetException {
        if (regOpenKey == null || regQueryInfoKey == null || regEnumValue == null || regCloseKey == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        Object handles = regOpenKey.invoke((Object)root, WinRegistry.hkey(hkey), WinRegistry.toCstr(key), 131097);
        if (WinRegistry.getNumber(handles, 1).longValue() != 0L) {
            return Collections.emptyMap();
        }
        Object info = regQueryInfoKey.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        int count = WinRegistry.getNumber(info, 0).intValue();
        int maxlen = WinRegistry.getNumber(info, 3).intValue();
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])regEnumValue.invoke((Object)root, WinRegistry.getNumber(handles, 0), index, maxlen + 1);
            String value = WinRegistry.readString(hkey, key, new String(name, StandardCharsets.UTF_8));
            results.put(new String(name, StandardCharsets.UTF_8).trim(), value);
        }
        regCloseKey.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        return results;
    }

    private static List<String> readStringSubKeys(Preferences root, int hkey, String key) throws IllegalAccessException, InvocationTargetException {
        if (regOpenKey == null || regQueryInfoKey == null || regEnumKeyEx == null || regCloseKey == null) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        Object handles = regOpenKey.invoke((Object)root, WinRegistry.hkey(hkey), WinRegistry.toCstr(key), 131097);
        if (WinRegistry.getNumber(handles, 1).longValue() != 0L) {
            return Collections.emptyList();
        }
        Object info = regQueryInfoKey.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        int count = WinRegistry.getNumber(info, 0).intValue();
        int maxlen = WinRegistry.getNumber(info, 3).intValue();
        for (int index = 0; index < count; ++index) {
            byte[] name = (byte[])regEnumKeyEx.invoke((Object)root, WinRegistry.getNumber(handles, 0), index, maxlen + 1);
            results.add(new String(name, StandardCharsets.UTF_8).trim());
        }
        regCloseKey.invoke((Object)root, WinRegistry.getNumber(handles, 0));
        return results;
    }

    private static byte[] toCstr(String str) {
        byte[] array = str.getBytes(StandardCharsets.UTF_8);
        byte[] biggerCopy = Arrays.copyOf(array, array.length + 1);
        biggerCopy[array.length] = 0;
        return biggerCopy;
    }

    static {
        Utils.setObjectsAccessible(regOpenKey, regCloseKey, regQueryValueEx, regEnumValue, regQueryInfoKey, regEnumKeyEx);
    }
}

