/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.GroupContainsUnknownSourceException;
import org.jitsi.jicofo.conference.source.GroupMsidMismatchException;
import org.jitsi.jicofo.conference.source.InvalidFidGroupException;
import org.jitsi.jicofo.conference.source.InvalidSsrcException;
import org.jitsi.jicofo.conference.source.MsidConflictException;
import org.jitsi.jicofo.conference.source.RequiredParameterMissingException;
import org.jitsi.jicofo.conference.source.Source;
import org.jitsi.jicofo.conference.source.SourceDoesNotExistException;
import org.jitsi.jicofo.conference.source.SourceGroupDoesNotExistException;
import org.jitsi.jicofo.conference.source.SsrcAlreadyUsedException;
import org.jitsi.jicofo.conference.source.SsrcGroup;
import org.jitsi.jicofo.conference.source.SsrcGroupLimitExceededException;
import org.jitsi.jicofo.conference.source.SsrcGroupSemantics;
import org.jitsi.jicofo.conference.source.SsrcLimitExceededException;
import org.jitsi.jicofo.conference.source.ValidationFailedException;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0016J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u0017\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0018\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u0015J\u0018\u0010\u001b\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/jicofo/conference/source/ValidatingConferenceSourceMap;", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "maxSsrcsPerUser", "", "maxSsrcGroupsPerUser", "(II)V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "msidToOwnerMap", "", "", "Lorg/jxmpp/jid/Jid;", "ssrcToOwnerMap", "", "add", "", "other", "owner", "endpointSourceSet", "Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "remove", "sourceSetAdded", "sourceSetRemoved", "tryToAdd", "sourcesToAdd", "tryToRemove", "sourcesToRemove", "Companion", "jicofo"})
public final class ValidatingConferenceSourceMap
extends ConferenceSourceMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxSsrcsPerUser;
    private final int maxSsrcGroupsPerUser;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Long, Jid> ssrcToOwnerMap;
    @NotNull
    private final Map<String, Jid> msidToOwnerMap;

    public ValidatingConferenceSourceMap(int maxSsrcsPerUser, int maxSsrcGroupsPerUser) {
        super(null, 1, null);
        this.maxSsrcsPerUser = maxSsrcsPerUser;
        this.maxSsrcGroupsPerUser = maxSsrcGroupsPerUser;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.ssrcToOwnerMap = new LinkedHashMap();
        this.msidToOwnerMap = new LinkedHashMap();
    }

    public /* synthetic */ ValidatingConferenceSourceMap(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = ConferenceConfig.config.getMaxSsrcsPerUser();
        }
        if ((n3 & 2) != 0) {
            n2 = ConferenceConfig.config.getMaxSsrcGroupsPerUser();
        }
        this(n, n2);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ConferenceSourceMap tryToAdd(@Nullable Jid owner, @NotNull EndpointSourceSet sourcesToAdd) throws ValidationFailedException {
        Intrinsics.checkNotNullParameter(sourcesToAdd, "sourcesToAdd");
        Object object = this.getSyncRoot();
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            EndpointSourceSet endpointSourceSet = (EndpointSourceSet)this.get((Object)owner);
            if (endpointSourceSet == null) {
                endpointSourceSet = EndpointSourceSet.Companion.getEMPTY();
            }
            EndpointSourceSet existingSourceSet = endpointSourceSet;
            Iterable $this$forEach$iv = sourcesToAdd.getSources();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Source source = (Source)element$iv;
                boolean bl2 = false;
                if (source.getSsrc() <= 0L || source.getSsrc() >= 0x100000000L) {
                    throw new InvalidSsrcException(source.getSsrc());
                }
                if (this.ssrcToOwnerMap.containsKey(source.getSsrc())) {
                    throw new SsrcAlreadyUsedException(source.getSsrc());
                }
                if (source.getMsid() != null) {
                    String msid;
                    boolean bl3 = false;
                    if (this.msidToOwnerMap.containsKey(msid) && !Intrinsics.areEqual(this.msidToOwnerMap.get(msid), owner)) {
                        throw new MsidConflictException(msid);
                    }
                }
                if (existingSourceSet.getSources().size() + sourcesToAdd.getSources().size() <= this.maxSsrcsPerUser) continue;
                throw new SsrcLimitExceededException(this.maxSsrcsPerUser);
            }
            Set<Source> acceptedSources = sourcesToAdd.getSources();
            Set<Source> resultingSources = SetsKt.plus(existingSourceSet.getSources(), (Iterable)acceptedSources);
            Iterable $this$map$iv = resultingSources;
            boolean $i$f$map = false;
            Iterable bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Source source = (Source)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(it.getSsrc());
            }
            Set resultingSsrcs = CollectionsKt.toSet((List)destination$iv$iv);
            Set acceptedGroups = new LinkedHashSet();
            Iterable $this$forEach$iv2 = sourcesToAdd.getSsrcGroups();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                SsrcGroup it = (SsrcGroup)element$iv;
                boolean bl5 = false;
                if (it.getSsrcs().isEmpty()) {
                    this.logger.info("Empty group signaled, ignoring.");
                    continue;
                }
                if (existingSourceSet.getSsrcGroups().contains(it)) {
                    this.logger.info("Duplicate group signaled, ignoring.");
                    continue;
                }
                if (!resultingSsrcs.containsAll((Collection)it.getSsrcs())) {
                    throw new GroupContainsUnknownSourceException(it.getSsrcs());
                }
                acceptedGroups.add(it);
            }
            if (existingSourceSet.getSsrcGroups().size() + acceptedGroups.size() > this.maxSsrcGroupsPerUser) {
                throw new SsrcGroupLimitExceededException(this.maxSsrcGroupsPerUser);
            }
            EndpointSourceSet resultingSourceSet = new EndpointSourceSet(resultingSources, SetsKt.plus(existingSourceSet.getSsrcGroups(), acceptedGroups));
            ValidatingConferenceSourceMap.Companion.validateEndpointSourceSet(resultingSourceSet);
            Pair[] pairArray = new Pair[]{TuplesKt.to(owner, new EndpointSourceSet(acceptedSources, acceptedGroups))};
            ConferenceSourceMap acceptedSourceMap = new ConferenceSourceMap(pairArray);
            this.add(acceptedSourceMap);
            ConferenceSourceMap conferenceSourceMap = acceptedSourceMap;
            return conferenceSourceMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final ConferenceSourceMap tryToRemove(@Nullable Jid owner, @NotNull EndpointSourceSet sourcesToRemove) throws ValidationFailedException {
        Intrinsics.checkNotNullParameter(sourcesToRemove, "sourcesToRemove");
        Object object = this.getSyncRoot();
        synchronized (object) {
            void $this$mapTo$iv$iv;
            Object object2;
            Object element$iv2;
            block15: {
                boolean bl = false;
                if (!sourcesToRemove.isEmpty()) break block15;
                ConferenceSourceMap conferenceSourceMap = new ConferenceSourceMap(null, 1, null);
                return conferenceSourceMap;
            }
            EndpointSourceSet existingSources = (EndpointSourceSet)this.get((Object)owner);
            if (existingSources == null || existingSources.isEmpty()) {
                throw new SourceDoesNotExistException(null, 1, null);
            }
            Set sourcesAcceptedToBeRemoved = new LinkedHashSet();
            Iterable $this$forEach$iv = sourcesToRemove.getSources();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Source existingSource;
                Object v0;
                Source source;
                block16: {
                    source = (Source)element$iv2;
                    boolean bl = false;
                    Iterable iterable = existingSources.getSources();
                    Iterator iterator2 = iterable.iterator();
                    while (iterator2.hasNext()) {
                        object2 = iterator2.next();
                        Source it = (Source)object2;
                        boolean bl2 = false;
                        if (!(it.getSsrc() == source.getSsrc())) continue;
                        v0 = object2;
                        break block16;
                    }
                    v0 = null;
                }
                if ((Source)v0 == null) {
                    throw new SourceDoesNotExistException(source.getSsrc());
                }
                sourcesAcceptedToBeRemoved.add(existingSource);
            }
            Iterable $this$map$iv = sourcesAcceptedToBeRemoved;
            boolean $i$f$map22 = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object2 = (Source)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSsrc());
            }
            List ssrcsAcceptedToRemove = (List)destination$iv$iv;
            if (!existingSources.getSsrcGroups().containsAll((Collection)sourcesToRemove.getSsrcGroups())) {
                throw new SourceGroupDoesNotExistException();
            }
            Collection $this$toTypedArray$iv = sourcesToRemove.getSsrcGroups();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            SsrcGroup[] ssrcGroupArray = thisCollection$iv.toArray(new SsrcGroup[0]);
            if (ssrcGroupArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            SsrcGroup[] $i$f$map22 = ssrcGroupArray;
            Set<SsrcGroup> groupsAcceptedToBeRemoved = SetsKt.mutableSetOf(Arrays.copyOf($i$f$map22, $i$f$map22.length));
            Iterable $this$forEach$iv2 = existingSources.getSsrcGroups();
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                boolean bl;
                SsrcGroup existingGroup;
                block17: {
                    existingGroup = (SsrcGroup)element$iv3;
                    boolean bl3 = false;
                    Iterable $this$any$iv = existingGroup.getSsrcs();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv4 : $this$any$iv) {
                            long it = ((Number)element$iv4).longValue();
                            boolean bl4 = false;
                            if (!ssrcsAcceptedToRemove.contains(it)) continue;
                            bl = true;
                            break block17;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                groupsAcceptedToBeRemoved.add(existingGroup);
            }
            EndpointSourceSet resultingEndpointSourceSet = new EndpointSourceSet(SetsKt.minus(existingSources.getSources(), sourcesAcceptedToBeRemoved), SetsKt.minus(existingSources.getSsrcGroups(), (Iterable)groupsAcceptedToBeRemoved));
            ValidatingConferenceSourceMap.Companion.validateEndpointSourceSet(resultingEndpointSourceSet);
            Pair[] pairArray = new Pair[]{TuplesKt.to(owner, new EndpointSourceSet(sourcesAcceptedToBeRemoved, groupsAcceptedToBeRemoved))};
            ConferenceSourceMap acceptedSourceMap = new ConferenceSourceMap(pairArray);
            this.remove(acceptedSourceMap);
            ConferenceSourceMap conferenceSourceMap = acceptedSourceMap;
            return conferenceSourceMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@NotNull ConferenceSourceMap other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Object object = this.getSyncRoot();
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            super.add(other);
            Unit it = unit = Unit.INSTANCE;
            boolean bl2 = false;
            Map $this$forEach$iv = other;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl3 = false;
                Jid owner = (Jid)entry.getKey();
                EndpointSourceSet endpointSourceSet = (EndpointSourceSet)entry.getValue();
                this.sourceSetAdded(owner, endpointSourceSet);
            }
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(@Nullable Jid owner, @NotNull EndpointSourceSet endpointSourceSet) {
        Intrinsics.checkNotNullParameter(endpointSourceSet, "endpointSourceSet");
        Object object = this.getSyncRoot();
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            super.add(owner, endpointSourceSet);
            Unit it = unit = Unit.INSTANCE;
            boolean bl2 = false;
            this.sourceSetAdded(owner, endpointSourceSet);
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sourceSetAdded(Jid owner, EndpointSourceSet endpointSourceSet) {
        Object object = this.getSyncRoot();
        synchronized (object) {
            boolean bl = false;
            Iterable $this$forEach$iv = endpointSourceSet.getSources();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it;
                Source source = (Source)element$iv;
                boolean bl2 = false;
                this.ssrcToOwnerMap.put(source.getSsrc(), owner);
                if (source.getMsid() == null) continue;
                boolean bl3 = false;
                this.msidToOwnerMap.put(it, owner);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NotNull ConferenceSourceMap other) {
        Intrinsics.checkNotNullParameter(other, "other");
        Object object = this.getSyncRoot();
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            super.remove(other);
            Unit it = unit = Unit.INSTANCE;
            boolean bl2 = false;
            Map $this$forEach$iv = other;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl3 = false;
                Jid owner = (Jid)entry.getKey();
                EndpointSourceSet ownerRemovedSourceSet = (EndpointSourceSet)entry.getValue();
                this.sourceSetRemoved(owner, ownerRemovedSourceSet);
            }
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public EndpointSourceSet remove(@Nullable Jid owner) {
        Object object = this.getSyncRoot();
        synchronized (object) {
            EndpointSourceSet ownerRemovedSourceSet;
            boolean bl = false;
            EndpointSourceSet endpointSourceSet = ownerRemovedSourceSet = super.remove(owner);
            if (endpointSourceSet != null) {
                EndpointSourceSet it = endpointSourceSet;
                boolean bl2 = false;
                this.sourceSetRemoved(owner, it);
            }
            EndpointSourceSet endpointSourceSet2 = ownerRemovedSourceSet;
            return endpointSourceSet2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sourceSetRemoved(Jid owner, EndpointSourceSet endpointSourceSet) {
        Object object = this.getSyncRoot();
        synchronized (object) {
            boolean bl = false;
            EndpointSourceSet ownerRemainingSourceSet = (EndpointSourceSet)this.get((Object)owner);
            Iterable $this$forEach$iv = endpointSourceSet.getSources();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String sourceMsid;
                Source source = (Source)element$iv;
                boolean bl2 = false;
                this.ssrcToOwnerMap.remove(source.getSsrc());
                if (source.getMsid() == null) continue;
                boolean bl3 = false;
                if (ownerRemainingSourceSet != null) {
                    boolean bl4;
                    block8: {
                        Iterable $this$none$iv = ownerRemainingSourceSet.getSources();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl4 = true;
                        } else {
                            for (Object element$iv2 : $this$none$iv) {
                                Source it = (Source)element$iv2;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual(it.getMsid(), sourceMsid)) continue;
                                bl4 = false;
                                break block8;
                            }
                            bl4 = true;
                        }
                    }
                    if (!bl4) continue;
                }
                this.msidToOwnerMap.remove(sourceMsid);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public ValidatingConferenceSourceMap() {
        this(0, 0, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jitsi/jicofo/conference/source/ValidatingConferenceSourceMap$Companion;", "", "()V", "groupBySimulcastGroup", "Lorg/jitsi/jicofo/conference/source/SsrcGroup;", "ssrc", "", "ssrcGroups", "", "validateEndpointSourceSet", "", "endpointSourceSet", "Lorg/jitsi/jicofo/conference/source/EndpointSourceSet;", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void validateEndpointSourceSet(EndpointSourceSet endpointSourceSet) throws ValidationFailedException {
            boolean $i$f$forEach22;
            Iterable $this$forEach$iv;
            Object groupMsid;
            Object element$iv;
            Object $this$forEach$iv2 = (MediaType[])endpointSourceSet.getSsrcGroups();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                SsrcGroup group = (SsrcGroup)element$iv;
                boolean bl = false;
                if (group.getSsrcs().isEmpty()) {
                    throw new IllegalStateException("Empty group should have been filtered out.");
                }
                groupMsid = null;
                $this$forEach$iv = group.getSsrcs();
                $i$f$forEach22 = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Source source;
                    Object v0;
                    block17: {
                        long ssrc = ((Number)element$iv2).longValue();
                        boolean bl2 = false;
                        Iterable iterable = endpointSourceSet.getSources();
                        for (Object t : iterable) {
                            Source it = (Source)t;
                            boolean bl3 = false;
                            if (!(it.getSsrc() == ssrc)) continue;
                            v0 = t;
                            break block17;
                        }
                        v0 = null;
                    }
                    if ((Source)v0 == null) {
                        throw new IllegalStateException("Groups with SSRCs that have no corresponding source should have been filtered out.");
                    }
                    if (group.getSemantics() == SsrcGroupSemantics.Fid && group.getSsrcs().size() != 2) {
                        throw new InvalidFidGroupException(group.getSsrcs());
                    }
                    if (source.getMsid() == null) {
                        throw new RequiredParameterMissingException("msid");
                    }
                    if (groupMsid == null) {
                        groupMsid = source.getMsid();
                    }
                    if (Intrinsics.areEqual(source.getMsid(), groupMsid)) continue;
                    throw new GroupMsidMismatchException(group.getSsrcs());
                }
            }
            $this$forEach$iv2 = new MediaType[]{MediaType.AUDIO, MediaType.VIDEO};
            $this$forEach$iv2 = CollectionsKt.listOf($this$forEach$iv2);
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv2.iterator();
            while (iterator2.hasNext()) {
                void $this$mapTo$iv$iv;
                void $this$groupByTo$iv$iv;
                void $this$groupBy$iv;
                Object element$iv$iv2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                element$iv = iterator2.next();
                MediaType mediaType = (MediaType)((Object)element$iv);
                boolean bl = false;
                groupMsid = endpointSourceSet.getSources();
                boolean $i$f$filter = false;
                void $i$f$forEach22 = $this$filter$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    Source it = (Source)element$iv$iv2;
                    boolean bl4 = false;
                    if (!(it.getMediaType() == mediaType && it.getMsid() != null)) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$groupBy = false;
                $this$filterTo$iv$iv = $this$groupBy$iv;
                destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                    Object object;
                    Source it = (Source)element$iv$iv2;
                    boolean bl5 = false;
                    SsrcGroup key$iv$iv = Companion.groupBySimulcastGroup(it.getSsrc(), endpointSourceSet.getSsrcGroups());
                    Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl6 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv2);
                }
                Object grouped = destination$iv$iv;
                Set msidsSeen = new LinkedHashSet();
                Iterable $this$map$iv = grouped.values();
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                element$iv$iv2 = $this$mapTo$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    void it;
                    Object item$iv$iv = element$iv$iv2.next();
                    List bl5 = (List)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl7 = false;
                    collection.add((Source)it.get(0));
                }
                $this$map$iv = (List)destination$iv$iv2;
                $i$f$forEach22 = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Source source = (Source)element$iv2;
                    boolean bl8 = false;
                    if (msidsSeen.contains(source.getMsid())) {
                        String string = source.getMsid();
                        if (string == null) {
                            string = "NONE";
                        }
                        throw new MsidConflictException(string);
                    }
                    msidsSeen.add(source.getMsid());
                }
            }
        }

        private final SsrcGroup groupBySimulcastGroup(long ssrc, Set<SsrcGroup> ssrcGroups) {
            Object v1;
            Object object;
            Object object22;
            block8: {
                Object object3;
                block7: {
                    Iterable iterable = ssrcGroups;
                    for (Object object22 : iterable) {
                        SsrcGroup it = (SsrcGroup)object22;
                        boolean bl = false;
                        if (!(it.getSemantics() == SsrcGroupSemantics.Sim && it.getSsrcs().contains(ssrc))) continue;
                        object3 = object22;
                        break block7;
                    }
                    object3 = null;
                }
                SsrcGroup simGroup = (SsrcGroup)object3;
                if (simGroup != null) {
                    return simGroup;
                }
                Iterable iterable = ssrcGroups;
                object22 = iterable.iterator();
                while (object22.hasNext()) {
                    object = object22.next();
                    SsrcGroup it = (SsrcGroup)object;
                    boolean bl = false;
                    if (!(it.getSemantics() == SsrcGroupSemantics.Fid && it.getSsrcs().contains(ssrc))) continue;
                    v1 = object;
                    break block8;
                }
                v1 = null;
            }
            SsrcGroup fidGroup = v1;
            if (fidGroup != null) {
                if (ssrc == ((Number)fidGroup.getSsrcs().get(1)).longValue()) {
                    Object v2;
                    block9: {
                        object22 = ssrcGroups;
                        object = object22.iterator();
                        while (object.hasNext()) {
                            Object e = object.next();
                            SsrcGroup it = (SsrcGroup)e;
                            boolean bl = false;
                            if (!(it.getSemantics() == SsrcGroupSemantics.Sim && it.getSsrcs().contains(fidGroup.getSsrcs().get(0)))) continue;
                            v2 = e;
                            break block9;
                        }
                        v2 = null;
                    }
                    SsrcGroup simGroup2 = v2;
                    if (simGroup2 != null) {
                        return simGroup2;
                    }
                }
                return fidGroup;
            }
            return new SsrcGroup(SsrcGroupSemantics.Sim, CollectionsKt.listOf(ssrc), null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

