/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.glassfish.jersey.internal.guava.Predicates;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.json.simple.JSONObject;

public abstract class BridgeSelectionStrategy {
    private static final Logger logger = new LoggerImpl(BridgeSelectionStrategy.class.getName());
    private int totalNotLoadedAlreadyInConferenceInRegion;
    private int totalNotLoadedAlreadyInConferenceInRegionGroup;
    private int totalNotLoadedInRegion;
    private int totalNotLoadedInRegionGroup;
    private int totalLeastLoadedAlreadyInConferenceInRegion;
    private int totalLeastLoadedAlreadyInConferenceInRegionGroup;
    private int totalLeastLoadedInRegion;
    private int totalLeastLoadedInRegionGroup;
    private int totalLeastLoadedAlreadyInConference;
    private int totalLeastLoaded;
    private int totalSplitDueToRegion;
    private int totalSplitDueToLoad;
    private final int maxParticipantsPerBridge = BridgeConfig.config.maxBridgeParticipants();

    public Bridge select(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion, boolean allowMultiBridge) {
        if (conferenceBridges.isEmpty()) {
            Bridge bridge2 = this.doSelect(bridges, conferenceBridges, participantRegion);
            if (bridge2 != null) {
                logger.debug("Selected initial bridge " + bridge2 + " with reported stress=" + bridge2.getLastReportedStressLevel() + " for participantRegion=" + participantRegion + " using strategy " + this.getClass().getSimpleName());
            } else {
                logger.warn("Failed to select initial bridge for participantRegion=" + participantRegion);
            }
            return bridge2;
        }
        Bridge existingBridge = (Bridge)conferenceBridges.keySet().stream().findFirst().get();
        if (!allowMultiBridge || existingBridge.getRelayId() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Existing bridge does not have a relay, will not consider other bridges.");
            }
            return existingBridge;
        }
        Bridge bridge3 = this.doSelect(bridges, conferenceBridges, participantRegion);
        if (bridge3 != null) {
            logger.info("Selected bridge " + bridge3 + " with stress=" + bridge3.getLastReportedStressLevel() + " for participantRegion=" + participantRegion);
        } else {
            logger.warn("Failed to select bridge for participantRegion=" + participantRegion);
        }
        return bridge3;
    }

    Optional<Bridge> notLoadedAlreadyInConferenceInRegion(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        Optional<Bridge> result2 = bridges.stream().filter(Predicates.not(b -> this.isOverloaded((Bridge)b, conferenceBridges))).filter(BridgeSelectionStrategy.selectFrom(conferenceBridges.keySet())).filter(BridgeSelectionStrategy.inRegion(participantRegion)).findFirst();
        if (result2.isPresent()) {
            ++this.totalNotLoadedAlreadyInConferenceInRegion;
            this.logSelection(result2.get(), conferenceBridges, participantRegion);
        }
        return result2;
    }

    Optional<Bridge> notLoadedAlreadyInConferenceInRegionGroup(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, Set<String> participantRegionGroup) {
        Optional<Bridge> result2 = bridges.stream().filter(Predicates.not(b -> this.isOverloaded((Bridge)b, conferenceBridges))).filter(BridgeSelectionStrategy.selectFrom(conferenceBridges.keySet())).filter(BridgeSelectionStrategy.inRegionGroup(participantRegionGroup)).findFirst();
        if (result2.isPresent()) {
            ++this.totalNotLoadedAlreadyInConferenceInRegionGroup;
            this.logSelection(result2.get(), conferenceBridges, null, participantRegionGroup);
        }
        return result2;
    }

    private void logSelection(Bridge bridge2, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        this.logSelection(bridge2, conferenceBridges, participantRegion, null);
    }

    private void logSelection(Bridge bridge2, Map<Bridge, Integer> conferenceBridges, String participantRegion, Set<String> participantRegionGroup) {
        String method = Thread.currentThread().getStackTrace()[2].getMethodName();
        logger.debug("Bridge selected: method=" + method + ", participantRegion=" + participantRegion + ", participantRegionGroup=" + participantRegionGroup + ", bridge=" + bridge2 + ", conference_bridges=" + conferenceBridges.keySet().stream().map(Bridge::toString).collect(Collectors.joining(", ")));
    }

    Optional<Bridge> notLoadedInRegion(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        Optional<Bridge> result2 = bridges.stream().filter(Predicates.not(b -> this.isOverloaded((Bridge)b, conferenceBridges))).filter(BridgeSelectionStrategy.inRegion(participantRegion)).findFirst();
        if (result2.isPresent()) {
            ++this.totalNotLoadedInRegion;
            this.updateSplitStats(conferenceBridges, result2.get(), participantRegion);
            this.logSelection(result2.get(), conferenceBridges, participantRegion);
        }
        return result2;
    }

    Optional<Bridge> notLoadedInRegionGroup(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, Set<String> participantRegionGroup) {
        Optional<Bridge> result2 = bridges.stream().filter(Predicates.not(b -> this.isOverloaded((Bridge)b, conferenceBridges))).filter(BridgeSelectionStrategy.inRegionGroup(participantRegionGroup)).findFirst();
        if (result2.isPresent()) {
            ++this.totalNotLoadedInRegionGroup;
            this.updateSplitStats(conferenceBridges, result2.get(), null, participantRegionGroup);
            this.logSelection(result2.get(), conferenceBridges, null, participantRegionGroup);
        }
        return result2;
    }

    private void updateSplitStats(Map<Bridge, Integer> conferenceBridges, Bridge selectedBridge, String participantRegion) {
        this.updateSplitStats(conferenceBridges, selectedBridge, participantRegion, null);
    }

    private void updateSplitStats(Map<Bridge, Integer> conferenceBridges, Bridge selectedBridge, String participantRegion, Set<String> participantRegionGroup) {
        if (!conferenceBridges.isEmpty() && !conferenceBridges.containsKey(selectedBridge)) {
            if (participantRegion != null && conferenceBridges.keySet().stream().anyMatch(BridgeSelectionStrategy.inRegion(participantRegion)) || participantRegionGroup != null && conferenceBridges.keySet().stream().anyMatch(BridgeSelectionStrategy.inRegionGroup(participantRegionGroup))) {
                ++this.totalSplitDueToLoad;
            } else {
                ++this.totalSplitDueToRegion;
            }
        }
    }

    Optional<Bridge> leastLoadedAlreadyInConferenceInRegion(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        Optional<Bridge> result2 = bridges.stream().filter(BridgeSelectionStrategy.selectFrom(conferenceBridges.keySet())).filter(BridgeSelectionStrategy.inRegion(participantRegion)).findFirst();
        if (result2.isPresent()) {
            ++this.totalLeastLoadedAlreadyInConferenceInRegion;
            this.logSelection(result2.get(), conferenceBridges, participantRegion);
        }
        return result2;
    }

    Optional<Bridge> leastLoadedAlreadyInConferenceInRegionGroup(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, Set<String> participantRegionGroup) {
        Optional<Bridge> result2 = bridges.stream().filter(BridgeSelectionStrategy.selectFrom(conferenceBridges.keySet())).filter(BridgeSelectionStrategy.inRegionGroup(participantRegionGroup)).findFirst();
        if (result2.isPresent()) {
            ++this.totalLeastLoadedAlreadyInConferenceInRegionGroup;
            this.logSelection(result2.get(), conferenceBridges, null, participantRegionGroup);
        }
        return result2;
    }

    Optional<Bridge> leastLoadedInRegion(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        Optional<Bridge> result2 = bridges.stream().filter(BridgeSelectionStrategy.inRegion(participantRegion)).findFirst();
        if (result2.isPresent()) {
            ++this.totalLeastLoadedInRegion;
            this.updateSplitStats(conferenceBridges, result2.get(), participantRegion);
            this.logSelection(result2.get(), conferenceBridges, participantRegion);
        }
        return result2;
    }

    Optional<Bridge> leastLoadedInRegionGroup(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, Set<String> participantRegionGroup) {
        Optional<Bridge> result2 = bridges.stream().filter(BridgeSelectionStrategy.inRegionGroup(participantRegionGroup)).findFirst();
        if (result2.isPresent()) {
            ++this.totalLeastLoadedInRegionGroup;
            this.updateSplitStats(conferenceBridges, result2.get(), null, participantRegionGroup);
            this.logSelection(result2.get(), conferenceBridges, null, participantRegionGroup);
        }
        return result2;
    }

    Optional<Bridge> nonLoadedAlreadyInConference(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        Optional<Bridge> result2 = bridges.stream().filter(Predicates.not(b -> this.isOverloaded((Bridge)b, conferenceBridges))).filter(BridgeSelectionStrategy.selectFrom(conferenceBridges.keySet())).findFirst();
        if (result2.isPresent()) {
            ++this.totalLeastLoadedAlreadyInConference;
            this.logSelection(result2.get(), conferenceBridges, participantRegion);
        }
        return result2;
    }

    Optional<Bridge> leastLoaded(List<Bridge> bridges, Map<Bridge, Integer> conferenceBridges, String participantRegion) {
        Optional<Bridge> result2 = bridges.stream().findFirst();
        if (result2.isPresent()) {
            ++this.totalLeastLoaded;
            this.updateSplitStats(conferenceBridges, result2.get(), participantRegion);
            this.logSelection(result2.get(), conferenceBridges, participantRegion);
        }
        return result2;
    }

    abstract Bridge doSelect(List<Bridge> var1, Map<Bridge, Integer> var2, String var3);

    private static Predicate<Bridge> selectFrom(Collection<Bridge> conferenceBridges) {
        return b -> conferenceBridges != null && conferenceBridges.contains(b);
    }

    private static Predicate<Bridge> inRegion(String region) {
        return b -> region != null && region.equalsIgnoreCase(b.getRegion());
    }

    private static Predicate<Bridge> inRegionGroup(@NotNull Set<String> regionGroup) {
        return b -> regionGroup.contains(b.getRegion());
    }

    private boolean isOverloaded(Bridge bridge2, Map<Bridge, Integer> conferenceBridges) {
        return bridge2.isOverloaded() || this.maxParticipantsPerBridge > 0 && conferenceBridges.containsKey(bridge2) && conferenceBridges.get(bridge2) >= this.maxParticipantsPerBridge;
    }

    public JSONObject getStats() {
        JSONObject json = new JSONObject();
        json.put("total_not_loaded_in_region_in_conference", this.totalNotLoadedAlreadyInConferenceInRegion);
        json.put("total_not_loaded_in_region_group_in_conference", this.totalNotLoadedAlreadyInConferenceInRegionGroup);
        json.put("total_not_loaded_in_region", this.totalNotLoadedInRegion);
        json.put("total_not_loaded_in_region_group", this.totalNotLoadedInRegionGroup);
        json.put("total_least_loaded_in_region_in_conference", this.totalLeastLoadedAlreadyInConferenceInRegion);
        json.put("total_least_loaded_in_region_group_in_conference", this.totalLeastLoadedAlreadyInConferenceInRegionGroup);
        json.put("total_least_loaded_in_region", this.totalLeastLoadedInRegion);
        json.put("total_least_loaded_in_region_group", this.totalLeastLoadedInRegionGroup);
        json.put("total_least_loaded_in_conference", this.totalLeastLoadedAlreadyInConference);
        json.put("total_least_loaded", this.totalLeastLoaded);
        json.put("total_split_due_to_region", this.totalSplitDueToRegion);
        json.put("total_split_due_to_load", this.totalSplitDueToLoad);
        return json;
    }
}

