/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.user;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.security.PasswordEncryptionService;
import org.apache.guacamole.auth.jdbc.security.SaltService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.PasswordRecordModel;
import org.apache.guacamole.auth.jdbc.user.UserModel;
import org.apache.guacamole.auth.jdbc.user.UserParentUserGroupSet;
import org.apache.guacamole.auth.jdbc.user.UserRecordSet;
import org.apache.guacamole.auth.jdbc.user.UserService;
import org.apache.guacamole.form.BooleanField;
import org.apache.guacamole.form.DateField;
import org.apache.guacamole.form.EmailField;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.form.TextField;
import org.apache.guacamole.form.TimeField;
import org.apache.guacamole.form.TimeZoneField;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.RelatedObjectSet;
import org.apache.guacamole.net.auth.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeledUser
extends ModeledPermissions<UserModel>
implements User {
    private static final Logger logger = LoggerFactory.getLogger(ModeledUser.class);
    public static final String DISABLED_ATTRIBUTE_NAME = "disabled";
    public static final String EXPIRED_ATTRIBUTE_NAME = "expired";
    public static final String ACCESS_WINDOW_START_ATTRIBUTE_NAME = "access-window-start";
    public static final String ACCESS_WINDOW_END_ATTRIBUTE_NAME = "access-window-end";
    public static final String VALID_FROM_ATTRIBUTE_NAME = "valid-from";
    public static final String VALID_UNTIL_ATTRIBUTE_NAME = "valid-until";
    public static final String TIMEZONE_ATTRIBUTE_NAME = "timezone";
    public static final Form PROFILE = new Form("profile", Arrays.asList(new TextField(User.Attribute.FULL_NAME), new EmailField(User.Attribute.EMAIL_ADDRESS), new TextField(User.Attribute.ORGANIZATION), new TextField(User.Attribute.ORGANIZATIONAL_ROLE)));
    public static final Form ACCOUNT_RESTRICTIONS = new Form("restrictions", Arrays.asList(new BooleanField("disabled", "true"), new BooleanField("expired", "true"), new TimeField("access-window-start"), new TimeField("access-window-end"), new DateField("valid-from"), new DateField("valid-until"), new TimeZoneField("timezone")));
    public static final Collection<Form> ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(PROFILE, ACCOUNT_RESTRICTIONS));
    public static final Set<String> ATTRIBUTE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(User.Attribute.FULL_NAME, User.Attribute.EMAIL_ADDRESS, User.Attribute.ORGANIZATION, User.Attribute.ORGANIZATIONAL_ROLE, "disabled", "expired", "access-window-start", "access-window-end", "valid-from", "valid-until", "timezone")));
    @Inject
    private UserService userService;
    @Inject
    private PasswordEncryptionService encryptionService;
    @Inject
    private SaltService saltService;
    @Inject
    private Provider<UserParentUserGroupSet> parentUserGroupSetProvider;
    @Inject
    private Provider<UserRecordSet> userRecordSetProvider;
    private boolean exposeRestrictedAttributes = false;
    private String password = null;
    private PasswordRecordModel passwordRecord = null;

    public void init(ModeledAuthenticatedUser currentUser, UserModel model, boolean exposeRestrictedAttributes) {
        super.init(currentUser, model);
        this.exposeRestrictedAttributes = exposeRestrictedAttributes;
    }

    @Override
    public void setModel(UserModel model) {
        super.setModel(model);
        if (model.getPasswordHash() != null) {
            this.passwordRecord = new PasswordRecordModel(model);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        UserModel userModel = (UserModel)this.getModel();
        this.password = password;
        if (password == null) {
            userModel.setPasswordSalt(this.saltService.generateSalt());
            userModel.setPasswordHash(this.saltService.generateSalt());
        } else {
            byte[] salt = this.saltService.generateSalt();
            byte[] hash = this.encryptionService.createPasswordHash(password, salt);
            userModel.setPasswordSalt(salt);
            userModel.setPasswordHash(hash);
        }
        userModel.setPasswordDate(new Timestamp(System.currentTimeMillis()));
    }

    public PasswordRecordModel getPasswordRecord() {
        return this.passwordRecord;
    }

    private void putRestrictedAttributes(Map<String, String> attributes) {
        attributes.put(DISABLED_ATTRIBUTE_NAME, ((UserModel)this.getModel()).isDisabled() ? "true" : null);
        attributes.put(EXPIRED_ATTRIBUTE_NAME, ((UserModel)this.getModel()).isExpired() ? "true" : null);
        attributes.put(ACCESS_WINDOW_START_ATTRIBUTE_NAME, TimeField.format((java.util.Date)((UserModel)this.getModel()).getAccessWindowStart()));
        attributes.put(ACCESS_WINDOW_END_ATTRIBUTE_NAME, TimeField.format((java.util.Date)((UserModel)this.getModel()).getAccessWindowEnd()));
        attributes.put(VALID_FROM_ATTRIBUTE_NAME, DateField.format((java.util.Date)((UserModel)this.getModel()).getValidFrom()));
        attributes.put(VALID_UNTIL_ATTRIBUTE_NAME, DateField.format((java.util.Date)((UserModel)this.getModel()).getValidUntil()));
        attributes.put(TIMEZONE_ATTRIBUTE_NAME, ((UserModel)this.getModel()).getTimeZone());
    }

    private void putUnrestrictedAttributes(Map<String, String> attributes) {
        attributes.put(User.Attribute.FULL_NAME, ((UserModel)this.getModel()).getFullName());
        attributes.put(User.Attribute.EMAIL_ADDRESS, ((UserModel)this.getModel()).getEmailAddress());
        attributes.put(User.Attribute.ORGANIZATION, ((UserModel)this.getModel()).getOrganization());
        attributes.put(User.Attribute.ORGANIZATIONAL_ROLE, ((UserModel)this.getModel()).getOrganizationalRole());
    }

    private Date parseDate(String dateString) throws ParseException {
        java.util.Date parsedDate = DateField.parse((String)dateString);
        if (parsedDate == null) {
            return null;
        }
        return new Date(parsedDate.getTime());
    }

    private Time parseTime(String timeString) throws ParseException {
        java.util.Date parsedDate = TimeField.parse((String)timeString);
        if (parsedDate == null) {
            return null;
        }
        return new Time(parsedDate.getTime());
    }

    private void setRestrictedAttributes(Map<String, String> attributes) {
        if (attributes.containsKey(DISABLED_ATTRIBUTE_NAME)) {
            ((UserModel)this.getModel()).setDisabled("true".equals(attributes.get(DISABLED_ATTRIBUTE_NAME)));
        }
        if (attributes.containsKey(EXPIRED_ATTRIBUTE_NAME)) {
            ((UserModel)this.getModel()).setExpired("true".equals(attributes.get(EXPIRED_ATTRIBUTE_NAME)));
        }
        if (attributes.containsKey(ACCESS_WINDOW_START_ATTRIBUTE_NAME)) {
            try {
                ((UserModel)this.getModel()).setAccessWindowStart(this.parseTime(attributes.get(ACCESS_WINDOW_START_ATTRIBUTE_NAME)));
            }
            catch (ParseException e) {
                logger.warn("Not setting start time of user access window: {}", (Object)e.getMessage());
                logger.debug("Unable to parse time attribute.", (Throwable)e);
            }
        }
        if (attributes.containsKey(ACCESS_WINDOW_END_ATTRIBUTE_NAME)) {
            try {
                ((UserModel)this.getModel()).setAccessWindowEnd(this.parseTime(attributes.get(ACCESS_WINDOW_END_ATTRIBUTE_NAME)));
            }
            catch (ParseException e) {
                logger.warn("Not setting end time of user access window: {}", (Object)e.getMessage());
                logger.debug("Unable to parse time attribute.", (Throwable)e);
            }
        }
        if (attributes.containsKey(VALID_FROM_ATTRIBUTE_NAME)) {
            try {
                ((UserModel)this.getModel()).setValidFrom(this.parseDate(attributes.get(VALID_FROM_ATTRIBUTE_NAME)));
            }
            catch (ParseException e) {
                logger.warn("Not setting user validity start date: {}", (Object)e.getMessage());
                logger.debug("Unable to parse date attribute.", (Throwable)e);
            }
        }
        if (attributes.containsKey(VALID_UNTIL_ATTRIBUTE_NAME)) {
            try {
                ((UserModel)this.getModel()).setValidUntil(this.parseDate(attributes.get(VALID_UNTIL_ATTRIBUTE_NAME)));
            }
            catch (ParseException e) {
                logger.warn("Not setting user validity end date: {}", (Object)e.getMessage());
                logger.debug("Unable to parse date attribute.", (Throwable)e);
            }
        }
        if (attributes.containsKey(TIMEZONE_ATTRIBUTE_NAME)) {
            ((UserModel)this.getModel()).setTimeZone(TimeZoneField.parse((String)attributes.get(TIMEZONE_ATTRIBUTE_NAME)));
        }
    }

    private void setUnrestrictedAttributes(Map<String, String> attributes) {
        if (attributes.containsKey(User.Attribute.FULL_NAME)) {
            ((UserModel)this.getModel()).setFullName(TextField.parse((String)attributes.get(User.Attribute.FULL_NAME)));
        }
        if (attributes.containsKey(User.Attribute.EMAIL_ADDRESS)) {
            ((UserModel)this.getModel()).setEmailAddress(TextField.parse((String)attributes.get(User.Attribute.EMAIL_ADDRESS)));
        }
        if (attributes.containsKey(User.Attribute.ORGANIZATION)) {
            ((UserModel)this.getModel()).setOrganization(TextField.parse((String)attributes.get(User.Attribute.ORGANIZATION)));
        }
        if (attributes.containsKey(User.Attribute.ORGANIZATIONAL_ROLE)) {
            ((UserModel)this.getModel()).setOrganizationalRole(TextField.parse((String)attributes.get(User.Attribute.ORGANIZATIONAL_ROLE)));
        }
    }

    @Override
    public Set<String> getSupportedAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    @Override
    public Map<String, String> getAttributes() {
        Map<String, String> attributes = super.getAttributes();
        this.putUnrestrictedAttributes(attributes);
        if (this.exposeRestrictedAttributes) {
            this.putRestrictedAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        super.setAttributes(attributes);
        this.setUnrestrictedAttributes(attributes);
        if (this.exposeRestrictedAttributes) {
            this.setRestrictedAttributes(attributes);
        }
    }

    private TimeZone getTimeZone() {
        String timeZone = ((UserModel)this.getModel()).getTimeZone();
        if (timeZone == null) {
            return TimeZone.getDefault();
        }
        return TimeZone.getTimeZone(timeZone);
    }

    private Calendar asCalendar(Calendar base, Time time) {
        Calendar timeCalendar = Calendar.getInstance();
        timeCalendar.setTime(time);
        base.set(11, timeCalendar.get(11));
        base.set(12, timeCalendar.get(12));
        base.set(13, timeCalendar.get(13));
        base.set(14, timeCalendar.get(14));
        return base;
    }

    private Calendar getAccessWindowStart() {
        Time start = ((UserModel)this.getModel()).getAccessWindowStart();
        if (start == null) {
            return null;
        }
        return this.asCalendar(Calendar.getInstance(this.getTimeZone()), start);
    }

    private Calendar getAccessWindowEnd() {
        Time end = ((UserModel)this.getModel()).getAccessWindowEnd();
        if (end == null) {
            return null;
        }
        return this.asCalendar(Calendar.getInstance(this.getTimeZone()), end);
    }

    private Calendar getValidFrom() {
        Date validFrom = ((UserModel)this.getModel()).getValidFrom();
        if (validFrom == null) {
            return null;
        }
        Calendar validFromCalendar = Calendar.getInstance(this.getTimeZone());
        validFromCalendar.setTime(validFrom);
        validFromCalendar.set(11, 0);
        validFromCalendar.set(12, 0);
        validFromCalendar.set(13, 0);
        validFromCalendar.set(14, 0);
        return validFromCalendar;
    }

    private Calendar getValidUntil() {
        Date validUntil = ((UserModel)this.getModel()).getValidUntil();
        if (validUntil == null) {
            return null;
        }
        Calendar validUntilCalendar = Calendar.getInstance(this.getTimeZone());
        validUntilCalendar.setTime(validUntil);
        validUntilCalendar.set(11, 23);
        validUntilCalendar.set(12, 59);
        validUntilCalendar.set(13, 59);
        validUntilCalendar.set(14, 999);
        return validUntilCalendar;
    }

    private boolean isActive(Calendar activeStart, Calendar inactiveStart) {
        if (inactiveStart != null && activeStart != null && inactiveStart.before(activeStart)) {
            return !this.isActive(inactiveStart, activeStart);
        }
        Calendar current = Calendar.getInstance();
        return !(activeStart != null && current.before(activeStart) || inactiveStart != null && current.after(inactiveStart));
    }

    public boolean isAccountValid() {
        return this.isActive(this.getValidFrom(), this.getValidUntil());
    }

    public boolean isAccountAccessible() {
        return this.isActive(this.getAccessWindowStart(), this.getAccessWindowEnd());
    }

    public boolean isDisabled() {
        return ((UserModel)this.getModel()).isDisabled();
    }

    public boolean isExpired() {
        return ((UserModel)this.getModel()).isExpired();
    }

    public Timestamp getLastActive() {
        return ((UserModel)this.getModel()).getLastActive();
    }

    public ActivityRecordSet<ActivityRecord> getUserHistory() throws GuacamoleException {
        UserRecordSet userRecordSet = this.userRecordSetProvider.get();
        userRecordSet.init(this.getCurrentUser(), this.getIdentifier());
        return userRecordSet;
    }

    public RelatedObjectSet getUserGroups() throws GuacamoleException {
        UserParentUserGroupSet parentUserGroupSet = this.parentUserGroupSetProvider.get();
        parentUserGroupSet.init(this.getCurrentUser(), this);
        return parentUserGroupSet;
    }

    public Permissions getEffectivePermissions() throws GuacamoleException {
        return super.getEffective();
    }

    public boolean isSkeleton() {
        return ((UserModel)this.getModel()).getEntityID() == null;
    }
}

