/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.connectiongroup;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.connection.ConnectionService;
import org.apache.guacamole.auth.jdbc.connectiongroup.ConnectionGroupService;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.protocol.GuacamoleClientInformation;

public class RootConnectionGroup
extends RestrictedObject
implements ConnectionGroup {
    public static final String IDENTIFIER = "ROOT";
    public static final String NAME = "ROOT";
    @Inject
    private ConnectionService connectionService;
    @Inject
    private ConnectionGroupService connectionGroupService;

    public String getName() {
        return "ROOT";
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("The root connection group cannot be modified.");
    }

    public String getParentIdentifier() {
        return null;
    }

    public void setParentIdentifier(String parentIdentifier) {
        throw new UnsupportedOperationException("The root connection group cannot be modified.");
    }

    public ConnectionGroup.Type getType() {
        return ConnectionGroup.Type.ORGANIZATIONAL;
    }

    public void setType(ConnectionGroup.Type type) {
        throw new UnsupportedOperationException("The root connection group cannot be modified.");
    }

    public Set<String> getConnectionIdentifiers() throws GuacamoleException {
        return this.connectionService.getIdentifiersWithin(this.getCurrentUser(), null);
    }

    public Set<String> getConnectionGroupIdentifiers() throws GuacamoleException {
        return this.connectionGroupService.getIdentifiersWithin(this.getCurrentUser(), null);
    }

    public String getIdentifier() {
        return "ROOT";
    }

    public void setIdentifier(String identifier) {
        throw new UnsupportedOperationException("The root connection group cannot be modified.");
    }

    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        throw new GuacamoleSecurityException("Permission denied.");
    }

    public int getActiveConnections() {
        return 0;
    }

    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    public void setAttributes(Map<String, String> attributes) {
        throw new UnsupportedOperationException("The root connection group cannot be modified.");
    }
}

