/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.MappedTableColumn;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.table.MappedProgramLocationTableColumn;
import ghidra.util.table.ProgramLocationTableRowMapper;
import ghidra.util.table.field.ProgramLocationTableColumn;

public class VTMatchSourceAddressToAddressTableRowMapper
extends ProgramLocationTableRowMapper<VTMatch, Address> {
    public <COLUMN_TYPE> DynamicTableColumn<VTMatch, COLUMN_TYPE, Program> createMappedTableColumn(DynamicTableColumn<Address, COLUMN_TYPE, Program> sourceColumn) {
        if (sourceColumn instanceof ProgramLocationTableColumn) {
            ProgramLocationTableColumn programColumn = (ProgramLocationTableColumn)sourceColumn;
            return new VTMatchSourceWrappedMappedProgramLocationTableColumn(this, programColumn);
        }
        return new VTMatchSourceWrappedMappedTableColumn<COLUMN_TYPE>(this, sourceColumn);
    }

    public Address map(VTMatch rowObject, Program program, ServiceProvider serviceProvider) {
        VTAssociation association = rowObject.getAssociation();
        return association.getSourceAddress();
    }

    private class VTMatchSourceWrappedMappedTableColumn<COLUMN_TYPE>
    extends MappedTableColumn<VTMatch, Address, COLUMN_TYPE, Program> {
        public VTMatchSourceWrappedMappedTableColumn(ProgramLocationTableRowMapper<VTMatch, Address> mapper, DynamicTableColumn<Address, COLUMN_TYPE, Program> tableColumn) {
            super(mapper, tableColumn, "VTMatchSource." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Source " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a match's Source address)";
        }

        public String getColumnName() {
            return "Source " + super.getColumnName();
        }
    }

    private class VTMatchSourceWrappedMappedProgramLocationTableColumn<COLUMN_TYPE>
    extends MappedProgramLocationTableColumn<VTMatch, Address, COLUMN_TYPE> {
        public VTMatchSourceWrappedMappedProgramLocationTableColumn(ProgramLocationTableRowMapper<VTMatch, Address> mapper, ProgramLocationTableColumn<Address, COLUMN_TYPE> tableColumn) {
            super(mapper, tableColumn, "VTMatchSource." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Source " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a match's Source address)";
        }

        public String getColumnName() {
            return "Source " + super.getColumnName();
        }
    }
}

