/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.provider.impliedmatches.VTImpliedMatchInfo;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CreateImpliedMatchesTask
extends VtTask {
    private final List<VTImpliedMatchInfo> matches;
    private final VTController controller;
    private List<VTMatch> createdMatches;

    public CreateImpliedMatchesTask(VTController controller, List<VTImpliedMatchInfo> matches) {
        super("Create Implied Matches", controller.getSession());
        this.controller = controller;
        this.matches = matches;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) {
        Set<VTImpliedMatchInfo> set = this.dedupMatches();
        monitor.initialize((long)set.size());
        monitor.setMessage("Creating implied matches");
        VTMatchSet impliedMatchSet = this.controller.getSession().getImpliedMatchSet();
        ArrayList<VTMatch> result = new ArrayList<VTMatch>();
        for (VTImpliedMatchInfo vtImpliedMatch : set) {
            result.add(impliedMatchSet.addMatch(vtImpliedMatch));
            monitor.incrementProgress(1L);
        }
        return true;
    }

    public List<VTMatch> getCreatedMatches() {
        return Collections.unmodifiableList(this.createdMatches);
    }

    private Set<VTImpliedMatchInfo> dedupMatches() {
        HashSet<VTImpliedMatchInfo> set = new HashSet<VTImpliedMatchInfo>();
        set.addAll(this.matches);
        return set;
    }
}

