/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.support;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.FieldLocation;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.math.BigInteger;
import javax.swing.JComponent;

public class AnchoredLayout
implements Layout {
    private int yPos;
    private final Layout layout;
    private final BigInteger index;

    public AnchoredLayout(Layout layout, BigInteger index, int yPos) {
        this.layout = layout;
        this.index = index;
        this.yPos = yPos;
    }

    public int getYPos() {
        return this.yPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle rect, LayoutBackgroundColorManager layoutSelectionMap, FieldLocation cursorLocation) {
        g.translate(0, this.yPos);
        rect.y -= this.yPos;
        try {
            this.layout.paint(c, g, context, rect, layoutSelectionMap, cursorLocation);
        }
        finally {
            g.translate(0, -this.yPos);
            rect.y += this.yPos;
        }
    }

    public void setYPos(int yPos) {
        this.yPos = yPos;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    @Override
    public int getHeight() {
        return this.layout.getHeight();
    }

    @Override
    public int getCompressableWidth() {
        return this.layout.getCompressableWidth();
    }

    @Override
    public int getScrollableUnitIncrement(int y, int direction) {
        return this.layout.getScrollableUnitIncrement(y, direction);
    }

    public int getEndY() {
        return this.yPos + this.layout.getHeight();
    }

    public String toString() {
        return this.index.toString() + " (ypos = " + this.yPos + ")";
    }

    @Override
    public boolean contains(int y) {
        return y >= this.yPos && y < this.yPos + this.layout.getHeight();
    }

    @Override
    public int cursorBeginning(FieldLocation cursorLoc) {
        return this.layout.cursorBeginning(cursorLoc);
    }

    @Override
    public boolean cursorDown(FieldLocation cursorLoc, int lastX) {
        return this.layout.cursorDown(cursorLoc, lastX);
    }

    @Override
    public int cursorEnd(FieldLocation cursorLoc) {
        return this.layout.cursorEnd(cursorLoc);
    }

    @Override
    public int cursorLeft(FieldLocation cursorLoc) {
        return this.layout.cursorLeft(cursorLoc);
    }

    @Override
    public int cursorRight(FieldLocation cursorLoc) {
        return this.layout.cursorRight(cursorLoc);
    }

    @Override
    public boolean cursorUp(FieldLocation cursorLoc, int lastX) {
        return this.layout.cursorUp(cursorLoc, lastX);
    }

    @Override
    public boolean enterLayout(FieldLocation cursorLoc, int lastX, boolean fromTop) {
        cursorLoc.setIndex(this.index);
        return this.layout.enterLayout(cursorLoc, lastX, fromTop);
    }

    @Override
    public int getBeginRowFieldNum(int field1) {
        return this.layout.getBeginRowFieldNum(field1);
    }

    @Override
    public Rectangle getCursorRect(int fieldNum, int row, int col) {
        Rectangle rect = this.layout.getCursorRect(fieldNum, row, col);
        if (rect == null) {
            rect = new Rectangle(4, 4);
        }
        rect.y += this.yPos;
        return rect;
    }

    @Override
    public int getEndRowFieldNum(int field2) {
        return this.layout.getEndRowFieldNum(field2);
    }

    @Override
    public Field getField(int fieldIndex) {
        try {
            return this.layout.getField(fieldIndex);
        }
        catch (RuntimeException e) {
            if (fieldIndex < 0 || fieldIndex >= this.layout.getNumFields()) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Rectangle getFieldBounds(int fieldIndex) {
        Rectangle r = this.layout.getFieldBounds(fieldIndex);
        r.y += this.yPos;
        return r;
    }

    @Override
    public int getIndexSize() {
        return this.layout.getIndexSize();
    }

    @Override
    public int getNumFields() {
        return this.layout.getNumFields();
    }

    @Override
    public int getPrimaryOffset() {
        return this.layout.getPrimaryOffset();
    }

    @Override
    public void insertSpaceAbove(int size) {
        this.layout.insertSpaceAbove(size);
    }

    @Override
    public void insertSpaceBelow(int size) {
        this.layout.insertSpaceBelow(size);
    }

    @Override
    public int setCursor(FieldLocation cursorLoc, int x, int y) {
        cursorLoc.setIndex(this.index);
        return this.layout.setCursor(cursorLoc, x, y - this.yPos);
    }
}

