/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.field;

import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;

public class CompositeFieldElement
implements FieldElement {
    private FieldElement[] fieldElements;
    private int heightAbove = -1;
    private int heightBelow = -1;
    private int textWidth = -1;
    private String fullText;

    public CompositeFieldElement(List<? extends FieldElement> stringList) {
        this(stringList.toArray(new FieldElement[stringList.size()]));
    }

    public CompositeFieldElement(FieldElement[] fieldElements) {
        this.fieldElements = fieldElements;
    }

    public CompositeFieldElement(FieldElement[] elements, int start, int length) {
        this.fieldElements = new FieldElement[length];
        System.arraycopy(elements, start, this.fieldElements, 0, length);
    }

    private IndexedOffset getIndexedOffsetForCharPosition(int charPosition) {
        int n = 0;
        for (int i = 0; i < this.fieldElements.length; ++i) {
            int len = this.fieldElements[i].getText().length();
            if (charPosition < n + len) {
                return new IndexedOffset(i, charPosition - n);
            }
            n += len;
        }
        return new IndexedOffset(this.fieldElements.length - 1, this.fieldElements[this.fieldElements.length - 1].getText().length());
    }

    @Override
    public int getMaxCharactersForWidth(int width) {
        int remainingWidth = width;
        int totalCharacters = 0;
        for (FieldElement fieldElement : this.fieldElements) {
            int nextWidth = fieldElement.getStringWidth();
            if (nextWidth >= remainingWidth) {
                totalCharacters += fieldElement.getMaxCharactersForWidth(remainingWidth);
                break;
            }
            remainingWidth -= nextWidth;
            totalCharacters += fieldElement.length();
        }
        return totalCharacters;
    }

    @Override
    public Color getColor(int index) {
        IndexedOffset pos = this.getIndexedOffsetForCharPosition(index);
        return this.fieldElements[pos.index].getColor(pos.offset);
    }

    @Override
    public char charAt(int index) {
        IndexedOffset pos = this.getIndexedOffsetForCharPosition(index);
        return this.fieldElements[pos.index].charAt(pos.offset);
    }

    @Override
    public int getHeightAbove() {
        if (this.heightAbove < 0) {
            this.heightAbove = 0;
            for (FieldElement fieldElement : this.fieldElements) {
                this.heightAbove = Math.max(this.heightAbove, fieldElement.getHeightAbove());
            }
        }
        return this.heightAbove;
    }

    @Override
    public int getHeightBelow() {
        if (this.heightBelow < 0) {
            this.heightBelow = 0;
            for (FieldElement fieldElement : this.fieldElements) {
                this.heightBelow = Math.max(this.heightBelow, fieldElement.getHeightBelow());
            }
        }
        return this.heightBelow;
    }

    @Override
    public int getStringWidth() {
        if (this.textWidth == -1) {
            this.textWidth = 0;
            for (FieldElement fieldElement : this.fieldElements) {
                this.textWidth += fieldElement.getStringWidth();
            }
        }
        return this.textWidth;
    }

    @Override
    public String getText() {
        if (this.fullText == null) {
            StringBuffer buffer = new StringBuffer();
            for (FieldElement fieldElement : this.fieldElements) {
                buffer.append(fieldElement.getText());
            }
            this.fullText = buffer.toString();
        }
        return this.fullText;
    }

    @Override
    public void paint(JComponent c, Graphics g, int x, int y) {
        int xPos = x;
        for (FieldElement fieldElement : this.fieldElements) {
            fieldElement.paint(c, g, xPos, y);
            xPos += fieldElement.getStringWidth();
        }
    }

    @Override
    public FieldElement replaceAll(char[] targets, char repacement) {
        FieldElement[] newStrings = new FieldElement[this.fieldElements.length];
        for (int i = 0; i < this.fieldElements.length; ++i) {
            newStrings[i] = this.fieldElements[i].replaceAll(targets, repacement);
        }
        return new CompositeFieldElement(newStrings);
    }

    @Override
    public FieldElement substring(int start) {
        return this.substring(start, this.getText().length());
    }

    @Override
    public FieldElement substring(int start, int end) {
        IndexedOffset startPos = this.getIndexedOffsetForCharPosition(start);
        IndexedOffset endPos = this.getIndexedOffsetForCharPosition(end);
        if (startPos.index == endPos.index) {
            FieldElement asStart = this.fieldElements[startPos.index];
            return asStart.substring(startPos.offset, endPos.offset);
        }
        FieldElement asStart = this.fieldElements[startPos.index];
        FieldElement newStart = asStart.substring(startPos.offset);
        FieldElement asEnd = this.fieldElements[endPos.index];
        FieldElement newEnd = asEnd.substring(0, endPos.offset);
        FieldElement[] newStrings = new FieldElement[endPos.index - startPos.index + 1];
        System.arraycopy(this.fieldElements, startPos.index + 1, newStrings, 1, newStrings.length - 1);
        newStrings[0] = newStart;
        newStrings[newStrings.length - 1] = newEnd;
        return new CompositeFieldElement(newStrings);
    }

    @Override
    public FieldElement getFieldElement(int column) {
        IndexedOffset startPos = this.getIndexedOffsetForCharPosition(column);
        return this.fieldElements[startPos.index].getFieldElement(startPos.offset);
    }

    @Override
    public int length() {
        return this.getText().length();
    }

    @Override
    public RowColLocation getDataLocationForCharacterIndex(int characterIndex) {
        IndexedOffset startPos = this.getIndexedOffsetForCharPosition(characterIndex);
        return this.fieldElements[startPos.index].getDataLocationForCharacterIndex(startPos.offset);
    }

    @Override
    public int getCharacterIndexForDataLocation(int dataRow, int dataColumn) {
        int columnCount = 0;
        for (int i = this.fieldElements.length - 1; i >= 0; --i) {
            columnCount += this.fieldElements[i].length();
            int column = this.fieldElements[i].getCharacterIndexForDataLocation(dataRow, dataColumn);
            if (column == -1) continue;
            return this.length() - columnCount + column;
        }
        return -1;
    }

    private static class IndexedOffset {
        int index;
        int offset;

        IndexedOffset(int index, int offset) {
            this.index = index;
            this.offset = offset;
        }
    }
}

