/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.EncodedStringField;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.jparted.lib.ps.PartitionType;
import org.catacombae.jparted.lib.ps.gpt.GPTPartitionType;

public class GPTEntry
implements Partition,
StructElements {
    protected final byte[] partitionTypeGUID = new byte[16];
    protected final byte[] uniquePartitionGUID = new byte[16];
    protected final byte[] startingLBA = new byte[8];
    protected final byte[] endingLBA = new byte[8];
    protected final byte[] attributeBits = new byte[8];
    protected final byte[] partitionName = new byte[72];
    private final int blockSize;

    public GPTEntry(byte[] data, int offset, int blockSize) {
        this(blockSize);
        System.arraycopy(data, offset + 0, this.partitionTypeGUID, 0, 16);
        System.arraycopy(data, offset + 16, this.uniquePartitionGUID, 0, 16);
        System.arraycopy(data, offset + 32, this.startingLBA, 0, 8);
        System.arraycopy(data, offset + 40, this.endingLBA, 0, 8);
        System.arraycopy(data, offset + 48, this.attributeBits, 0, 8);
        System.arraycopy(data, offset + 56, this.partitionName, 0, 72);
    }

    protected GPTEntry(int blockSize) {
        this.blockSize = blockSize;
    }

    public GPTEntry(GPTEntry source) {
        this(source.blockSize);
        this.copyFields(source);
    }

    protected void copyFields(GPTEntry source) {
        System.arraycopy(source.partitionTypeGUID, 0, this.partitionTypeGUID, 0, this.partitionTypeGUID.length);
        System.arraycopy(source.uniquePartitionGUID, 0, this.uniquePartitionGUID, 0, this.uniquePartitionGUID.length);
        System.arraycopy(source.startingLBA, 0, this.startingLBA, 0, this.startingLBA.length);
        System.arraycopy(source.endingLBA, 0, this.endingLBA, 0, this.endingLBA.length);
        System.arraycopy(source.attributeBits, 0, this.attributeBits, 0, this.attributeBits.length);
        System.arraycopy(source.partitionName, 0, this.partitionName, 0, this.partitionName.length);
    }

    public long getStartOffset() {
        return this.getStartingLBA() * (long)this.blockSize;
    }

    public long getLength() {
        return this.getEndingLBA() * (long)this.blockSize - this.getStartOffset();
    }

    public PartitionType getType() {
        return GPTEntry.convertPartitionType(this.getPartitionTypeGUIDAsEnum());
    }

    public static int getSize() {
        return 128;
    }

    public byte[] getPartitionTypeGUID() {
        return Util.createCopy((byte[])this.partitionTypeGUID);
    }

    public byte[] getUniquePartitionGUID() {
        return Util.createCopy((byte[])this.uniquePartitionGUID);
    }

    public long getStartingLBA() {
        return Util.readLongLE((byte[])this.startingLBA);
    }

    public long getEndingLBA() {
        return Util.readLongLE((byte[])this.endingLBA);
    }

    public long getAttributeBits() {
        return Util.readLongBE((byte[])this.attributeBits);
    }

    public byte[] getPartitionName() {
        return Util.createCopy((byte[])this.partitionName);
    }

    public GPTPartitionType getPartitionTypeGUIDAsEnum() {
        return GPTPartitionType.getType(Util.readLongBE((byte[])this.partitionTypeGUID, (int)0), Util.readLongBE((byte[])this.partitionTypeGUID, (int)8));
    }

    public String getPartitionNameAsString() {
        int stringLength = 0;
        for (int i = 0; i < this.partitionName.length && (this.partitionName[i] != 0 || this.partitionName[i + 1] != 0); i += 2) {
            stringLength += 2;
        }
        return Util.readString((byte[])this.partitionName, (int)0, (int)stringLength, (String)"UTF-16LE");
    }

    public boolean isUsed() {
        return this.getPartitionTypeGUIDAsEnum() != GPTPartitionType.PARTITION_TYPE_UNUSED_ENTRY;
    }

    public String toString() {
        return "\"" + this.getPartitionNameAsString() + "\" (" + (Object)((Object)this.getPartitionTypeGUIDAsEnum()) + ")";
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " partitionTypeGUID: " + GPTEntry.getGUIDAsString(this.getPartitionTypeGUID()) + " (" + (Object)((Object)this.getPartitionTypeGUIDAsEnum()) + ")");
        ps.println(prefix + " uniquePartitionGUID: " + GPTEntry.getGUIDAsString(this.getUniquePartitionGUID()));
        ps.println(prefix + " startingLBA: " + this.getStartingLBA());
        ps.println(prefix + " endingLBA: " + this.getEndingLBA());
        ps.println(prefix + " attributeBits: " + this.getAttributeBits());
        ps.println(prefix + " partitionName: " + this.getPartitionNameAsString());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "GPTEntry:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[128];
        int offset = 0;
        System.arraycopy(this.partitionTypeGUID, 0, result, offset, this.partitionTypeGUID.length);
        System.arraycopy(this.uniquePartitionGUID, 0, result, offset += 16, this.uniquePartitionGUID.length);
        System.arraycopy(this.startingLBA, 0, result, offset += 16, this.startingLBA.length);
        System.arraycopy(this.endingLBA, 0, result, offset += 8, this.endingLBA.length);
        System.arraycopy(this.attributeBits, 0, result, offset += 8, this.attributeBits.length);
        System.arraycopy(this.partitionName, 0, result, offset += 8, this.partitionName.length);
        offset += 72;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GPTEntry) {
            GPTEntry gpte = (GPTEntry)obj;
            return Util.arraysEqual((byte[])this.getBytes(), (byte[])gpte.getBytes());
        }
        return false;
    }

    public static String getGUIDAsString(byte[] guid) {
        String res = "{";
        res = res + Util.toHexStringLE((int)Util.readIntBE((byte[])guid, (int)0)) + "-";
        res = res + Util.toHexStringLE((short)Util.readShortBE((byte[])guid, (int)4)) + "-";
        res = res + Util.toHexStringLE((short)Util.readShortBE((byte[])guid, (int)6)) + "-";
        res = res + Util.byteArrayToHexString((byte[])guid, (int)8, (int)2) + "-";
        res = res + Util.byteArrayToHexString((byte[])guid, (int)10, (int)6) + "}";
        return res.toUpperCase();
    }

    public static PartitionType convertPartitionType(GPTPartitionType gpt) {
        switch (gpt) {
            case PARTITION_TYPE_APPLE_HFS: {
                return PartitionType.APPLE_HFS_CONTAINER;
            }
            case PARTITION_TYPE_PRIMARY_PARTITION: {
                return PartitionType.NT_OS2_IFS;
            }
        }
        return PartitionType.UNKNOWN;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(GPTEntry.class.getSimpleName());
        db.addByteArray("partitionTypeGUID", this.partitionTypeGUID);
        db.addByteArray("uniquePartitionGUID", this.uniquePartitionGUID);
        db.addUIntLE("startingLBA", this.startingLBA);
        db.addUIntLE("endingLBA", this.endingLBA);
        db.add("partitionName", new EncodedStringField(this.partitionName, "UTF-16LE"));
        return db.getResult();
    }
}

