/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state.analysis;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.state.VarnodeOperation;
import ghidra.util.state.analysis.ComputedTableOffset;
import ghidra.util.state.analysis.Switch;

class TableEntryAddress
extends Switch {
    private final Address tableBase;
    private final ComputedTableOffset tableOffset;

    TableEntryAddress(Address tableBase, ComputedTableOffset tableOffset) {
        this.tableBase = tableBase;
        this.tableOffset = tableOffset;
    }

    Address getTableBaseAddress() {
        return this.tableBase;
    }

    @Override
    Address getCaseAddress(int caseIndexValue) {
        AddressSpace space = this.tableBase.getAddressSpace();
        return this.tableBase.add((long)(caseIndexValue * this.tableOffset.getTableEntrySize() * space.getAddressableUnitSize()));
    }

    int getTableEntrySize() {
        return this.tableOffset.getTableEntrySize();
    }

    @Override
    Varnode getIndexValue() {
        return this.tableOffset.getIndexValue();
    }

    static TableEntryAddress getTableEntryAddress(AddressFactory addrFactory, Varnode v) {
        if (!(v instanceof VarnodeOperation)) {
            return null;
        }
        VarnodeOperation tableEntryAddressComputation = (VarnodeOperation)v;
        if (tableEntryAddressComputation.getPCodeOp().getOpcode() != 19) {
            return null;
        }
        Address tableBase = null;
        ComputedTableOffset tableOffset = null;
        Varnode[] inputValues = tableEntryAddressComputation.getInputValues();
        if (inputValues[0].isConstant()) {
            tableBase = TableEntryAddress.getAddress(addrFactory, inputValues[0].getOffset());
            tableOffset = ComputedTableOffset.getComputedTableOffset(inputValues[1]);
        } else if (inputValues[1].isConstant()) {
            tableBase = TableEntryAddress.getAddress(addrFactory, inputValues[1].getOffset());
            tableOffset = ComputedTableOffset.getComputedTableOffset(inputValues[0]);
        }
        if (tableBase == null || tableOffset == null) {
            return null;
        }
        return new TableEntryAddress(tableBase, tableOffset);
    }

    private static Address getAddress(AddressFactory addrFactory, long offset) {
        try {
            return addrFactory.getDefaultAddressSpace().getAddress(offset);
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            return null;
        }
    }
}

