/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeDataFlavor;
import ghidra.app.util.ToolTipUtils;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class FunctionSymbolNode
extends SymbolNode {
    static final DataFlavor LOCAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - Local Functions");
    static final DataFlavor GLOBAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - Global Functions");
    static final DataFlavor EXTERNAL_DATA_FLAVOR = new SymbolTreeDataFlavor("Symbol Tree Data Flavor - External Functions");
    public static final Icon FUNCTION_ICON = ResourceManager.loadImage((String)"images/FunctionScope.gif");
    public static final Icon THUNK_ICON = ResourceManager.loadImage((String)"images/ThunkFunction.gif");
    public static final Icon EXTERNAL_ICON = ResourceManager.loadImage((String)"images/ExternalFunction.gif");
    public static final Icon DISABLED_FUNCTION_ICON = ResourceManager.getDisabledIcon((ImageIcon)((ImageIcon)FUNCTION_ICON));
    public static final Icon DISABLED_THUNK_ICON = ResourceManager.getDisabledIcon((ImageIcon)((ImageIcon)THUNK_ICON));
    public static final Icon DISABLED_EXTERNAL_ICON = ResourceManager.getDisabledIcon((ImageIcon)((ImageIcon)EXTERNAL_ICON));
    private static Comparator<GTreeNode> CHILD_COMPARATOR = new FunctionVariableComparator();
    private String tooltip;
    private boolean isExternal;

    FunctionSymbolNode(Program program, Symbol symbol) {
        super(program, symbol);
    }

    private boolean isThunk() {
        Function func = (Function)this.symbol.getObject();
        if (func == null) {
            return false;
        }
        return func.isThunk();
    }

    @Override
    public String getToolTip() {
        if (this.tooltip == null) {
            this.createTooltip();
        }
        return this.tooltip;
    }

    private void createTooltip() {
        Function func = (Function)this.symbol.getObject();
        this.tooltip = func == null ? "No function for " + this.symbol.getName() : ToolTipUtils.getToolTipText(func, true);
    }

    @Override
    public Icon getIcon(boolean expanded) {
        boolean cut = this.isCut();
        if (this.symbol.isExternal()) {
            return cut ? DISABLED_EXTERNAL_ICON : EXTERNAL_ICON;
        }
        if (this.isThunk()) {
            return cut ? DISABLED_THUNK_ICON : THUNK_ICON;
        }
        return cut ? DISABLED_FUNCTION_ICON : FUNCTION_ICON;
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        if (this.isExternal) {
            return EXTERNAL_DATA_FLAVOR;
        }
        return this.symbol.isGlobal() ? GLOBAL_DATA_FLAVOR : LOCAL_DATA_FLAVOR;
    }

    @Override
    public boolean canCut() {
        return true;
    }

    @Override
    public Comparator<GTreeNode> getChildrenComparator() {
        return CHILD_COMPARATOR;
    }

    @Override
    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor taskMonitor) {
        Symbol searchSymbol = key.getSymbol();
        if (this.symbol == searchSymbol) {
            return this;
        }
        if (!this.isChildType(searchSymbol.getSymbolType())) {
            return null;
        }
        return super.findSymbolTreeNode(key, loadChildren, taskMonitor);
    }

    private boolean isChildType(SymbolType type) {
        return type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR || type == SymbolType.LABEL || type == SymbolType.NAMESPACE;
    }

    private static class FunctionVariableComparator
    implements Comparator<GTreeNode> {
        private FunctionVariableComparator() {
        }

        @Override
        public int compare(GTreeNode o1, GTreeNode o2) {
            SymbolNode symbolNode1 = (SymbolNode)o1;
            SymbolNode symbolNode2 = (SymbolNode)o2;
            Symbol symbol1 = symbolNode1.getSymbol();
            Symbol symbol2 = symbolNode2.getSymbol();
            Object symbolObject1 = symbol1.getObject();
            Object symbolObject2 = symbol2.getObject();
            if (symbolObject1 instanceof Variable && symbolObject2 instanceof Variable) {
                Variable v1 = (Variable)symbolObject1;
                Variable v2 = (Variable)symbolObject2;
                return v1.compareTo((Object)v2);
            }
            if (symbolObject1 instanceof Variable) {
                return -1;
            }
            if (symbolObject2 instanceof Variable) {
                return 1;
            }
            return o1.compareTo((Object)o2);
        }
    }
}

