/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.cmd.analysis.SharedReturnAnalysisCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SharedReturnAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Shared Return Calls";
    protected static final String DESCRIPTION = "Converts branches to calls, followed by an immediate return, when the destination is a function.  Since this analysis is triggered by the creation of the destination function, the one-shot analysis action can be used if functions were created while this analyzer was disabled or not present.";
    private static final String OPTION_NAME_ASSUME_CONTIGUOUS_FUNCTIONS = "Assume contiguous functions only";
    private static final String OPTION_NAME_CONSIDER_CONDITIONAL_BRANCHES_FUNCTIONS = "Allow conditional Jumps";
    private static final String OPTION_DESCRIPTION_ASSUME_CONTIGUOUS_FUNCTIONS = "Select this check box to assume all function bodies are contiguous and all jumps across other functions should be treated as a call-return.";
    private static final String OPTION_DESCRIPTION_CONSIDER_CONDITIONAL_BRANCHES_FUNCTIONS = "Select this check box to allow conditional jumps to be consider for shared return jumps to other functions.";
    private static final boolean OPTION_DEFAULT_ASSUME_CONTIGUOUS_FUNCTIONS_ENABLED = false;
    private static final boolean OPTION_DEFAULT_CONSIDER_CONDITIONAL_BRANCHES_ENABLED = false;
    private boolean assumeContiguousFunctions = false;
    private boolean considerConditionalBranches = false;

    public SharedReturnAnalyzer() {
        this(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
    }

    public SharedReturnAnalyzer(String name, String description, AnalyzerType analyzerType) {
        super(name, description, analyzerType);
        this.setPriority(AnalysisPriority.CODE_ANALYSIS.before().before());
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        SharedReturnAnalysisCmd cmd = new SharedReturnAnalysisCmd(set, this.assumeContiguousFunctions, this.considerConditionalBranches);
        cmd.applyTo((DomainObject)program);
        return true;
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        Language language = program.getLanguage();
        boolean sharedReturnEnabled = language.getPropertyAsBoolean("enableSharedReturnAnalysis", true);
        return sharedReturnEnabled;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        HelpLocation helpLocation = new HelpLocation("AutoAnalysisPlugin", "Auto_Analysis_Option_Instruction" + this.getAnalysisType());
        options.registerOption(OPTION_NAME_ASSUME_CONTIGUOUS_FUNCTIONS, (Object)false, helpLocation, OPTION_DESCRIPTION_ASSUME_CONTIGUOUS_FUNCTIONS);
        options.registerOption(OPTION_NAME_CONSIDER_CONDITIONAL_BRANCHES_FUNCTIONS, (Object)false, helpLocation, OPTION_DESCRIPTION_CONSIDER_CONDITIONAL_BRANCHES_FUNCTIONS);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.assumeContiguousFunctions = options.getBoolean(OPTION_NAME_ASSUME_CONTIGUOUS_FUNCTIONS, false);
        this.considerConditionalBranches = options.getBoolean(OPTION_NAME_CONSIDER_CONDITIONAL_BRANCHES_FUNCTIONS, false);
    }
}

