/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.udp.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;

public class UdpInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 16384;
    private DatagramSocket socket = null;
    private final byte[] dataBuffer = new byte[16384];
    private int packetSize = 0;
    private int index = 0;
    private boolean connectOnReceive;

    public UdpInputStream(DatagramSocket socket, boolean connectOnReceive) {
        this.socket = socket;
        this.connectOnReceive = connectOnReceive;
    }

    @Override
    public void close() {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public int read() throws IOException {
        while (this.available() == 0) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.index;
        return this.dataBuffer[this.index - 1] & 0xFF;
    }

    @Override
    public int available() throws IOException {
        if (this.packetSize - this.index == 0) {
            this.receive();
        }
        return this.packetSize - this.index;
    }

    private DatagramPacket receive() throws IOException {
        DatagramPacket packet = new DatagramPacket(this.dataBuffer, 16384);
        try {
            this.socket.receive(packet);
            this.index = 0;
            this.packetSize = packet.getLength();
            if (this.connectOnReceive && !this.socket.isConnected()) {
                this.socket.connect(packet.getSocketAddress());
            }
        }
        catch (SocketTimeoutException E) {
            packet = null;
        }
        return packet;
    }
}

