/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.gost;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cryptopro.GostR3410KeyTransport;

public class TLSProxyKeyTransportBlob
extends ASN1Object {
    private final GostR3410KeyTransport keyBlob;
    private final DEROctetString cert;

    public static TLSProxyKeyTransportBlob getInstance(Object obj) {
        if (obj instanceof TLSProxyKeyTransportBlob) {
            return (TLSProxyKeyTransportBlob)((Object)obj);
        }
        if (obj != null) {
            return new TLSProxyKeyTransportBlob(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    private TLSProxyKeyTransportBlob(ASN1Sequence seq) {
        this.keyBlob = GostR3410KeyTransport.getInstance((Object)seq.getObjectAt(0));
        this.cert = (DEROctetString)DEROctetString.getInstance((Object)seq.getObjectAt(1));
    }

    public TLSProxyKeyTransportBlob(GostR3410KeyTransport keyBlob, DEROctetString cert) {
        this.keyBlob = keyBlob;
        this.cert = cert;
    }

    public GostR3410KeyTransport getKeyBlob() {
        return this.keyBlob;
    }

    public DEROctetString getCert() {
        return this.cert;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.keyBlob);
        v.add((ASN1Encodable)this.cert);
        return new DERSequence(v);
    }
}

