/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.List;
import org.apache.maven.lifecycle.Schedule;
import org.apache.maven.plugin.MojoExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduling {
    private String lifecycle;
    private List<Schedule> schedules;

    public Scheduling() {
    }

    public Scheduling(String lifecycle, List<Schedule> schedules) {
        this.lifecycle = lifecycle;
        this.schedules = schedules;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(String lifecycle) {
        this.lifecycle = lifecycle;
    }

    public List<Schedule> getSchedules() {
        return this.schedules;
    }

    public Schedule getSchedule(String phaseName) {
        if (phaseName != null) {
            for (Schedule schedule : this.schedules) {
                if (!phaseName.equals(schedule.getPhase())) continue;
                return schedule;
            }
        }
        return null;
    }

    public Schedule getSchedule(MojoExecution mojoExecution) {
        if (mojoExecution != null) {
            for (Schedule schedule : this.schedules) {
                if (!schedule.appliesTo(mojoExecution)) continue;
                return schedule;
            }
        }
        return null;
    }

    public void setSchedules(List<Schedule> schedules) {
        this.schedules = schedules;
    }
}

