/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.ProgressWatcher;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.Monitorable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class JDBCDriverPanel
extends JPanel
implements DataEntryPanel {
    public static final int DRIVER_LEVEL = 2;
    private static final Logger logger = Logger.getLogger(JDBCDriverPanel.class);
    private JDBCDataSourceType dataSourceType;
    private JTree driverTree;
    private DefaultTreeModel dtm;
    private JFileChooser fileChooser;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JButton delButton;
    private JButton addButton;
    private DefaultMutableTreeNode rootNode;
    private final URI serverBaseURI;

    public JDBCDriverPanel(URI serverBaseURI) {
        this.serverBaseURI = serverBaseURI;
        this.fileChooser = new JFileChooser();
        this.setLayout(new BorderLayout());
        this.rootNode = new DefaultMutableTreeNode("The Root");
        this.dtm = new DefaultTreeModel(this.rootNode);
        this.driverTree = new JTree(this.dtm);
        this.driverTree.setRootVisible(false);
        this.driverTree.getSelectionModel().setSelectionMode(4);
        this.driverTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JDBCDriverPanel.this.delButton.setEnabled(JDBCDriverPanel.this.driverTree.getSelectionPath() != null);
            }
        });
        this.driverTree.setCellRenderer(new DriverTreeCellRenderer());
        this.add((Component)new JScrollPane(this.driverTree), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.addButton = new JButton(new AddAction());
        buttonPanel.add(this.addButton);
        this.delButton = new JButton(new DelAction());
        buttonPanel.add(this.delButton);
        this.delButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.add((Component)buttonPanel, "North");
        JPanel progressPanel = new JPanel(new FlowLayout(1));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        progressPanel.add(this.progressBar);
        this.progressLabel = new JLabel(Messages.getString("JDBCDriverPanel.scanningForJdbcDrivers"));
        this.progressLabel.setVisible(false);
        progressPanel.add(this.progressLabel);
        progressPanel.setPreferredSize(new Dimension(300, this.progressBar.getPreferredSize().height + 20));
        this.add((Component)progressPanel, "South");
        this.setPreferredSize(new Dimension(400, 400));
    }

    @Override
    public boolean applyChanges() {
        logger.debug((Object)"applyChanges");
        ArrayList<String> driverList = new ArrayList<String>();
        int n = this.dtm.getChildCount(this.dtm.getRoot());
        for (int i = 0; i < n; ++i) {
            driverList.add(((DefaultMutableTreeNode)this.dtm.getChild(this.dtm.getRoot(), i)).getUserObject().toString());
        }
        if (this.dataSourceType != null) {
            this.dataSourceType.setJdbcJarList(driverList);
        }
        return true;
    }

    @Override
    public void discardChanges() {
        this.editDsType(this.dataSourceType);
    }

    public void editDsType(JDBCDataSourceType dst) {
        this.dataSourceType = dst;
        this.dtm.setRoot(new DefaultMutableTreeNode());
        if (dst != null) {
            this.doLoad(this.dataSourceType.getJdbcJarList());
        }
        this.addButton.setEnabled(dst != null);
    }

    private void doLoad(List<String> list) {
        logger.debug((Object)"about to start a worker", (Throwable)new Exception());
        LoadJDBCDrivers ljd = new LoadJDBCDrivers(list);
        LoadJDBCDriversWorker worker = new LoadJDBCDriversWorker(ljd);
        ProgressWatcher pw = new ProgressWatcher(this.progressBar, ljd, this.progressLabel);
        pw.setHideLabelWhenFinished(true);
        pw.start();
        new Thread(worker).start();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }

    public void addDriverTreeSelectionListener(TreeSelectionListener tsl) {
        this.driverTree.addTreeSelectionListener(tsl);
    }

    public void removeDriverTreeSelectionListener(TreeSelectionListener tsl) {
        this.driverTree.removeTreeSelectionListener(tsl);
    }

    private class JDBCScanClassLoader
    extends ClassLoader {
        private List drivers;
        private int count = 0;
        private JarURLConnection jarConnection;
        private JarFile jf;

        public JDBCScanClassLoader(URL jarLocation) throws IOException {
            URL jarURL = new URL("jar:" + jarLocation + "!/");
            this.jarConnection = (JarURLConnection)jarURL.openConnection();
            this.jf = this.jarConnection.getJarFile();
        }

        public synchronized double getFraction() {
            double retval = 0.0;
            if (this.jf != null) {
                retval = (double)this.count / (double)this.jf.size();
            }
            return retval;
        }

        public List scanForDrivers() {
            this.drivers = new LinkedList();
            logger.debug((Object)("********* " + this.jf.getName() + " has " + this.jf.size() + " files."));
            Enumeration<JarEntry> entries = this.jf.entries();
            while (entries.hasMoreElements()) {
                ++this.count;
                ZipEntry ent = entries.nextElement();
                if (!ent.getName().endsWith(".class")) continue;
                try {
                    String[] s = ent.getName().split("\\.");
                    this.findClass(s[0].replace('/', '.'));
                }
                catch (ClassFormatError ex) {
                    logger.warn((Object)("JAR entry " + ent.getName() + " ends in .class but is not a class"), (Throwable)ex);
                }
                catch (NoClassDefFoundError ex) {
                    logger.warn((Object)("JAR does not contain dependency needed by: " + ent.getName()));
                }
                catch (Throwable ex) {
                    logger.warn((Object)("Unexpected exception while scanning JAR file " + this.jf.getName()), ex);
                }
            }
            return this.drivers;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            try {
                ZipEntry ent = this.jf.getEntry(name.replace('.', '/') + ".class");
                if (ent == null) {
                    throw new ClassNotFoundException("No class file " + name + " is in my jar file");
                }
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                InputStream is = this.jf.getInputStream(ent);
                return this.readAndCheckClass(is, (int)ent.getSize(), name);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("IO Exception reading class from jar file", ex);
            }
        }

        private Class readAndCheckClass(InputStream is, int size, String expectedName) throws IOException, ClassFormatError {
            Class<?> clazz;
            int offs;
            int n;
            byte[] buf = new byte[size];
            for (offs = 0; (n = is.read(buf, offs, size - offs)) >= 0 && offs < size; offs += n) {
            }
            int total = offs;
            if (total != size) {
                logger.warn((Object)("Only read " + total + " bytes of class " + expectedName + " from JAR file; exptected " + size));
            }
            if (Driver.class.isAssignableFrom(clazz = this.defineClass(expectedName, buf, 0, total))) {
                logger.info((Object)("Found jdbc driver " + clazz.getName()));
                this.drivers.add(clazz.getName());
            }
            return clazz;
        }
    }

    private class LoadJDBCDrivers
    implements Monitorable {
        public boolean hasStarted = false;
        public boolean finished = false;
        private List<String> driverJarList = null;
        private int jarCount = 0;
        private JDBCScanClassLoader cl = null;

        public LoadJDBCDrivers(List<String> driverJarList) {
            this.driverJarList = driverJarList;
            logger.debug((Object)"in constructor, setting finished to false...");
            this.finished = false;
        }

        @Override
        public Integer getJobSize() {
            return new Integer(this.driverJarList.size() * 1000);
        }

        @Override
        public int getProgress() {
            double fraction = 0.0;
            if (this.cl != null) {
                fraction = this.cl.getFraction();
            }
            int progress = (this.jarCount - 1) * 1000 + (int)(fraction * 1000.0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("******************* progress is: " + progress + " of " + this.getJobSize()));
            }
            return progress;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public void setCancelled(boolean cancelled) {
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean hasStarted() {
            return this.hasStarted;
        }

        @Override
        public String getMessage() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            this.hasStarted = true;
            try {
                Iterator<String> it = this.driverJarList.iterator();
                while (it.hasNext()) {
                    ++this.jarCount;
                    logger.debug((Object)("**************** processing file #" + this.jarCount + " of " + this.driverJarList.size()));
                    String path = it.next();
                    URL jarLocation = JDBCDataSource.jarSpecToFile(path, this.getClass().getClassLoader(), JDBCDriverPanel.this.serverBaseURI);
                    if (jarLocation == null) continue;
                    this.addJarLocation(jarLocation);
                }
                this.finished = true;
                logger.debug((Object)"done loading (normal operation), setting finished to true.");
            }
            catch (Exception exp) {
                logger.error((Object)"something went wrong in LoadJDBCDrivers worker thread!", (Throwable)exp);
            }
            finally {
                this.finished = true;
                this.hasStarted = false;
                logger.debug((Object)"done loading (error condition), setting finished to true.");
            }
        }

        private void addJarLocation(URL url) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)JDBCDriverPanel.this.dtm.getRoot();
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(url.toString());
            JDBCDriverPanel.this.dtm.insertNodeInto(node, root, root.getChildCount());
            try {
                this.cl = new JDBCScanClassLoader(url);
                List driverClasses = this.cl.scanForDrivers();
                logger.info((Object)("Found drivers: " + driverClasses));
                Iterator it = driverClasses.iterator();
                while (it.hasNext()) {
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(it.next());
                    JDBCDriverPanel.this.dtm.insertNodeInto(child, node, node.getChildCount());
                }
            }
            catch (IOException ex) {
                logger.warn((Object)"I/O Error reading JAR file", (Throwable)ex);
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(ex);
                JDBCDriverPanel.this.dtm.insertNodeInto(child, node, node.getChildCount());
            }
            TreePath path = new TreePath(node.getPath());
            JDBCDriverPanel.this.driverTree.expandPath(path);
            JDBCDriverPanel.this.driverTree.scrollPathToVisible(path);
        }
    }

    private class LoadJDBCDriversWorker
    implements Runnable {
        LoadJDBCDrivers ljd;

        LoadJDBCDriversWorker(LoadJDBCDrivers ljd) {
            this.ljd = ljd;
        }

        @Override
        public void run() {
            this.ljd.execute();
        }
    }

    private class DelAction
    extends AbstractAction {
        public DelAction() {
            super(Messages.getString("JDBCDriverPanel.removeJarActionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (TreePath p : JDBCDriverPanel.this.driverTree.getSelectionPaths()) {
                logger.debug((Object)String.format("DelAction: p=%s, pathCount=%d", p, p.getPathCount()));
                if (p == null || p.getPathCount() < 2) continue;
                logger.debug((Object)("Removing: " + p.getPathComponent(1)));
                JDBCDriverPanel.this.dtm.removeNodeFromParent((MutableTreeNode)p.getPathComponent(1));
                JDBCDriverPanel.this.dataSourceType.removeJdbcJar(p.getPathComponent(1).toString());
            }
            JDBCDriverPanel.this.delButton.setEnabled(false);
        }
    }

    protected class AddAction
    extends AbstractAction {
        public AddAction() {
            super(Messages.getString("JDBCDriverPanel.addJarActionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDBCDriverPanel.this.fileChooser.addChoosableFileFilter(SPSUtils.JAR_ZIP_FILE_FILTER);
            JDBCDriverPanel.this.fileChooser.setMultiSelectionEnabled(true);
            int returnVal = JDBCDriverPanel.this.fileChooser.showOpenDialog(JDBCDriverPanel.this);
            if (returnVal == 0) {
                File[] files = JDBCDriverPanel.this.fileChooser.getSelectedFiles();
                ArrayList<String> list = new ArrayList<String>();
                for (int ii = 0; ii < files.length; ++ii) {
                    list.add(files[ii].getAbsolutePath());
                }
                for (int i = 0; i < files.length; ++i) {
                    JDBCDriverPanel.this.dataSourceType.addJdbcJar(files[i].getAbsolutePath());
                }
                JDBCDriverPanel.this.doLoad(list);
            }
        }
    }

    private static class DriverTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private Icon jarFileIcon = new ImageIcon(JDBCDriverPanel.class.getClassLoader().getResource("ca/sqlpower/swingui/db/folder_wrench.png"));
        private Icon driverIcon = new ImageIcon(JDBCDriverPanel.class.getClassLoader().getResource("ca/sqlpower/swingui/db/wrench.png"));
        private Icon jarFileErrorIcon = new ImageIcon(JDBCDriverPanel.class.getClassLoader().getResource("ca/sqlpower/swingui/db/folder_error.png"));
        private Icon driverErrorIcon = new ImageIcon(JDBCDriverPanel.class.getClassLoader().getResource("ca/sqlpower/swingui/db/error.png"));

        private DriverTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            int level = node.getLevel();
            if (level != 0) {
                if (level == 1) {
                    this.setIcon(this.jarFileIcon);
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        if (!(((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject() instanceof Throwable)) continue;
                        this.setIcon(this.jarFileErrorIcon);
                        break;
                    }
                } else if (level == 2) {
                    if (node.getUserObject() instanceof Throwable) {
                        this.setForeground(Color.RED);
                        this.setIcon(this.driverErrorIcon);
                        this.setText(Messages.getString("JDBCDriverPanel.jarFileNotFound"));
                    } else {
                        this.setIcon(this.driverIcon);
                    }
                } else {
                    throw new IllegalStateException("This renderer doesn't know how to handle node depth " + level);
                }
            }
            return this;
        }
    }
}

