/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.UDPPacket;

class UDPPacketReader {
    private byte[] _message;
    private int _payloadBeginOffset;
    private int _payloadLength;
    private final SessionRequestReader _sessionRequestReader = new SessionRequestReader();
    private final SessionCreatedReader _sessionCreatedReader = new SessionCreatedReader();
    private final SessionConfirmedReader _sessionConfirmedReader = new SessionConfirmedReader();
    private final DataReader _dataReader = new DataReader();
    private final PeerTestReader _peerTestReader = new PeerTestReader();
    private final RelayRequestReader _relayRequestReader = new RelayRequestReader();
    private final RelayIntroReader _relayIntroReader = new RelayIntroReader();
    private final RelayResponseReader _relayResponseReader = new RelayResponseReader();
    private static final int KEYING_MATERIAL_LENGTH = 64;

    public UDPPacketReader(I2PAppContext ctx) {
    }

    public void initialize(UDPPacket packet) {
        int off = packet.getPacket().getOffset();
        int len = packet.getPacket().getLength();
        this.initialize(packet.getPacket().getData(), off += 32, len -= 32);
    }

    private void initialize(byte[] message, int payloadOffset, int payloadLength) {
        this._message = message;
        this._payloadBeginOffset = payloadOffset;
        this._payloadLength = payloadLength;
    }

    public int readPayloadType() {
        return (this._message[this._payloadBeginOffset] & 0xFF) >>> 4;
    }

    public boolean isRekeyingIncluded() {
        return (this._message[this._payloadBeginOffset] & 8) != 0;
    }

    public boolean isExtendedOptionsIncluded() {
        return (this._message[this._payloadBeginOffset] & 4) != 0;
    }

    public long readTimestamp() {
        return DataHelper.fromLong(this._message, this._payloadBeginOffset + 1, 4);
    }

    @Deprecated
    public byte[] readKeyingMaterial() {
        if (!this.isRekeyingIncluded()) {
            return null;
        }
        byte[] rv = new byte[64];
        System.arraycopy(this._message, this._payloadBeginOffset + 1 + 4, rv, 0, 64);
        return rv;
    }

    public byte[] readExtendedOptions() {
        if (!this.isExtendedOptionsIncluded()) {
            return null;
        }
        int offset = this._payloadBeginOffset + 1 + 4;
        if (this.isRekeyingIncluded()) {
            offset += 64;
        }
        int optionsSize = this._message[offset++] & 0xFF;
        byte[] rv = new byte[optionsSize];
        System.arraycopy(this._message, offset, rv, 0, optionsSize);
        return rv;
    }

    private int readBodyOffset() {
        int offset = this._payloadBeginOffset + 1 + 4;
        if (this.isRekeyingIncluded()) {
            offset += 64;
        }
        if (this.isExtendedOptionsIncluded()) {
            int optionsSize = this._message[offset] & 0xFF;
            offset += optionsSize + 1;
        }
        return offset;
    }

    public SessionRequestReader getSessionRequestReader() {
        return this._sessionRequestReader;
    }

    public SessionCreatedReader getSessionCreatedReader() {
        return this._sessionCreatedReader;
    }

    public SessionConfirmedReader getSessionConfirmedReader() {
        return this._sessionConfirmedReader;
    }

    public DataReader getDataReader() {
        return this._dataReader;
    }

    public PeerTestReader getPeerTestReader() {
        return this._peerTestReader;
    }

    public RelayRequestReader getRelayRequestReader() {
        return this._relayRequestReader;
    }

    public RelayIntroReader getRelayIntroReader() {
        return this._relayIntroReader;
    }

    public RelayResponseReader getRelayResponseReader() {
        return this._relayResponseReader;
    }

    public String toString() {
        int type = this.readPayloadType();
        switch (type) {
            case 6: {
                return this._dataReader.toString();
            }
            case 2: {
                return "Session confirmed packet";
            }
            case 1: {
                return "Session created packet";
            }
            case 0: {
                return "Session request packet";
            }
            case 7: {
                return "Peer test packet";
            }
            case 5: {
                return "Relay intro packet";
            }
            case 3: {
                return "Relay request packet";
            }
            case 4: {
                return "Relay response packet";
            }
            case 8: {
                return "Session destroyed packet";
            }
        }
        return "Unknown packet type " + type;
    }

    public void toRawString(StringBuilder buf) {
        if (this._message != null) {
            buf.append(Base64.encode(this._message, this._payloadBeginOffset, this._payloadLength));
        }
    }

    public class RelayResponseReader
    extends Reader {
        public int readCharlieIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset();
            return UDPPacketReader.this._message[offset] & 0xFF;
        }

        public void readCharlieIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset();
            int size = UDPPacketReader.this._message[offset] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readCharliePort() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            return (int)DataHelper.fromLong(UDPPacketReader.this._message, ++offset, 2);
        }

        @Deprecated
        public int readAliceIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            return UDPPacketReader.this._message[offset += 3] & 0xFF;
        }

        @Deprecated
        public void readAliceIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int sz = UDPPacketReader.this._message[offset += 3] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, sz);
        }

        @Deprecated
        public int readAlicePort() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int sz = UDPPacketReader.this._message[offset += 3] & 0xFF;
            ++offset;
            return (int)DataHelper.fromLong(UDPPacketReader.this._message, offset += sz, 2);
        }

        public long readNonce() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int sz = UDPPacketReader.this._message[offset += 3] & 0xFF;
            offset += 3;
            return DataHelper.fromLong(UDPPacketReader.this._message, offset += sz, 4);
        }
    }

    public class RelayIntroReader
    extends Reader {
        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset();
            return UDPPacketReader.this._message[offset] & 0xFF;
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset();
            int size = UDPPacketReader.this._message[offset] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readPort() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            return (int)DataHelper.fromLong(UDPPacketReader.this._message, ++offset, 2);
        }

        public int readChallengeSize() {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            return UDPPacketReader.this._message[offset += 3] & 0xFF;
        }

        public void readChallengeData(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset();
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int sz = UDPPacketReader.this._message[offset += 3] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, sz);
        }
    }

    public class RelayRequestReader
    extends Reader {
        public long readTag() {
            long rv = DataHelper.fromLong(UDPPacketReader.this._message, UDPPacketReader.this.readBodyOffset(), 4);
            return rv;
        }

        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int rv = UDPPacketReader.this._message[offset] & 0xFF;
            return rv;
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int size = UDPPacketReader.this._message[offset] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readPort() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int rv = (int)DataHelper.fromLong(UDPPacketReader.this._message, ++offset, 2);
            return rv;
        }

        public int readChallengeSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int rv = UDPPacketReader.this._message[offset += 3] & 0xFF;
            return rv;
        }

        public void readChallengeData(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int sz = UDPPacketReader.this._message[offset += 3] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, sz);
        }

        public void readAliceIntroKey(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int sz = UDPPacketReader.this._message[offset += 3] & 0xFF;
            ++offset;
            System.arraycopy(UDPPacketReader.this._message, offset += sz, target, targetOffset, 32);
        }

        public long readNonce() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            offset += UDPPacketReader.this._message[offset] & 0xFF;
            int sz = UDPPacketReader.this._message[offset += 3] & 0xFF;
            ++offset;
            offset += sz;
            long rv = DataHelper.fromLong(UDPPacketReader.this._message, offset += 32, 4);
            return rv;
        }
    }

    public class PeerTestReader
    extends Reader {
        private static final int NONCE_LENGTH = 4;

        public long readNonce() {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            return DataHelper.fromLong(UDPPacketReader.this._message, readOffset, 4);
        }

        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            return UDPPacketReader.this._message[offset] & 0xFF;
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int size = UDPPacketReader.this._message[offset] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readPort() {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int size = UDPPacketReader.this._message[offset] & 0xFF;
            ++offset;
            return (int)DataHelper.fromLong(UDPPacketReader.this._message, offset += size, 2);
        }

        public void readIntroKey(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 4;
            int size = UDPPacketReader.this._message[offset] & 0xFF;
            offset += 3;
            System.arraycopy(UDPPacketReader.this._message, offset += size, target, targetOffset, 32);
        }
    }

    private class PacketACKBitfield
    implements ACKBitfield {
        private final int _start;
        private final int _bitfieldStart;
        private final int _bitfieldSize;

        public PacketACKBitfield(int start) throws DataFormatException {
            this._start = start;
            this._bitfieldStart = start + 4;
            int bfsz = 1;
            while ((UDPPacketReader.this._message[this._bitfieldStart + bfsz - 1] & 0xFFFFFF80) != 0) {
                ++bfsz;
            }
            if (bfsz > 10) {
                throw new DataFormatException("bitfield size: " + bfsz);
            }
            this._bitfieldSize = bfsz;
        }

        @Override
        public long getMessageId() {
            return DataHelper.fromLong(UDPPacketReader.this._message, this._start, 4);
        }

        public int getByteLength() {
            return 4 + this._bitfieldSize;
        }

        @Override
        public int fragmentCount() {
            return this._bitfieldSize * 7;
        }

        @Override
        public boolean receivedComplete() {
            return false;
        }

        @Override
        public int ackCount() {
            int rv = 0;
            for (int i = this._bitfieldStart; i < this._bitfieldStart + this._bitfieldSize; ++i) {
                byte b = UDPPacketReader.this._message[i];
                if ((b & 0x7F) == 0) continue;
                for (int j = 0; j < 7; ++j) {
                    if ((b & 1) != 0) {
                        ++rv;
                    }
                    b = (byte)(b >> 1);
                }
            }
            return rv;
        }

        @Override
        public int highestReceived() {
            for (int i = this._bitfieldSize - 1; i >= 0; --i) {
                byte b = UDPPacketReader.this._message[this._bitfieldStart + i];
                if ((b & 0x7F) == 0) continue;
                for (int j = 6; j >= 0; --j) {
                    if ((b & 0x40) != 0) {
                        return 7 * i + j;
                    }
                    b = (byte)(b << 1);
                }
            }
            return -1;
        }

        @Override
        public boolean received(int fragmentNum) {
            if (fragmentNum < 0 || fragmentNum >= this._bitfieldSize * 7) {
                return false;
            }
            int byteNum = this._bitfieldStart + fragmentNum / 7;
            int flagNum = fragmentNum % 7;
            return (UDPPacketReader.this._message[byteNum] & 1 << flagNum) != 0;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("IB Partial ACK of ");
            buf.append(this.getMessageId());
            buf.append(" highest: ").append(this.highestReceived());
            buf.append(" with ACKs for: [");
            int numFrags = this.fragmentCount();
            for (int i = 0; i < numFrags; ++i) {
                if (!this.received(i)) continue;
                buf.append(i).append(' ');
            }
            buf.append("] / ").append(numFrags);
            return buf.toString();
        }
    }

    public class DataReader
    extends Reader {
        public int getPacketSize() {
            return UDPPacketReader.this._payloadLength;
        }

        public boolean readACKsIncluded() {
            return this.flagSet((byte)-128);
        }

        public boolean readACKBitfieldsIncluded() {
            return this.flagSet((byte)64);
        }

        public boolean readECN() {
            return this.flagSet((byte)16);
        }

        public boolean readWantPreviousACKs() {
            return this.flagSet((byte)8);
        }

        public boolean readReplyRequested() {
            return this.flagSet((byte)4);
        }

        public boolean readExtendedDataIncluded() {
            return this.flagSet((byte)2);
        }

        public int readACKCount() {
            if (!this.readACKsIncluded()) {
                return 0;
            }
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            return UDPPacketReader.this._message[off] & 0xFF;
        }

        public long readACK(int index) {
            if (!this.readACKsIncluded()) {
                return -1L;
            }
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            return DataHelper.fromLong(UDPPacketReader.this._message, ++off + 4 * index, 4);
        }

        public ACKBitfield[] readACKBitfields() throws DataFormatException {
            if (!this.readACKBitfieldsIncluded()) {
                return null;
            }
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            if (this.readACKsIncluded()) {
                int numACKs = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                off += 4 * numACKs;
            }
            int numBitfields = UDPPacketReader.this._message[off] & 0xFF;
            ++off;
            ACKBitfield[] rv = new PacketACKBitfield[numBitfields];
            for (int i = 0; i < numBitfields; ++i) {
                rv[i] = new PacketACKBitfield(off);
                off += ((PacketACKBitfield)rv[i]).getByteLength();
            }
            return rv;
        }

        public int readFragmentCount() throws DataFormatException {
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            if (this.readACKsIncluded()) {
                int numACKs = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                off += 4 * numACKs;
            }
            if (this.readACKBitfieldsIncluded()) {
                int numBitfields = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                for (int i = 0; i < numBitfields; ++i) {
                    PacketACKBitfield bf = new PacketACKBitfield(off);
                    off += bf.getByteLength();
                }
            }
            if (this.readExtendedDataIncluded()) {
                int size = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                off += size;
            }
            return UDPPacketReader.this._message[off];
        }

        public long readMessageId(int fragmentNum) throws DataFormatException {
            int fragmentBegin = this.getFragmentBegin(fragmentNum);
            return DataHelper.fromLong(UDPPacketReader.this._message, fragmentBegin, 4);
        }

        public int readMessageFragmentNum(int fragmentNum) throws DataFormatException {
            int off = this.getFragmentBegin(fragmentNum);
            return (UDPPacketReader.this._message[off += 4] & 0xFF) >>> 1;
        }

        public boolean readMessageIsLast(int fragmentNum) throws DataFormatException {
            int off = this.getFragmentBegin(fragmentNum);
            return (UDPPacketReader.this._message[off += 4] & 1) != 0;
        }

        public int readMessageFragmentSize(int fragmentNum) throws DataFormatException {
            int off = this.getFragmentBegin(fragmentNum);
            return (int)DataHelper.fromLong(UDPPacketReader.this._message, off += 5, 2) & 0x3FFF;
        }

        public void readMessageFragment(int fragmentNum, byte[] target, int targetOffset) throws DataFormatException {
            int off = this.getFragmentBegin(fragmentNum);
            int size = (int)DataHelper.fromLong(UDPPacketReader.this._message, off += 5, 2) & 0x3FFF;
            System.arraycopy(UDPPacketReader.this._message, off += 2, target, targetOffset, size);
        }

        private int getFragmentBegin(int fragmentNum) throws DataFormatException {
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            if (this.readACKsIncluded()) {
                int numACKs = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                off += 4 * numACKs;
            }
            if (this.readACKBitfieldsIncluded()) {
                int numBitfields = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                PacketACKBitfield[] bf = new PacketACKBitfield[numBitfields];
                for (int i = 0; i < numBitfields; ++i) {
                    bf[i] = new PacketACKBitfield(off);
                    off += bf[i].getByteLength();
                }
            }
            if (this.readExtendedDataIncluded()) {
                int size = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                off += size;
            }
            ++off;
            if (fragmentNum > 0) {
                for (int i = 0; i < fragmentNum; ++i) {
                    off += 5;
                    off += (int)DataHelper.fromLong(UDPPacketReader.this._message, off, 2) & 0x3FFF;
                    off += 2;
                }
            }
            return off;
        }

        private boolean flagSet(byte flag) {
            int flagOffset = UDPPacketReader.this.readBodyOffset();
            return (UDPPacketReader.this._message[flagOffset] & flag) != 0;
        }

        public String toString() {
            int i;
            StringBuilder buf = new StringBuilder(512);
            long msAgo = System.currentTimeMillis() - UDPPacketReader.this.readTimestamp() * 1000L;
            buf.append("Data packet sent ").append(msAgo).append("ms ago ");
            buf.append("IV ");
            buf.append(Base64.encode(UDPPacketReader.this._message, UDPPacketReader.this._payloadBeginOffset - 16, 16));
            buf.append(" ");
            int off = UDPPacketReader.this.readBodyOffset() + 1;
            if (this.readACKsIncluded()) {
                int numACKs = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                buf.append("with ACKs for ");
                for (i = 0; i < numACKs; ++i) {
                    buf.append(DataHelper.fromLong(UDPPacketReader.this._message, off, 4)).append(' ');
                    off += 4;
                }
            }
            if (this.readACKBitfieldsIncluded()) {
                int numBitfields = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                buf.append("with partial ACKs for ");
                try {
                    for (i = 0; i < numBitfields; ++i) {
                        PacketACKBitfield bf = new PacketACKBitfield(off);
                        buf.append(bf.getMessageId()).append(' ');
                        off += bf.getByteLength();
                    }
                }
                catch (DataFormatException dfe) {
                    buf.append("CORRUPT");
                    return buf.toString();
                }
            }
            if (this.readExtendedDataIncluded()) {
                int size = UDPPacketReader.this._message[off] & 0xFF;
                ++off;
                buf.append("with extended size of ");
                buf.append(size);
                buf.append(' ');
                off += size;
            }
            int numFragments = UDPPacketReader.this._message[off] & 0xFF;
            ++off;
            buf.append("with fragmentCount of ");
            buf.append(numFragments);
            buf.append(' ');
            for (i = 0; i < numFragments; ++i) {
                buf.append("containing messageId ");
                buf.append(DataHelper.fromLong(UDPPacketReader.this._message, off, 4));
                int fragNum = (UDPPacketReader.this._message[off += 4] & 0xFF) >>> 1;
                boolean isLast = (UDPPacketReader.this._message[off] & 1) != 0;
                buf.append(" frag# ").append(fragNum);
                buf.append(" isLast? ").append(isLast);
                buf.append(" info ").append(UDPPacketReader.this._message[++off - 1]);
                int size = (int)DataHelper.fromLong(UDPPacketReader.this._message, off, 2) & 0x3FFF;
                off += 2;
                buf.append(" with ").append(size).append(" bytes; ");
                off += size;
            }
            return buf.toString();
        }

        public void toRawString(StringBuilder buf) throws DataFormatException {
            UDPPacketReader.this.toRawString(buf);
            buf.append(" payload: ");
            int off = this.getFragmentBegin(0);
            int size = (int)DataHelper.fromLong(UDPPacketReader.this._message, off += 5, 2) & 0x3FFF;
            buf.append(Base64.encode(UDPPacketReader.this._message, off += 2, size));
        }
    }

    public class SessionConfirmedReader
    extends Reader {
        public int readCurrentFragmentNum() {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            return (UDPPacketReader.this._message[readOffset] & 0xFF) >>> 4;
        }

        public int readTotalFragmentNum() {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            return UDPPacketReader.this._message[readOffset] & 0xF;
        }

        public int readCurrentFragmentSize() {
            int readOffset = UDPPacketReader.this.readBodyOffset() + 1;
            return (int)DataHelper.fromLong(UDPPacketReader.this._message, readOffset, 2);
        }

        public void readFragmentData(byte[] target, int targetOffset) {
            int readOffset = UDPPacketReader.this.readBodyOffset() + 1 + 2;
            int len = this.readCurrentFragmentSize();
            System.arraycopy(UDPPacketReader.this._message, readOffset, target, targetOffset, len);
        }

        public long readFinalFragmentSignedOnTime() {
            if (this.readCurrentFragmentNum() != this.readTotalFragmentNum() - 1) {
                throw new IllegalStateException("This is not the final fragment");
            }
            int readOffset = UDPPacketReader.this.readBodyOffset() + 1 + 2 + this.readCurrentFragmentSize();
            return DataHelper.fromLong(UDPPacketReader.this._message, readOffset, 4);
        }

        public void readFinalSignature(byte[] target, int targetOffset, int size) {
            if (this.readCurrentFragmentNum() != this.readTotalFragmentNum() - 1) {
                throw new IllegalStateException("This is not the final fragment");
            }
            int readOffset = UDPPacketReader.this._payloadBeginOffset + UDPPacketReader.this._payloadLength - size;
            if (readOffset < UDPPacketReader.this.readBodyOffset() + 7) {
                throw new IllegalStateException("Sig split across fragments");
            }
            System.arraycopy(UDPPacketReader.this._message, readOffset, target, targetOffset, size);
        }
    }

    public class SessionCreatedReader
    extends Reader {
        public static final int Y_LENGTH = 256;

        public void readY(byte[] target, int targetOffset) {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            System.arraycopy(UDPPacketReader.this._message, readOffset, target, targetOffset, 256);
        }

        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256;
            return UDPPacketReader.this._message[offset] & 0xFF;
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 256;
            int size = UDPPacketReader.this._message[offset] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }

        public int readPort() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256 + 1 + this.readIPSize();
            return (int)DataHelper.fromLong(UDPPacketReader.this._message, offset, 2);
        }

        public long readRelayTag() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256 + 1 + this.readIPSize() + 2;
            return DataHelper.fromLong(UDPPacketReader.this._message, offset, 4);
        }

        public long readSignedOnTime() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256 + 1 + this.readIPSize() + 2 + 4;
            long rv = DataHelper.fromLong(UDPPacketReader.this._message, offset, 4);
            return rv;
        }

        public void readEncryptedSignature(byte[] target, int targetOffset, int size) {
            int offset = UDPPacketReader.this.readBodyOffset() + 256 + 1 + this.readIPSize() + 2 + 4 + 4;
            System.arraycopy(UDPPacketReader.this._message, offset, target, targetOffset, size);
        }

        public void readIV(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this._payloadBeginOffset - 16;
            System.arraycopy(UDPPacketReader.this._message, offset, target, targetOffset, 16);
        }
    }

    public class SessionRequestReader
    extends Reader {
        public static final int X_LENGTH = 256;

        public void readX(byte[] target, int targetOffset) {
            int readOffset = UDPPacketReader.this.readBodyOffset();
            System.arraycopy(UDPPacketReader.this._message, readOffset, target, targetOffset, 256);
        }

        public int readIPSize() {
            int offset = UDPPacketReader.this.readBodyOffset() + 256;
            return UDPPacketReader.this._message[offset] & 0xFF;
        }

        public void readIP(byte[] target, int targetOffset) {
            int offset = UDPPacketReader.this.readBodyOffset() + 256;
            int size = UDPPacketReader.this._message[offset] & 0xFF;
            System.arraycopy(UDPPacketReader.this._message, ++offset, target, targetOffset, size);
        }
    }

    public abstract class Reader {
        public byte[] readExtendedOptions() {
            return UDPPacketReader.this.readExtendedOptions();
        }
    }
}

