/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportBid;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.crypto.X25519KeyFactory;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPSendFinisher;
import net.i2p.router.transport.ntcp.OutboundNTCP2State;
import net.i2p.router.transport.ntcp.Reader;
import net.i2p.router.transport.ntcp.Writer;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public class NTCPTransport
extends TransportImpl {
    private final Log _log;
    private final SharedBid _fastBid;
    private final SharedBid _slowBid;
    private final SharedBid _slowCostBid;
    private final SharedBid _nearCapacityBid;
    private final SharedBid _nearCapacityCostBid;
    private final SharedBid _transientFail;
    private final Object _conLock;
    private final ConcurrentHashMap<Hash, NTCPConnection> _conByIdent;
    private final EventPumper _pumper;
    private final Reader _reader;
    private Writer _writer;
    private int _ssuPort;
    private final Set<InetSocketAddress> _endpoints;
    private final int _networkID;
    private final Set<NTCPConnection> _establishing;
    private final DecayingBloomFilter _replayFilter;
    private boolean _haveIPv6Address;
    private long _lastInboundIPv4;
    private long _lastInboundIPv6;
    public static final String PROP_I2NP_NTCP_HOSTNAME = "i2np.ntcp.hostname";
    public static final String PROP_I2NP_NTCP_PORT = "i2np.ntcp.port";
    public static final String PROP_I2NP_NTCP_AUTO_PORT = "i2np.ntcp.autoport";
    public static final String PROP_I2NP_NTCP_AUTO_IP = "i2np.ntcp.autoip";
    private static final String PROP_ADVANCED = "routerconsole.advanced";
    private static final int DEFAULT_COST = 10;
    private static final int NTCP2_OUTBOUND_COST = 14;
    public static final String PROP_BIND_INTERFACE = "i2np.ntcp.bindInterface";
    private final NTCPSendFinisher _finisher;
    private final X25519KeyFactory _xdhFactory;
    private long _lastBadSkew;
    private static final long[] RATES = new long[]{600000L};
    public static final String MIN_SIGTYPE_VERSION = "0.9.16";
    public static final String STYLE = "NTCP";
    public static final String STYLE2 = "NTCP2";
    static final int NTCP2_INT_VERSION = 2;
    static final String NTCP2_VERSION = Integer.toString(2);
    static final String NTCP2_VERSION_ALT = NTCP2_VERSION + ',';
    public static final String PROP_NTCP2_SP = "i2np.ntcp2.sp";
    public static final String PROP_NTCP2_IV = "i2np.ntcp2.iv";
    private static final int NTCP2_IV_LEN = 16;
    private static final int NTCP2_KEY_LEN = 32;
    private static final long MIN_DOWNTIME_TO_REKEY = 2592000000L;
    private static final long MIN_DOWNTIME_TO_REKEY_HIDDEN = 86400000L;
    private final byte[] _ntcp2StaticPubkey;
    private final byte[] _ntcp2StaticPrivkey;
    private final byte[] _ntcp2StaticIV;
    private final String _b64Ntcp2StaticPubkey;
    private final String _b64Ntcp2StaticIV;
    private static final int MIN_CONCURRENT_READERS = 2;
    private static final int MIN_CONCURRENT_WRITERS = 2;
    private static final int MAX_CONCURRENT_READERS = 4;
    private static final int MAX_CONCURRENT_WRITERS = 4;
    public static final int ESTABLISH_TIMEOUT = 10000;

    public NTCPTransport(RouterContext ctx, DHSessionKeyBuilder.Factory dh, X25519KeyFactory xdh) {
        super(ctx);
        boolean shouldRekey;
        this._xdhFactory = xdh;
        this._log = ctx.logManager().getLog(this.getClass());
        this._context.statManager().createRateStat("ntcp.sendTime", "Total message lifetime when sent completely", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.sendQueueSize", "How many messages were ahead of the current one on the connection's queue when it was first added", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveTime", "How long it takes to receive an inbound message", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveSize", "How large the received message was", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.sendBacklogTime", "How long the head of the send queue has been waiting when we fail to add a new one to the queue (period is the number of messages queued)", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeWrites", "How many times do we need to proactively add in an extra nio write to a peer at any given failsafe pass?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeCloses", "How many times do we need to proactively close an idle connection to a peer at any given failsafe pass?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeInvalid", "How many times do we close a connection to a peer to work around a JVM bug?", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.failsafeThrottle", "Delay event pumper", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.accept", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.attemptBanlistedPeer", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.attemptUnreachablePeer", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.closeOnBacklog", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedTimeout", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedTimeoutIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectFailedUnresolved", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.connectSuccessful", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptDecryptedI2NP", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPCRC", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPIME", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptI2NPIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptMetaCRC", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.corruptTooLargeI2NP", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.dontSendOnBacklog", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundEstablished", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundEstablishedDuplicate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundIPv4Conn", "Inbound IPv4 NTCP Connection", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.inboundIPv6Conn", "Inbound IPv6 NTCP Connection", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidDH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidHXY", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidHXxorBIH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundDFE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundIOE", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSignature", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSize", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidInboundSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidSignature", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.multipleCloseOnRemove", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.outboundEstablishFailed", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.outboundFailedIOEImmediate", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.invalidOutboundSkew", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.noBidTooLargeI2NP", "send size", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.queuedRecv", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.read", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.readError", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveCorruptEstablishment", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.receiveMeta", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.registerConnect", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.replayHXxorBIH", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.throttledReadComplete", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.throttledWriteComplete", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.wantsQueuedWrite", "", "ntcp", RATES);
        this._context.statManager().createRateStat("ntcp.writeError", "", "ntcp", RATES);
        this._endpoints = new HashSet<InetSocketAddress>(4);
        this._establishing = new ConcurrentHashSet<NTCPConnection>(16);
        this._conLock = new Object();
        this._conByIdent = new ConcurrentHashMap(64);
        this._replayFilter = new DecayingHashSet(ctx, 600000, 8, "NTCP-Hx^HI");
        this._finisher = new NTCPSendFinisher(ctx, this);
        this._pumper = new EventPumper(ctx, this);
        this._reader = new Reader(ctx);
        this._writer = new Writer(ctx);
        this._networkID = ctx.router().getNetworkID();
        this._fastBid = new SharedBid(25);
        this._slowBid = new SharedBid(70);
        this._slowCostBid = new SharedBid(85);
        this._nearCapacityBid = new SharedBid(90);
        this._nearCapacityCostBid = new SharedBid(105);
        this._transientFail = new SharedBid(999999);
        this.setupPort();
        if (xdh == null) {
            throw new IllegalArgumentException();
        }
        boolean shouldSave = false;
        byte[] priv = null;
        byte[] iv = null;
        String b64IV = null;
        String s = null;
        long minDowntime = this._context.router().isHidden() ? 86400000L : 2592000000L;
        boolean bl = shouldRekey = this._context.getEstimatedDowntime() >= minDowntime;
        if (!shouldRekey && (s = ctx.getProperty(PROP_NTCP2_SP)) != null) {
            priv = Base64.decode(s);
        }
        if (priv == null || priv.length != 32) {
            KeyPair keys = xdh.getKeys();
            this._ntcp2StaticPrivkey = keys.getPrivate().getData();
            this._ntcp2StaticPubkey = keys.getPublic().getData();
            shouldSave = true;
        } else {
            this._ntcp2StaticPrivkey = priv;
            this._ntcp2StaticPubkey = new PrivateKey(EncType.ECIES_X25519, priv).toPublic().getData();
        }
        if (!shouldSave && (s = ctx.getProperty(PROP_NTCP2_IV)) != null) {
            iv = Base64.decode(s);
            b64IV = s;
        }
        if (iv == null || iv.length != 16) {
            iv = new byte[16];
            do {
                ctx.random().nextBytes(iv);
            } while (DataHelper.eq(iv, 0, OutboundNTCP2State.ZEROKEY, 0, 16));
            shouldSave = true;
        }
        if (shouldSave) {
            HashMap<String, String> changes = new HashMap<String, String>(2);
            String b64Priv = Base64.encode(this._ntcp2StaticPrivkey);
            b64IV = Base64.encode(iv);
            changes.put(PROP_NTCP2_SP, b64Priv);
            changes.put(PROP_NTCP2_IV, b64IV);
            ctx.router().saveConfig(changes, null);
        }
        this._ntcp2StaticIV = iv;
        this._b64Ntcp2StaticPubkey = Base64.encode(this._ntcp2StaticPubkey);
        this._b64Ntcp2StaticIV = b64IV;
    }

    private void setupPort() {
        if (this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable")) {
            return;
        }
        int port = this.getRequestedPort();
        if (port > 0 && !TransportUtil.isValidPort(port)) {
            TransportUtil.logInvalidPort(this._log, STYLE, port);
        }
        if (port <= 0) {
            port = TransportUtil.selectRandomPort(this._context, STYLE);
            HashMap<String, String> changes = new HashMap<String, String>(2);
            changes.put(PROP_I2NP_NTCP_PORT, Integer.toString(port));
            this._context.router().saveConfig(changes, null);
            this._log.logAlways(20, "NTCP selected random port " + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTCPConnection inboundEstablished(NTCPConnection con) {
        NTCPConnection old;
        this._context.statManager().addRateData("ntcp.inboundEstablished", 1L);
        Hash peer = con.getRemotePeer().calculateHash();
        this.markReachable(peer, true);
        Object object = this._conLock;
        synchronized (object) {
            old = this._conByIdent.put(peer, con);
        }
        if (con.isIPv6()) {
            long last = this._lastInboundIPv6;
            CommSystemFacade.Status oldStatus = last <= 0L ? this.getReachabilityStatus() : null;
            this._lastInboundIPv6 = con.getCreated();
            if (last <= 0L) {
                this.addressChanged(oldStatus);
            }
            this._context.statManager().addRateData("ntcp.inboundIPv6Conn", 1L);
        } else {
            long last = this._lastInboundIPv4;
            CommSystemFacade.Status oldStatus = last <= 0L ? this.getReachabilityStatus() : null;
            this._lastInboundIPv4 = con.getCreated();
            if (last <= 0L) {
                this.addressChanged(oldStatus);
            }
            this._context.statManager().addRateData("ntcp.inboundIPv4Conn", 1L);
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void outboundMessageReady() {
        OutNetMessage msg = this.getNextMessage();
        if (msg != null) {
            RouterInfo target = msg.getTarget();
            RouterIdentity ident = target.getIdentity();
            Hash ih = ident.calculateHash();
            NTCPConnection con = null;
            int newVersion = 0;
            boolean fail = false;
            Object object = this._conLock;
            synchronized (object) {
                con = this._conByIdent.get(ih);
                if (con == null) {
                    RouterAddress addr = this.getTargetAddress(target);
                    if (addr != null) {
                        newVersion = this.getNTCPVersion(addr);
                        if (newVersion != 0) {
                            try {
                                con = new NTCPConnection(this._context, this, ident, addr, newVersion);
                                this.establishing(con);
                                this._conByIdent.put(ih, con);
                            }
                            catch (DataFormatException dfe) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("bad address? " + target, dfe);
                                }
                                fail = true;
                            }
                        } else {
                            fail = true;
                        }
                    } else {
                        fail = true;
                    }
                }
            }
            if (fail) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("we bid on a peer who doesn't have an ntcp address? " + target);
                }
                this.afterSend(msg, false);
                return;
            }
            if (newVersion != 0) {
                DatabaseStoreMessage dsm;
                boolean shouldSkipInfo = false;
                boolean shouldFlood = false;
                I2NPMessage m = msg.getMessage();
                if (m.getType() == 1 && (dsm = (DatabaseStoreMessage)m).getKey().equals(this._context.routerHash())) {
                    shouldSkipInfo = true;
                    boolean bl = shouldFlood = dsm.getReplyToken() != 0L;
                }
                if (!shouldSkipInfo) {
                    con.send(msg);
                } else if (shouldFlood || newVersion == 1) {
                    con.send(msg);
                } else if (this._log.shouldLog(20)) {
                    this._log.info("SKIPPING INFO message: " + con);
                }
                try {
                    SocketChannel channel = SocketChannel.open();
                    con.setChannel(channel);
                    channel.configureBlocking(false);
                    this._pumper.registerConnect(con);
                    con.getEstablishState().prepareOutbound();
                }
                catch (IOException ioe) {
                    if (this._log.shouldLog(40)) {
                        this._log.error("Error opening a channel", ioe);
                    }
                    this._context.statManager().addRateData("ntcp.outboundFailedIOEImmediate", 1L);
                    con.close();
                    this.afterSend(msg, false);
                }
                catch (IllegalStateException ise) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Failed opening a channel", ise);
                    }
                    this.afterSend(msg, false);
                }
            } else {
                con.send(msg);
            }
        }
    }

    @Override
    public void afterSend(OutNetMessage msg, boolean sendSuccessful, boolean allowRequeue, long msToSend) {
        super.afterSend(msg, sendSuccessful, allowRequeue, msToSend);
    }

    @Override
    public TransportBid bid(RouterInfo toAddress, int dataSize) {
        String v;
        RouterIdentity id;
        if (!this.isAlive()) {
            return null;
        }
        if (dataSize > 65523) {
            this._context.statManager().addRateData("ntcp.noBidTooLargeI2NP", dataSize);
            return null;
        }
        Hash peer = toAddress.getIdentity().calculateHash();
        if (this._context.banlist().isBanlisted(peer, STYLE)) {
            this._context.statManager().addRateData("ntcp.attemptBanlistedPeer", 1L);
            return null;
        }
        if (this.isUnreachable(peer)) {
            this._context.statManager().addRateData("ntcp.attemptUnreachablePeer", 1L);
            return null;
        }
        boolean established = this.isEstablished(peer);
        if (established) {
            return this._fastBid;
        }
        int nid = toAddress.getNetworkId();
        if (nid != this._networkID) {
            if (nid == -1) {
                this._context.banlist().banlistRouter(peer, "No network specified", null, null, this._context.clock().now() + 2592000000L);
            } else {
                this._context.banlist().banlistRouterForever(peer, "Not in our network: " + nid);
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Not in our network: " + toAddress, new Exception());
            }
            this.markUnreachable(peer);
            return null;
        }
        RouterAddress addr = this.getTargetAddress(toAddress);
        if (addr == null) {
            this.markUnreachable(peer);
            return null;
        }
        SigType type = toAddress.getIdentity().getSigType();
        if (type == null || !type.isAvailable()) {
            this.markUnreachable(peer);
            return null;
        }
        RouterInfo us = this._context.router().getRouterInfo();
        if (us != null && (id = us.getIdentity()).getSigType() != SigType.DSA_SHA1 && VersionComparator.comp(v = toAddress.getVersion(), MIN_SIGTYPE_VERSION) < 0) {
            this.markUnreachable(peer);
            return null;
        }
        if (!this.allowConnection()) {
            return this._transientFail;
        }
        if (this.haveCapacity()) {
            if (addr.getCost() > 10) {
                return this._slowCostBid;
            }
            return this._slowBid;
        }
        if (addr.getCost() > 10) {
            return this._nearCapacityCostBid;
        }
        return this._nearCapacityBid;
    }

    private RouterAddress getTargetAddress(RouterInfo target) {
        List<RouterAddress> addrs = this.getTargetAddresses(target);
        for (int i = 0; i < addrs.size(); ++i) {
            RouterAddress addr = addrs.get(i);
            if (this.getNTCPVersion(addr) == 0) continue;
            byte[] ip = addr.getIP();
            if (!TransportUtil.isValidPort(addr.getPort()) || ip == null || !this.isValid(ip) && !this.allowLocal()) continue;
            return addr;
        }
        return null;
    }

    private boolean isValid(byte[] addr) {
        if (addr == null) {
            return false;
        }
        return this.isPubliclyRoutable(addr) && (addr.length != 16 || this._haveIPv6Address);
    }

    public boolean allowConnection() {
        return this._conByIdent.size() < this.getMaxConnections();
    }

    void sendComplete(OutNetMessage msg) {
        this._finisher.add(msg);
    }

    @Override
    public boolean isEstablished(Hash dest) {
        NTCPConnection con = this._conByIdent.get(dest);
        return con != null && con.isEstablished() && !con.isClosed();
    }

    @Override
    public boolean isBacklogged(Hash dest) {
        NTCPConnection con = this._conByIdent.get(dest);
        return con != null && con.isEstablished() && con.tooBacklogged();
    }

    @Override
    public void mayDisconnect(Hash peer) {
        NTCPConnection con = this._conByIdent.get(peer);
        if (con != null && con.isEstablished() && con.getMessagesReceived() <= 2 && con.getMessagesSent() <= 1) {
            con.setMayDisconnect();
        }
    }

    @Override
    public void forceDisconnect(Hash peer) {
        NTCPConnection con = this._conByIdent.remove(peer);
        if (con != null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Force disconnect of " + peer, new Exception("I did it"));
            }
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTCPConnection removeCon(NTCPConnection con) {
        NTCPConnection removed = null;
        RouterIdentity ident = con.getRemotePeer();
        if (ident != null) {
            Object object = this._conLock;
            synchronized (object) {
                if (this._conByIdent.remove(ident.calculateHash(), con)) {
                    removed = con;
                }
            }
        }
        return removed;
    }

    @Override
    public int countPeers() {
        return this._conByIdent.size();
    }

    public Collection<NTCPConnection> getPeers() {
        return this._conByIdent.values();
    }

    @Override
    public Set<Hash> getEstablished() {
        HashSet<Hash> rv = new HashSet<Hash>(this._conByIdent.keySet());
        for (Map.Entry<Hash, NTCPConnection> e : this._conByIdent.entrySet()) {
            NTCPConnection con = e.getValue();
            if (con.isEstablished() && !con.isClosed()) continue;
            rv.remove(e.getKey());
        }
        return rv;
    }

    @Override
    public int countActivePeers() {
        long now = this._context.clock().now();
        int active = 0;
        for (NTCPConnection con : this._conByIdent.values()) {
            if ((con.getMessagesSent() <= 0 || con.getTimeSinceSend(now) > 300000L) && (con.getMessagesReceived() <= 0 || con.getTimeSinceReceive(now) > 300000L)) continue;
            ++active;
        }
        return active;
    }

    @Override
    public int countActiveSendPeers() {
        long now = this._context.clock().now();
        int active = 0;
        for (NTCPConnection con : this._conByIdent.values()) {
            if (con.getMessagesSent() <= 0 || con.getTimeSinceSend(now) > 60000L) continue;
            ++active;
        }
        return active;
    }

    void setLastBadSkew(long skew) {
        this._lastBadSkew = skew;
    }

    @Override
    public List<Long> getClockSkews() {
        ArrayList<Long> skews = new ArrayList<Long>(this._conByIdent.size());
        long tooOld = this._context.clock().now() - 600000L;
        for (NTCPConnection con : this._conByIdent.values()) {
            if (!con.isEstablished() || con.getCreated() <= tooOld) continue;
            skews.add(con.getClockSkew());
        }
        if (skews.size() < 5 && this._lastBadSkew != 0L) {
            skews.add(this._lastBadSkew);
        }
        return skews;
    }

    boolean isHXHIValid(byte[] hxhi) {
        return !this._replayFilter.add(hxhi, 0, 8);
    }

    @Override
    public synchronized void startListening() {
        if (this._pumper.isAlive()) {
            return;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Starting NTCP transport listening");
        }
        this.startIt();
        RouterAddress addr = this.configureLocalAddress();
        int port = addr != null ? addr.getPort() : this._ssuPort;
        boolean isFixedOrForceFirewalled = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true").toLowerCase(Locale.US).equals("false");
        RouterAddress myAddress = this.bindAddress(port);
        if (myAddress != null) {
            this.replaceAddress(myAddress);
        } else if (addr != null) {
            this.replaceAddress(addr);
        } else if (port > 0 && !isFixedOrForceFirewalled) {
            Collection<InetAddress> addrs = this.getSavedLocalAddresses();
            if (!addrs.isEmpty() && !this._context.router().isHidden()) {
                int count = 0;
                boolean skipv4 = false;
                boolean skipv6 = false;
                for (InetAddress ia : addrs) {
                    boolean ipv6 = ia instanceof Inet6Address;
                    if (ipv6 && (this.isIPv6Firewalled() || this._context.getBooleanProperty("i2np.lastIPv6Firewalled")) || !ipv6 && this.isIPv4Firewalled()) {
                        if (ipv6) {
                            skipv6 = true;
                            continue;
                        }
                        skipv4 = true;
                        continue;
                    }
                    OrderedProperties props = new OrderedProperties();
                    props.setProperty("host", ia.getHostAddress());
                    props.setProperty("port", Integer.toString(port));
                    this.addNTCP2Options(props);
                    int cost = this.getDefaultCost(ipv6);
                    myAddress = new RouterAddress(this.getPublishStyle(), props, cost);
                    this.replaceAddress(myAddress);
                    ++count;
                }
                if (count <= 0) {
                    this.setOutboundNTCP2Address();
                } else if (skipv6) {
                    this.setOutboundNTCP2Address(true);
                } else if (skipv4) {
                    this.setOutboundNTCP2Address(false);
                }
            } else {
                this.setOutboundNTCP2Address();
            }
        } else {
            this.setOutboundNTCP2Address();
        }
    }

    private void setOutboundNTCP2Address() {
        OrderedProperties props = new OrderedProperties();
        this.addNTCP2Options(props);
        RouterAddress myAddress = new RouterAddress(STYLE2, props, 14);
        this.replaceAddress(myAddress);
    }

    private void setOutboundNTCP2Address(boolean ipv6) {
        String caps;
        TransportUtil.IPv6Config config = this.getIPv6Config();
        if (ipv6) {
            if (config == TransportUtil.IPv6Config.IPV6_DISABLED) {
                return;
            }
            caps = "6";
        } else {
            if (config == TransportUtil.IPv6Config.IPV6_ONLY) {
                return;
            }
            caps = "4";
        }
        OrderedProperties props = new OrderedProperties();
        props.setProperty("caps", caps);
        props.setProperty("s", this._b64Ntcp2StaticPubkey);
        props.setProperty("v", NTCP2_VERSION);
        RouterAddress myAddress = new RouterAddress(STYLE2, props, 14);
        this.replaceAddress(myAddress);
    }

    private synchronized void restartListening(RouterAddress addr, boolean ipv6) {
        if (addr != null) {
            RouterAddress myAddress = this.bindAddress(addr.getPort());
            if (myAddress != null) {
                this.replaceAddress(myAddress);
            } else {
                this.replaceAddress(addr);
            }
        } else {
            this.removeAddress(ipv6);
            if (ipv6) {
                this._lastInboundIPv6 = 0L;
            } else {
                this._lastInboundIPv4 = 0L;
            }
        }
    }

    private void startIt() {
        int nr;
        int nw;
        this._finisher.start();
        this._pumper.startPumping();
        long maxMemory = SystemVersion.getMaxMemory();
        if (maxMemory < 0x2000000L) {
            nw = 1;
            nr = 1;
        } else if (maxMemory < 0x4000000L) {
            nw = 2;
            nr = 2;
        } else {
            nr = Math.max(2, Math.min(4, this._context.bandwidthLimiter().getInboundKBytesPerSecond() / 20));
            nw = Math.max(2, Math.min(4, this._context.bandwidthLimiter().getOutboundKBytesPerSecond() / 20));
        }
        this._reader.startReading(nr);
        this._writer.startWriting(nw);
    }

    public boolean isAlive() {
        return this._pumper.isAlive();
    }

    private RouterAddress bindAddress(int port) {
        RouterAddress myAddress = null;
        if (port > 0) {
            InetAddress bindToAddr = null;
            String bindTo = this._context.getProperty(PROP_BIND_INTERFACE);
            if (bindTo == null) {
                bindTo = this.getFixedHost();
            }
            if (bindTo != null) {
                try {
                    bindToAddr = InetAddress.getByName(bindTo);
                }
                catch (UnknownHostException uhe) {
                    this._log.error("Invalid NTCP bind interface specified [" + bindTo + "]", uhe);
                }
            }
            try {
                InetSocketAddress addr;
                if (bindToAddr == null) {
                    addr = new InetSocketAddress(port);
                } else {
                    addr = new InetSocketAddress(bindToAddr, port);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Binding only to " + bindToAddr);
                    }
                    OrderedProperties props = new OrderedProperties();
                    props.setProperty("host", bindTo);
                    props.setProperty("port", Integer.toString(port));
                    this.addNTCP2Options(props);
                    int cost = this.getDefaultCost(false);
                    myAddress = new RouterAddress(this.getPublishStyle(), props, cost);
                }
                if (!this._endpoints.isEmpty()) {
                    if (this._endpoints.contains(addr) || bindToAddr != null && this._endpoints.contains(new InetSocketAddress(port))) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Already listening on " + addr);
                        }
                        return null;
                    }
                    this.stopWaitAndRestart();
                }
                if (!TransportUtil.isValidPort(port)) {
                    this._log.error("Specified NTCP port is " + port + ", ports lower than 1024 not recommended");
                }
                ServerSocketChannel chan = ServerSocketChannel.open();
                chan.configureBlocking(false);
                chan.socket().bind(addr);
                this._endpoints.add(addr);
                if (this._log.shouldLog(20)) {
                    this._log.info("Listening on " + addr);
                }
                this._pumper.register(chan);
            }
            catch (IOException ioe) {
                this._log.error("Error listening", ioe);
                myAddress = null;
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Outbound NTCP connections only - no listener configured");
        }
        return myAddress;
    }

    private String getFixedHost() {
        boolean isFixed = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true").toLowerCase(Locale.US).equals("false");
        String fixedHost = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        if (isFixed && fixedHost != null) {
            try {
                String testAddr = InetAddress.getByName(fixedHost).getHostAddress();
                if (Addresses.getAddresses().contains(testAddr)) {
                    return testAddr;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return null;
    }

    private void stopWaitAndRestart() {
        if (this._log.shouldLog(30)) {
            this._log.warn("Halting NTCP to change address");
        }
        this.stopListening();
        while (this.isAlive()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Restarting NTCP transport listening");
        }
        this.startIt();
    }

    Reader getReader() {
        return this._reader;
    }

    Writer getWriter() {
        return this._writer;
    }

    @Override
    public String getStyle() {
        return STYLE;
    }

    @Override
    public String getAltStyle() {
        return STYLE2;
    }

    private String getPublishStyle() {
        return STYLE2;
    }

    EventPumper getPumper() {
        return this._pumper;
    }

    X25519KeyFactory getXDHFactory() {
        return this._xdhFactory;
    }

    void establishing(NTCPConnection con) {
        this._establishing.add(con);
    }

    void expireTimedOut() {
        int expired = 0;
        long now = this._context.clock().now();
        Iterator<NTCPConnection> iter = this._establishing.iterator();
        while (iter.hasNext()) {
            NTCPConnection con = iter.next();
            if (con.isClosed() || con.isEstablished()) {
                iter.remove();
                continue;
            }
            if (con.getTimeSinceCreated(now) <= 10000L) continue;
            iter.remove();
            con.close();
            ++expired;
        }
        if (expired > 0) {
            this._context.statManager().addRateData("ntcp.outboundEstablishFailed", expired);
        }
    }

    private RouterAddress configureLocalAddress() {
        RouterAddress addr = this.createNTCPAddress();
        if (addr != null) {
            if (addr.getPort() <= 0) {
                addr = null;
                if (this._log.shouldLog(40)) {
                    this._log.error("NTCP address is outbound only, since the NTCP configuration is invalid");
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info("NTCP address configured: " + addr);
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("NTCP address is outbound only");
        }
        return addr;
    }

    private RouterAddress createNTCPAddress() {
        int p = this._context.getProperty(PROP_I2NP_NTCP_PORT, -1);
        if (p <= 0 || p >= 65536) {
            return null;
        }
        String name = this.getConfiguredIP();
        if (name == null) {
            return null;
        }
        OrderedProperties props = new OrderedProperties();
        props.setProperty("host", name);
        props.setProperty("port", Integer.toString(p));
        this.addNTCP2Options(props);
        int cost = this.getDefaultCost(false);
        RouterAddress addr = new RouterAddress(this.getPublishStyle(), props, cost);
        return addr;
    }

    private void addNTCP2Options(Properties props) {
        if (props.containsKey("host")) {
            props.setProperty("i", this._b64Ntcp2StaticIV);
            props.remove("caps");
        } else {
            TransportUtil.IPv6Config config = this.getIPv6Config();
            String caps = config == TransportUtil.IPv6Config.IPV6_ONLY ? "6" : (config != TransportUtil.IPv6Config.IPV6_DISABLED && this._haveIPv6Address ? "46" : "4");
            props.setProperty("caps", caps);
        }
        props.setProperty("s", this._b64Ntcp2StaticPubkey);
        props.setProperty("v", NTCP2_VERSION);
    }

    byte[] getNTCP2StaticPubkey() {
        return this._ntcp2StaticPubkey;
    }

    byte[] getNTCP2StaticPrivkey() {
        return this._ntcp2StaticPrivkey;
    }

    byte[] getNTCP2StaticIV() {
        return this._ntcp2StaticIV;
    }

    private int getNTCPVersion(RouterAddress addr) {
        String style = addr.getTransportStyle();
        if (style.equals(STYLE)) {
            boolean rv = true;
        } else if (style.equals(STYLE2)) {
            int rv = 2;
        } else {
            return 0;
        }
        String v = addr.getOption("v");
        if (v == null || addr.getOption("i") == null || addr.getOption("s") == null || !v.equals(NTCP2_VERSION) && !v.startsWith(NTCP2_VERSION_ALT)) {
            return 0;
        }
        return 2;
    }

    private String getConfiguredIP() {
        String name = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        if (name == null || name.trim().length() <= 0 || "null".equals(name)) {
            return null;
        }
        String[] hosts = DataHelper.split(name, "[,; \r\n\t]");
        ArrayList<String> ipstrings = new ArrayList<String>(2);
        boolean v4 = false;
        boolean v6 = false;
        TransportUtil.IPv6Config cfg = this.getIPv6Config();
        if (cfg == TransportUtil.IPv6Config.IPV6_DISABLED) {
            v6 = true;
        } else if (cfg == TransportUtil.IPv6Config.IPV6_ONLY) {
            v4 = true;
        }
        for (int i = 0; i < hosts.length; ++i) {
            String h = hosts[i];
            if (h.length() <= 0) continue;
            if (Addresses.isIPv4Address(h)) {
                if (v4) continue;
                v4 = true;
                ipstrings.add(h);
                continue;
            }
            if (Addresses.isIPv6Address(h)) {
                if (v6) continue;
                v6 = true;
                ipstrings.add(h);
                continue;
            }
            int valid = 0;
            List<byte[]> ips = Addresses.getIPs(h);
            if (ips != null) {
                for (byte[] ip : ips) {
                    if (!this.isValid(ip)) {
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("skipping invalid " + Addresses.toString(ip) + " for " + h);
                        continue;
                    }
                    if (v4 && ip.length == 4 || v6 && ip.length == 16) {
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("skipping additional " + Addresses.toString(ip) + " for " + h);
                        continue;
                    }
                    if (ip.length == 4) {
                        v4 = true;
                    } else if (ip.length == 16) {
                        v6 = true;
                    }
                    ++valid;
                    if (this._log.shouldDebug()) {
                        this._log.debug("adding " + Addresses.toString(ip) + " for " + h);
                    }
                    ipstrings.add(Addresses.toString(ip));
                }
            }
            if (valid != 0) continue;
            this._log.error("No valid IPs for configured hostname " + h);
        }
        if (ipstrings.isEmpty()) {
            this._log.error("No valid IPs for configuration: " + name);
            return null;
        }
        String ip = null;
        for (String ips : ipstrings) {
            if (!ips.contains(".")) continue;
            ip = ips;
            break;
        }
        if (ip == null) {
            ip = (String)ipstrings.get(0);
        }
        return ip;
    }

    private int getDefaultCost(boolean isIPv6) {
        int rv = 10;
        if (isIPv6) {
            TransportUtil.IPv6Config config = this.getIPv6Config();
            if (config == TransportUtil.IPv6Config.IPV6_PREFERRED) {
                --rv;
            } else if (config == TransportUtil.IPv6Config.IPV6_NOT_PREFERRED) {
                ++rv;
            }
        }
        return rv;
    }

    @Override
    public void externalAddressReceived(Transport.AddressSource source, byte[] ip, int port) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Received address: " + Addresses.toString(ip, port) + " from: " + (Object)((Object)source), new Exception());
        }
        if ((source == Transport.AddressSource.SOURCE_INTERFACE || source == Transport.AddressSource.SOURCE_SSU) && ip != null && ip.length == 16) {
            this._haveIPv6Address = true;
        }
        if (ip != null && !this.isValid(ip) && !this.allowLocal()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Invalid address: " + Addresses.toString(ip, port) + " from: " + (Object)((Object)source));
            }
            return;
        }
        if (!this.isAlive()) {
            if (source == Transport.AddressSource.SOURCE_INTERFACE || source == Transport.AddressSource.SOURCE_UPNP) {
                try {
                    InetAddress ia = InetAddress.getByAddress(ip);
                    this.saveLocalAddress(ia);
                }
                catch (UnknownHostException ia) {}
            } else if (source == Transport.AddressSource.SOURCE_CONFIG) {
                this._ssuPort = port;
            }
            return;
        }
        boolean ssuEnabled = this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable");
        if (source != Transport.AddressSource.SOURCE_SSU && ssuEnabled) {
            return;
        }
        CommSystemFacade.Status old = ssuEnabled ? null : this.getReachabilityStatus();
        boolean isIPv6 = ip != null && ip.length == 16;
        boolean changed = this.externalAddressReceived(ip, isIPv6, port);
        if (changed && !ssuEnabled) {
            this.addressChanged(old);
        }
    }

    @Override
    public void externalAddressRemoved(Transport.AddressSource source, boolean ipv6) {
        if (this._log.shouldWarn()) {
            this._log.warn("Removing address, ipv6? " + ipv6 + " from: " + (Object)((Object)source), new Exception());
        }
        boolean ssuEnabled = this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable");
        if (source != Transport.AddressSource.SOURCE_SSU && ssuEnabled) {
            return;
        }
        CommSystemFacade.Status old = ssuEnabled ? null : this.getReachabilityStatus();
        boolean changed = this.externalAddressReceived(null, ipv6, 0);
        if (changed && !ssuEnabled) {
            this.addressChanged(old);
        }
    }

    private void addressChanged(CommSystemFacade.Status old) {
        CommSystemFacade.Status status = this.getReachabilityStatus();
        if (status != old) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Old status: " + (Object)((Object)old) + " New status: " + (Object)((Object)status) + " from: ", new Exception("traceback"));
            }
            if (old != CommSystemFacade.Status.UNKNOWN && this._context.router().getUptime() > 300000L) {
                this._context.router().eventLog().addEvent("reachability", "from " + this._t(old.toStatusString()) + " to " + this._t(status.toStatusString()));
            }
        }
        this._context.router().rebuildRouterInfo();
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized boolean externalAddressReceived(byte[] ip, boolean isIPv6, int port) {
        boolean ssuOK;
        int cost;
        RouterAddress oldAddr = this.getCurrentAddress(isIPv6);
        if (this._log.shouldLog(20)) {
            this._log.info("Changing NTCP Address? was " + oldAddr);
        }
        OrderedProperties newProps = new OrderedProperties();
        if (oldAddr == null) {
            cost = this.getDefaultCost(isIPv6);
        } else {
            cost = oldAddr.getCost();
            newProps.putAll(oldAddr.getOptionsMap());
        }
        RouterAddress newAddr = new RouterAddress(this.getPublishStyle(), newProps, cost);
        boolean changed = false;
        String oport = newProps.getProperty("port");
        String nport = null;
        String cport = this._context.getProperty(PROP_I2NP_NTCP_PORT);
        if (cport != null && cport.length() > 0) {
            nport = cport;
        } else if (this._context.getBooleanPropertyDefaultTrue(PROP_I2NP_NTCP_AUTO_PORT) && port > 0) {
            nport = Integer.toString(port);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("old port: " + oport + " config: " + cport + " new: " + nport);
        }
        if (oport == null && nport != null && nport.length() > 0) {
            newProps.setProperty("port", nport);
            changed = true;
        }
        String ohost = newProps.getProperty("host");
        String enabled = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true").toLowerCase(Locale.US);
        String name = this.getConfiguredIP();
        if (name != null && name.length() > 0) {
            enabled = "false";
        }
        boolean bl = ssuOK = ip != null;
        if (this._log.shouldLog(20)) {
            this._log.info("old: " + ohost + " config: " + name + " auto: " + enabled + " ssuOK? " + ssuOK);
        }
        if (enabled.equals("always") || Boolean.parseBoolean(enabled) && ssuOK) {
            if (!ssuOK) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("null address with always config", new Exception());
                }
                return false;
            }
            String nhost = Addresses.toString(ip);
            if (this._log.shouldLog(20)) {
                this._log.info("old: " + ohost + " config: " + name + " new: " + nhost);
            }
            if (nhost == null || nhost.length() <= 0) {
                return false;
            }
            if (ohost == null || !ohost.equalsIgnoreCase(nhost)) {
                newProps.setProperty("host", nhost);
                if (cost == 14) {
                    newAddr.setCost(10);
                }
                changed = true;
            }
        } else if (enabled.equals("false") && name != null && name.length() > 0 && !name.equals(ohost)) {
            if (this._log.shouldLog(20)) {
                this._log.info("old host: " + ohost + " config: " + name + " new: " + name);
            }
            newProps.setProperty("host", name);
            if (cost == 14) {
                newAddr.setCost(10);
            }
            changed = true;
        } else {
            if (ohost == null || ohost.length() <= 0) {
                if (this._log.shouldInfo()) {
                    this._log.info("No old host, no new host, no change to NTCP Address");
                }
                return false;
            }
            if (Boolean.parseBoolean(enabled) && !ssuOK) {
                if (this._log.shouldLog(20)) {
                    this._log.info("old host: " + ohost + " config: " + name + " new: null");
                }
                newProps.clear();
                newAddr = new RouterAddress(STYLE2, newProps, 14);
                changed = true;
            }
        }
        if (!changed) {
            if (oldAddr == null) {
                this._log.info("No change to NTCP Address");
                return false;
            }
            int oldCost = oldAddr.getCost();
            int newCost = this.getDefaultCost(ohost != null && ohost.contains(":"));
            if (!this.haveCapacity()) {
                ++newCost;
            }
            if (newCost == oldCost) {
                this._log.info("No change to NTCP Address");
                return false;
            }
            newAddr.setCost(newCost);
            if (this._log.shouldLog(30)) {
                this._log.warn("Changing NTCP cost from " + oldCost + " to " + newCost);
            }
        }
        if (!isIPv6 || newProps.containsKey("host") || this.getIPv6Config() == TransportUtil.IPv6Config.IPV6_ONLY) {
            this.addNTCP2Options(newProps);
        } else {
            if (this._log.shouldInfo()) {
                this._log.info("IPv6 now firewalled");
            }
            newAddr = null;
        }
        this.restartListening(newAddr, isIPv6);
        if (this._log.shouldLog(30)) {
            this._log.warn("Updating NTCP Address (ipv6? " + isIPv6 + ") with " + newAddr);
        }
        return true;
    }

    @Override
    public void forwardPortStatus(byte[] ip, int port, int externalPort, boolean success, String reason) {
        if (this._log.shouldLog(30)) {
            if (success) {
                this._log.warn("UPnP has opened the NTCP port: " + port + " via " + Addresses.toString(ip, externalPort));
            } else {
                this._log.warn("UPnP has failed to open the NTCP port: " + Addresses.toString(ip, externalPort) + " reason: " + reason);
            }
        }
    }

    @Override
    public int getRequestedPort() {
        int port;
        RouterAddress addr = this.getCurrentAddress(false);
        if (addr != null && (port = addr.getPort()) > 0) {
            return port;
        }
        return this._context.getProperty(PROP_I2NP_NTCP_PORT, -1);
    }

    @Override
    public CommSystemFacade.Status getReachabilityStatus() {
        boolean v6OK;
        boolean showFirewalled;
        boolean v6Disabled;
        boolean v4Disabled;
        boolean fwV4 = this.isIPv4Firewalled();
        boolean fwV6 = this.isIPv6Firewalled();
        if (fwV4 && fwV6) {
            return CommSystemFacade.Status.REJECT_UNSOLICITED;
        }
        if (!this.isAlive()) {
            return CommSystemFacade.Status.UNKNOWN;
        }
        TransportUtil.IPv6Config config = this.getIPv6Config();
        if (config == TransportUtil.IPv6Config.IPV6_DISABLED) {
            v4Disabled = false;
            v6Disabled = true;
        } else if (config == TransportUtil.IPv6Config.IPV6_ONLY) {
            v4Disabled = true;
            v6Disabled = false;
        } else {
            v4Disabled = false;
            v6Disabled = false;
        }
        boolean hasV4 = !fwV4 && this.getCurrentAddress(false) != null;
        boolean hasV6 = !fwV6 && this.getCurrentAddress(true) != null;
        boolean bl = showFirewalled = !this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable") && this._context.router().getUptime() > 600000L;
        if (!hasV4 && !hasV6) {
            return showFirewalled ? CommSystemFacade.Status.REJECT_UNSOLICITED : CommSystemFacade.Status.UNKNOWN;
        }
        long now = this._context.clock().now();
        boolean v4OK = hasV4 && !v4Disabled && now - this._lastInboundIPv4 < 600000L;
        boolean bl2 = v6OK = hasV6 && !v6Disabled && now - this._lastInboundIPv6 < 1800000L;
        if (v4OK) {
            if (v6OK) {
                return CommSystemFacade.Status.OK;
            }
            if (v6Disabled) {
                return CommSystemFacade.Status.OK;
            }
            if (!this._haveIPv6Address) {
                return CommSystemFacade.Status.OK;
            }
            if (fwV6) {
                return CommSystemFacade.Status.IPV4_OK_IPV6_FIREWALLED;
            }
            if (!hasV6) {
                return CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN;
            }
        }
        if (v6OK) {
            if (v4Disabled) {
                return CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK;
            }
            if (fwV4) {
                return CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK;
            }
            if (!hasV4) {
                return showFirewalled ? CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK : CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK;
            }
        }
        for (NTCPConnection con : this._conByIdent.values()) {
            if (!con.isInbound()) continue;
            if (con.isIPv6()) {
                if (hasV6) {
                    v6OK = true;
                }
            } else if (hasV4) {
                v4OK = true;
            }
            if (v4OK) {
                if (v6OK) {
                    return CommSystemFacade.Status.OK;
                }
                if (v6Disabled) {
                    return CommSystemFacade.Status.OK;
                }
                if (!hasV6) {
                    return CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN;
                }
            }
            if (!v6OK) continue;
            if (v4Disabled) {
                return CommSystemFacade.Status.IPV4_DISABLED_IPV6_OK;
            }
            if (hasV4) continue;
            return showFirewalled ? CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK : CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK;
        }
        if (v4OK) {
            if (!this._haveIPv6Address) {
                return CommSystemFacade.Status.OK;
            }
            return CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN;
        }
        if (v6OK) {
            return showFirewalled ? CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_OK : CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK;
        }
        if (v4Disabled) {
            return CommSystemFacade.Status.IPV4_DISABLED_IPV6_UNKNOWN;
        }
        return showFirewalled ? CommSystemFacade.Status.REJECT_UNSOLICITED : CommSystemFacade.Status.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopListening() {
        ArrayList<NTCPConnection> cons;
        if (this._log.shouldLog(30)) {
            this._log.warn("Stopping ntcp transport");
        }
        this._pumper.stopPumping();
        this._writer.stopWriting();
        this._reader.stopReading();
        this._finisher.stop();
        Iterator iterator = this._conLock;
        synchronized (iterator) {
            cons = new ArrayList<NTCPConnection>(this._conByIdent.values());
            this._conByIdent.clear();
        }
        for (NTCPConnection con : cons) {
            con.close();
        }
        NTCPConnection.releaseResources();
        this.replaceAddress(null);
        this._endpoints.clear();
        this._lastInboundIPv4 = 0L;
        this._lastInboundIPv6 = 0L;
    }

    public void renderStatusHTML(java.io.Writer out, int sortFlags) throws IOException {
    }

    @Override
    @Deprecated
    public void renderStatusHTML(java.io.Writer out, String urlBase, int sortFlags) throws IOException {
    }

    private class SharedBid
    extends TransportBid {
        public SharedBid(int ms) {
            this.setLatencyMs(ms);
        }

        @Override
        public Transport getTransport() {
            return NTCPTransport.this;
        }

        public String toString() {
            return "NTCP bid @ " + this.getLatencyMs();
        }
    }
}

