/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.artifacts.BaseRepositoryFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.Factory;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;
import org.gradle.internal.service.ServiceRegistry;

public class PublishToMavenRepository
extends AbstractPublishToMaven {
    private final Transient.Var<MavenArtifactRepository> repository = Transient.varOf();
    private final Cached<PublishSpec> spec = Cached.of(this::computeSpec);
    private final Property<Credentials> credentials = this.getProject().getObjects().property(Credentials.class);

    @Internal
    public MavenArtifactRepository getRepository() {
        return (MavenArtifactRepository)this.repository.get();
    }

    @Input
    @Optional
    Property<Credentials> getCredentials() {
        return this.credentials;
    }

    public void setRepository(MavenArtifactRepository repository) {
        this.repository.set((Object)repository);
        this.credentials.set((Provider)((AuthenticationSupportedInternal)repository).getConfiguredCredentials());
    }

    @TaskAction
    public void publish() {
        PublishSpec spec = (PublishSpec)this.spec.get();
        this.doPublish(spec.publication, spec.repository.get(this.getServices()));
    }

    private PublishSpec computeSpec() {
        MavenPublicationInternal publicationInternal = this.getPublicationInternal();
        if (publicationInternal == null) {
            throw new InvalidUserDataException("The 'publication' property is required");
        }
        MavenArtifactRepository repository = this.getRepository();
        if (repository == null) {
            throw new InvalidUserDataException("The 'repository' property is required");
        }
        this.getDuplicatePublicationTracker().checkCanPublish(publicationInternal, repository.getUrl(), repository.getName());
        MavenNormalizedPublication normalizedPublication = publicationInternal.asNormalisedPublication();
        return new PublishSpec(RepositorySpec.of(repository), normalizedPublication);
    }

    private void doPublish(final MavenNormalizedPublication normalizedPublication, final MavenArtifactRepository repository) {
        new PublishOperation(normalizedPublication.getName(), repository.getName()){

            protected void publish() {
                PublishToMavenRepository.this.validatingMavenPublisher().publish(normalizedPublication, repository);
            }
        }.run();
    }

    private MavenPublisher validatingMavenPublisher() {
        return new ValidatingMavenPublisher(this.getMavenPublishers().getRemotePublisher((Factory<File>)this.getTemporaryDirFactory()));
    }

    static abstract class RepositorySpec {
        RepositorySpec() {
        }

        static RepositorySpec of(MavenArtifactRepository repository) {
            return new Configured(repository);
        }

        abstract MavenArtifactRepository get(ServiceRegistry var1);

        static class UnsupportedRepositorySpec
        extends RepositorySpec {
            private final MavenArtifactRepository repository;

            public UnsupportedRepositorySpec(MavenArtifactRepository repository) {
                this.repository = repository;
            }

            @Override
            MavenArtifactRepository get(ServiceRegistry services) {
                return this.repository;
            }
        }

        static class LocalRepositorySpec
        extends RepositorySpec {
            private final URI repositoryUrl;

            public LocalRepositorySpec(URI repositoryUrl) {
                this.repositoryUrl = repositoryUrl;
            }

            @Override
            MavenArtifactRepository get(ServiceRegistry services) {
                MavenArtifactRepository repository = ((BaseRepositoryFactory)services.get(BaseRepositoryFactory.class)).createMavenRepository();
                repository.setUrl(this.repositoryUrl);
                return repository;
            }
        }

        static class Configured
        extends RepositorySpec
        implements Serializable {
            final MavenArtifactRepository repository;

            public Configured(MavenArtifactRepository repository) {
                this.repository = repository;
            }

            @Override
            MavenArtifactRepository get(ServiceRegistry services) {
                return this.repository;
            }

            private Object writeReplace() {
                if ("file".equals(this.repository.getUrl().getScheme())) {
                    return new LocalRepositorySpec(this.repository.getUrl());
                }
                return new UnsupportedRepositorySpec(this.repository);
            }
        }
    }

    static class PublishSpec {
        private final RepositorySpec repository;
        private final MavenNormalizedPublication publication;

        public PublishSpec(RepositorySpec repository, MavenNormalizedPublication publication) {
            this.repository = repository;
            this.publication = publication;
        }
    }
}

