/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.RouteTableDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CreateRouteTable
extends BaseCmd {
    protected static final String NETWORK_GATEWAY_ID = "VPC_ID";

    public CreateRouteTable(String[] args) {
        super("ec2addrtb", "ec2-create-route-table");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        return new Options();
    }

    @Override
    public String getOptionString() {
        return "VPC";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a new route table.");
        System.out.println("     VPC is the ID of the network for which the route table will be created.");
    }

    @Override
    public void printOptions() {
        super.printOptions();
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("VPC");
        this.warnIfTooManyNonOptions();
        String vpcId = this.getNonOptions()[0];
        RequestResultPair result = jec2.createRouteTable(vpcId);
        out.output(System.out, (RouteTableDescription)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new CreateRouteTable(args).invoke();
    }
}

