/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.util;

import java.util.ArrayList;
import java.util.List;

public abstract class LangUtils {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String defaultStr(String str) {
        return str == null ? "" : str;
    }

    public static String defaultStr(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String defaultStrIfEmpty(String str, String defaultStr) {
        return LangUtils.isEmpty(str) ? defaultStr : str;
    }

    public static String trimToEmpty(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    public static String chomp(String str) {
        if (str == null || str.length() == 0 || str.charAt(str.length() - 1) != '\n') {
            return str;
        }
        return str.substring(0, str.length() - 1);
    }

    public static List<String> split(String str, char delimiter) {
        if (str == null) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        char[] chars = str.toCharArray();
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != delimiter) continue;
            strings.add(new String(chars, start, i - start));
            start = i + 1;
        }
        strings.add(start < chars.length ? new String(chars, start, chars.length - start) : "");
        return strings;
    }

    public static String byteArrayToHexString(byte[] arr) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            builder.append(String.format("%02x", arr[i]));
        }
        return builder.toString();
    }
}

