/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.service.impl;

import com.amazon.aes.service.RegionMapping;
import com.amazon.aes.service.RegionMappingFactory;
import com.amazon.aes.service.impl.RegionMappingImpl;
import com.amazon.aes.util.LangUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;

public class RegionMappingFactoryCsvImpl
implements RegionMappingFactory {
    @Override
    public RegionMapping createRegionMapping(Reader reader) throws IOException {
        List<String> line;
        BufferedReader lineReader = new BufferedReader(reader);
        List<String> regions = RegionMappingFactoryCsvImpl.readLine(lineReader);
        if (regions == null) {
            throw new IOException("Input CSV does not have a header line.");
        }
        int nrOfRegions = regions.size();
        RegionMappingImpl regionMapping = new RegionMappingImpl(regions);
        while ((line = RegionMappingFactoryCsvImpl.readLine(lineReader)) != null) {
            if (line.size() != nrOfRegions) {
                throw new IOException("Inconsistent nr of columns in CSV.");
            }
            regionMapping.add(line);
        }
        return regionMapping;
    }

    protected static List<String> readLine(BufferedReader lineReader) throws IOException {
        String line = lineReader.readLine();
        return line == null ? null : Arrays.asList(LangUtils.chomp(line).split(","));
    }
}

