/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=BuildListCalculator.class)
public class BuildListCalculator {
    public ProjectBuildList calculateProjectBuilds(MavenSession session2, List<TaskSegment> taskSegments) {
        ArrayList<ProjectSegment> projectBuilds = new ArrayList<ProjectSegment>();
        MavenProject rootProject = session2.getTopLevelProject();
        for (TaskSegment taskSegment : taskSegments) {
            List<MavenProject> projects = taskSegment.isAggregating() ? Collections.singletonList(rootProject) : session2.getProjects();
            for (MavenProject project2 : projects) {
                BuilderCommon.attachToThread(project2);
                MavenSession copiedSession = session2.clone();
                copiedSession.setCurrentProject(project2);
                projectBuilds.add(new ProjectSegment(project2, taskSegment, copiedSession));
            }
        }
        return new ProjectBuildList(projectBuilds);
    }
}

