"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var specs_1 = require("../../../../specs");
var constants_1 = require("../../../../specs/constants");
var get_chart_rotation_1 = require("../../../../state/selectors/get_chart_rotation");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_internal_is_intialized_1 = require("../../../../state/selectors/get_internal_is_intialized");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var light_theme_1 = require("../../../../utils/themes/light_theme");
var get_cursor_band_1 = require("../../state/selectors/get_cursor_band");
var get_cursor_line_1 = require("../../state/selectors/get_cursor_line");
var common_1 = require("../../state/utils/common");
function canRenderBand(type, visible, fromExternalEvent) {
    return visible && (type === constants_1.TooltipType.Crosshairs || type === constants_1.TooltipType.VerticalCursor || fromExternalEvent);
}
function canRenderHelpLine(type, visible) {
    return visible && type === constants_1.TooltipType.Crosshairs;
}
var CrosshairComponent = (function (_super) {
    __extends(CrosshairComponent, _super);
    function CrosshairComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CrosshairComponent.prototype.renderBand = function () {
        var _a = this.props, band = _a.theme.crosshair.band, cursorBandPosition = _a.cursorBandPosition, tooltipType = _a.tooltipType, fromExternalEvent = _a.fromExternalEvent;
        if (!cursorBandPosition || !canRenderBand(tooltipType, band.visible, fromExternalEvent)) {
            return null;
        }
        var style = __assign(__assign({}, cursorBandPosition), { background: band.fill });
        return react_1.default.createElement("div", { className: "echCrosshair__band", style: style });
    };
    CrosshairComponent.prototype.renderLine = function () {
        var _a = this.props, line = _a.theme.crosshair.line, cursorLinePosition = _a.cursorLinePosition, tooltipType = _a.tooltipType, chartRotation = _a.chartRotation;
        if (!cursorLinePosition || !canRenderHelpLine(tooltipType, line.visible)) {
            return null;
        }
        var isHorizontalRotated = common_1.isHorizontalRotation(chartRotation);
        var style;
        if (isHorizontalRotated) {
            style = __assign(__assign({}, cursorLinePosition), { borderTopWidth: line.strokeWidth, borderTopColor: line.stroke, borderTopStyle: line.dash ? 'dashed' : 'solid' });
        }
        else {
            style = __assign(__assign({}, cursorLinePosition), { borderLeftWidth: line.strokeWidth, borderLeftColor: line.stroke, borderLeftStyle: line.dash ? 'dashed' : 'solid' });
        }
        return react_1.default.createElement("div", { className: "echCrosshair__line", style: style });
    };
    CrosshairComponent.prototype.render = function () {
        return (react_1.default.createElement("div", { className: "echCrosshair" },
            this.renderBand(),
            this.renderLine()));
    };
    CrosshairComponent.displayName = 'Crosshair';
    return CrosshairComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    var _a, _b;
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return {
            theme: light_theme_1.LIGHT_THEME,
            chartRotation: 0,
            tooltipType: constants_1.TooltipType.None,
        };
    }
    var settings = get_settings_specs_1.getSettingsSpecSelector(state);
    var cursorBandPosition = get_cursor_band_1.getCursorBandPositionSelector(state);
    var tooltipType = specs_1.getTooltipType(settings, (_a = cursorBandPosition) === null || _a === void 0 ? void 0 : _a.fromExternalEvent);
    return {
        theme: get_chart_theme_1.getChartThemeSelector(state),
        chartRotation: get_chart_rotation_1.getChartRotationSelector(state),
        cursorBandPosition: cursorBandPosition,
        cursorLinePosition: get_cursor_line_1.getCursorLinePositionSelector(state),
        tooltipType: tooltipType,
        fromExternalEvent: (_b = cursorBandPosition) === null || _b === void 0 ? void 0 : _b.fromExternalEvent,
    };
};
exports.Crosshair = react_redux_1.connect(mapStateToProps)(CrosshairComponent);
//# sourceMappingURL=crosshair.js.map