/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

public final class RectangularSelectAction
extends WidgetAction.LockedAdapter {
    private RectangularSelectDecorator decorator;
    private LayerWidget interractionLayer;
    private RectangularSelectProvider provider;
    private Widget selectionWidget;
    private Rectangle selectionSceneRectangle;

    public RectangularSelectAction(RectangularSelectDecorator rectangularSelectDecorator, LayerWidget layerWidget, RectangularSelectProvider rectangularSelectProvider) {
        this.decorator = rectangularSelectDecorator;
        this.interractionLayer = layerWidget;
        this.provider = rectangularSelectProvider;
    }

    protected boolean isLocked() {
        return this.selectionSceneRectangle != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1) {
            this.selectionWidget = this.decorator.createSelectionWidget();
            assert (this.selectionWidget != null);
            this.interractionLayer.addChild(this.selectionWidget);
            this.selectionSceneRectangle = new Rectangle(widget.convertLocalToScene(widgetMouseEvent.getPoint()));
            this.move(widget, widgetMouseEvent.getPoint());
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.selectionSceneRectangle != null) {
            this.move(widget, widgetMouseEvent.getPoint());
            this.selectionWidget.getParentWidget().removeChild(this.selectionWidget);
            this.provider.performSelection(this.selectionSceneRectangle);
            this.selectionWidget = null;
            this.selectionSceneRectangle = null;
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.selectionSceneRectangle != null) {
            this.move(widget, widgetMouseEvent.getPoint());
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    private void resolveSelectionWidgetLocationBounds() {
        this.selectionWidget.setPreferredLocation(this.selectionSceneRectangle.getLocation());
        int n = this.selectionSceneRectangle.width;
        int n2 = this.selectionSceneRectangle.height;
        this.selectionWidget.setPreferredBounds(new Rectangle(n >= 0 ? 0 : n, n2 >= 0 ? 0 : n2, n >= 0 ? n : -n, n2 >= 0 ? n2 : -n2));
    }

    private void move(Widget widget, Point point) {
        Point point2 = widget.convertLocalToScene(point);
        this.selectionSceneRectangle.width = point2.x - this.selectionSceneRectangle.x;
        this.selectionSceneRectangle.height = point2.y - this.selectionSceneRectangle.y;
        this.resolveSelectionWidgetLocationBounds();
    }
}

