/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.PaletteUtilities;

public class PaletteLabelUI
extends BasicLabelUI {
    protected static PaletteLabelUI labelUI = new PaletteLabelUI();
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle viewR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return labelUI;
    }

    @Override
    protected void installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
        PaletteLookAndFeel.installBorder(jLabel, "Label.border");
        PaletteLookAndFeel.installColorsAndFont(jLabel, "Label.background", "Label.foreground", "Label.font");
        if (jLabel.getClass().getName().endsWith("LabelUIResource")) {
            jLabel.setFont(UIManager.getFont("Slider.labelFont"));
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = PaletteUtilities.beginGraphics(graphics2D);
        super.paint(graphics2D, jComponent);
        PaletteUtilities.endGraphics(graphics2D, object);
    }

    @Override
    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        Color color = UIManager.getColor("Label.disabledForeground");
        graphics.setColor(color != null ? color : jLabel.getForeground());
        int n3 = -1;
        PaletteUtilities.drawString(graphics, string, n3, n, n2);
    }

    @Override
    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        int n3 = jLabel.getDisplayedMnemonicIndex();
        String string2 = (String)jLabel.getClientProperty("Quaqua.Label.style");
        if (string2 != null) {
            if (string2.equals("emboss") && UIManager.getColor("Label.embossForeground") != null) {
                graphics.setColor(UIManager.getColor("Label.embossForeground"));
                PaletteUtilities.drawString(graphics, string, n3, n, n2 + 1);
            } else if (string2.equals("shadow") && UIManager.getColor("Label.shadowForeground") != null) {
                graphics.setColor(UIManager.getColor("Label.shadowForeground"));
                PaletteUtilities.drawString(graphics, string, n3, n, n2 + 1);
            }
        }
        graphics.setColor(jLabel.getForeground());
        PaletteUtilities.drawString(graphics, string, n3, n, n2);
    }

    @Override
    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (!string.equals("JComponent.sizeVariant")) {
            super.propertyChange(propertyChangeEvent);
        }
    }
}

