/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import org.traccar.config.ConfigKey;

public class Config {
    private final Properties properties = new Properties();
    private boolean useEnvironmentVariables;

    public Config() {
    }

    public Config(String file) throws IOException {
        try {
            Properties mainProperties = new Properties();
            try (FileInputStream inputStream = new FileInputStream(file);){
                mainProperties.loadFromXML(inputStream);
            }
            String defaultConfigFile = mainProperties.getProperty("config.default");
            if (defaultConfigFile != null) {
                try (FileInputStream inputStream = new FileInputStream(defaultConfigFile);){
                    this.properties.loadFromXML(inputStream);
                }
            }
            this.properties.putAll((Map<?, ?>)mainProperties);
            this.useEnvironmentVariables = Boolean.parseBoolean(System.getenv("CONFIG_USE_ENVIRONMENT_VARIABLES")) || Boolean.parseBoolean(this.properties.getProperty("config.useEnvironmentVariables"));
        }
        catch (InvalidPropertiesFormatException e) {
            throw new RuntimeException("Configuration file is not a valid XML document", e);
        }
    }

    public boolean hasKey(ConfigKey<?> key) {
        return this.hasKey(key.getKey());
    }

    @Deprecated
    public boolean hasKey(String key) {
        return this.useEnvironmentVariables && System.getenv().containsKey(Config.getEnvironmentVariableName(key)) || this.properties.containsKey(key);
    }

    public String getString(ConfigKey<String> key) {
        return this.getString(key.getKey(), key.getDefaultValue());
    }

    @Deprecated
    public String getString(String key) {
        String value;
        if (this.useEnvironmentVariables && (value = System.getenv(Config.getEnvironmentVariableName(key))) != null && !value.isEmpty()) {
            return value;
        }
        return this.properties.getProperty(key);
    }

    public String getString(ConfigKey<String> key, String defaultValue) {
        return this.getString(key.getKey(), defaultValue);
    }

    @Deprecated
    public String getString(String key, String defaultValue) {
        return this.hasKey(key) ? this.getString(key) : defaultValue;
    }

    public boolean getBoolean(ConfigKey<Boolean> key) {
        return this.getBoolean(key.getKey());
    }

    @Deprecated
    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public int getInteger(ConfigKey<Integer> key) {
        String value = this.getString(key.getKey());
        if (value != null) {
            return Integer.parseInt(value);
        }
        Integer defaultValue = key.getDefaultValue();
        if (defaultValue != null) {
            return defaultValue;
        }
        return 0;
    }

    public int getInteger(ConfigKey<Integer> key, int defaultValue) {
        return this.getInteger(key.getKey(), defaultValue);
    }

    @Deprecated
    public int getInteger(String key, int defaultValue) {
        return this.hasKey(key) ? Integer.parseInt(this.getString(key)) : defaultValue;
    }

    public long getLong(ConfigKey<Long> key) {
        String value = this.getString(key.getKey());
        if (value != null) {
            return Long.parseLong(value);
        }
        Long defaultValue = key.getDefaultValue();
        if (defaultValue != null) {
            return defaultValue;
        }
        return 0L;
    }

    public double getDouble(ConfigKey<Double> key) {
        String value = this.getString(key.getKey());
        if (value != null) {
            return Double.parseDouble(value);
        }
        Double defaultValue = key.getDefaultValue();
        if (defaultValue != null) {
            return defaultValue;
        }
        return 0.0;
    }

    @VisibleForTesting
    public void setString(ConfigKey<?> key, String value) {
        this.properties.put(key.getKey(), value);
    }

    static String getEnvironmentVariableName(String key) {
        return key.replaceAll("\\.", "_").replaceAll("(\\p{Lu})", "_$1").toUpperCase();
    }
}

