/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.StoreManager;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class PersistentValve
extends ValveBase {
    private static final ClassLoader MY_CLASSLOADER = PersistentValve.class.getClassLoader();
    private volatile boolean clBindRequired;
    protected Pattern filter = null;

    public PersistentValve() {
        super(true);
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        this.clBindRequired = container instanceof Engine || container instanceof Host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block27: {
            Store store;
            if (this.isRequestWithoutSession(request.getDecodedRequestURI())) {
                this.getNext().invoke(request, response);
                return;
            }
            Context context = request.getContext();
            if (context == null) {
                response.sendError(500, sm.getString("standardHost.noContext"));
                return;
            }
            String sessionId = request.getRequestedSessionId();
            Manager manager = context.getManager();
            if (sessionId != null && manager instanceof StoreManager && (store = ((StoreManager)((Object)manager)).getStore()) != null) {
                Session session = null;
                try {
                    session = store.load(sessionId);
                }
                catch (Exception e) {
                    this.container.getLogger().error((Object)"deserializeError");
                }
                if (session != null) {
                    if (!session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
                        if (this.container.getLogger().isDebugEnabled()) {
                            this.container.getLogger().debug((Object)"session swapped in is invalid or expired");
                        }
                        session.expire();
                        store.remove(sessionId);
                    } else {
                        session.setManager(manager);
                        manager.add(session);
                        session.access();
                        session.endAccess();
                    }
                }
            }
            if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().debug((Object)("sessionId: " + sessionId));
            }
            this.getNext().invoke(request, response);
            if (!request.isAsync()) {
                Session hsess;
                try {
                    hsess = request.getSessionInternal(false);
                }
                catch (Exception ex) {
                    hsess = null;
                }
                String newsessionId = null;
                if (hsess != null) {
                    newsessionId = hsess.getIdInternal();
                }
                if (this.container.getLogger().isDebugEnabled()) {
                    this.container.getLogger().debug((Object)("newsessionId: " + newsessionId));
                }
                if (newsessionId != null) {
                    try {
                        this.bind(context);
                        if (manager instanceof StoreManager) {
                            Session session = manager.findSession(newsessionId);
                            Store store2 = ((StoreManager)((Object)manager)).getStore();
                            boolean stored = false;
                            if (session != null) {
                                Session session2 = session;
                                synchronized (session2) {
                                    if (store2 != null && session.isValid() && !this.isSessionStale(session, System.currentTimeMillis())) {
                                        store2.save(session);
                                        ((StoreManager)((Object)manager)).removeSuper(session);
                                        session.recycle();
                                        stored = true;
                                    }
                                }
                            }
                            if (!stored && this.container.getLogger().isDebugEnabled()) {
                                this.container.getLogger().debug((Object)("newsessionId store: " + store2 + " session: " + session + " valid: " + (session == null ? "N/A" : Boolean.toString(session.isValid())) + " stale: " + this.isSessionStale(session, System.currentTimeMillis())));
                            }
                            break block27;
                        }
                        if (this.container.getLogger().isDebugEnabled()) {
                            this.container.getLogger().debug((Object)("newsessionId Manager: " + manager));
                        }
                    }
                    finally {
                        this.unbind(context);
                    }
                }
            }
        }
    }

    protected boolean isSessionStale(Session session, long timeNow) {
        int timeIdle;
        int maxInactiveInterval;
        return session != null && (maxInactiveInterval = session.getMaxInactiveInterval()) >= 0 && (timeIdle = (int)(session.getIdleTimeInternal() / 1000L)) >= maxInactiveInterval;
    }

    private void bind(Context context) {
        if (this.clBindRequired) {
            context.bind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    private void unbind(Context context) {
        if (this.clBindRequired) {
            context.unbind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    protected boolean isRequestWithoutSession(String uri) {
        Pattern f = this.filter;
        return f != null && f.matcher(uri).matches();
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.toString();
    }

    public void setFilter(String filter) {
        if (filter == null || filter.length() == 0) {
            this.filter = null;
        } else {
            try {
                this.filter = Pattern.compile(filter);
            }
            catch (PatternSyntaxException pse) {
                this.container.getLogger().error((Object)sm.getString("persistentValve.filter.failure", new Object[]{filter}), (Throwable)pse);
            }
        }
    }
}

