"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var compute_chart_dimensions_1 = require("./compute_chart_dimensions");
var getCurrentPointerPosition = function (state) { return state.interactions.pointer.current.position; };
exports.getProjectedPointerPositionSelector = re_reselect_1.default([getCurrentPointerPosition, compute_chart_dimensions_1.computeChartDimensionsSelector], function (currentPointerPosition, chartDimensions) {
    return getProjectedPointerPosition(currentPointerPosition, chartDimensions.chartDimensions);
})(get_chart_id_1.getChartIdSelector);
function getProjectedPointerPosition(chartAreaPointerPosition, chartAreaDimensions) {
    var x = chartAreaPointerPosition.x, y = chartAreaPointerPosition.y;
    var xPos = x - chartAreaDimensions.left;
    var yPos = y - chartAreaDimensions.top;
    if (xPos < 0 || xPos >= chartAreaDimensions.width) {
        xPos = -1;
    }
    if (yPos < 0 || yPos >= chartAreaDimensions.height) {
        yPos = -1;
    }
    return {
        x: xPos,
        y: yPos,
    };
}
//# sourceMappingURL=get_projected_pointer_position.js.map