/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.datatransfer.RelationMemberTransferable;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MemberTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        MemberTable source = (MemberTable)c;
        return new RelationMemberTransferable(source.getMemberTableModel().getSelectedMembers());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.isDrop()) {
            support.setShowDropLocation(true);
        }
        return support.isDataFlavorSupported(RelationMemberTransferable.RELATION_MEMBER_DATA) || support.isDataFlavorSupported(PrimitiveTransferData.DATA_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        MemberTable destination = (MemberTable)support.getComponent();
        int insertRow = MemberTransferHandler.computeInsertionRow(support, destination);
        return this.importDataAt(support, destination, insertRow);
    }

    private static int computeInsertionRow(TransferHandler.TransferSupport support, MemberTable destination) {
        int selection;
        TransferHandler.DropLocation dl;
        int insertRow = support.isDrop() ? ((dl = support.getDropLocation()) instanceof JTable.DropLocation ? ((JTable.DropLocation)dl).getRow() : 0) : ((selection = destination.getSelectedRow()) < 0 ? destination.getRowCount() : selection);
        return insertRow;
    }

    private boolean importDataAt(TransferHandler.TransferSupport support, MemberTable destination, int insertRow) {
        try {
            if (support.isDataFlavorSupported(RelationMemberTransferable.RELATION_MEMBER_DATA)) {
                this.importRelationMemberData(support, destination, insertRow);
                return true;
            }
            if (support.isDataFlavorSupported(PrimitiveTransferData.DATA_FLAVOR)) {
                this.importPrimitiveData(support, destination, insertRow);
                return true;
            }
            return false;
        }
        catch (UnsupportedFlavorException | IOException e) {
            Logging.warn(e);
            return false;
        }
    }

    protected void importRelationMemberData(TransferHandler.TransferSupport support, MemberTable destination, int insertRow) throws UnsupportedFlavorException, IOException {
        RelationMemberTransferable.Data memberData = (RelationMemberTransferable.Data)support.getTransferable().getTransferData(RelationMemberTransferable.RELATION_MEMBER_DATA);
        this.importData(destination, insertRow, memberData.getRelationMemberData(), new AbstractRelationMemberConverter<RelationMemberData>(){

            @Override
            protected RelationMember getMember(MemberTable destination, RelationMemberData data, OsmPrimitive p) {
                return new RelationMember(data.getRole(), p);
            }
        });
    }

    protected void importPrimitiveData(TransferHandler.TransferSupport support, MemberTable destination, int insertRow) throws UnsupportedFlavorException, IOException {
        PrimitiveTransferData data = (PrimitiveTransferData)support.getTransferable().getTransferData(PrimitiveTransferData.DATA_FLAVOR);
        this.importData(destination, insertRow, data.getDirectlyAdded(), new AbstractRelationMemberConverter<PrimitiveData>(){

            @Override
            protected RelationMember getMember(MemberTable destination, PrimitiveData data, OsmPrimitive p) {
                return destination.getMemberTableModel().getRelationMemberForPrimitive(p);
            }
        });
    }

    protected <T extends PrimitiveId> void importData(MemberTable destination, int insertRow, Collection<T> memberData, AbstractRelationMemberConverter<T> toMemberFunction) {
        ArrayList<RelationMember> membersToAdd = new ArrayList<RelationMember>(memberData.size());
        for (PrimitiveId data : memberData) {
            RelationMember member = toMemberFunction.importPrimitive(destination, data);
            if (member == null) continue;
            membersToAdd.add(member);
        }
        destination.getMemberTableModel().addMembersAtIndexKeepingOldSelection(membersToAdd, insertRow);
    }

    @Override
    protected void exportDone(JComponent sourceComponent, Transferable data, int action) {
        if (action != 2) {
            return;
        }
        MemberTable source = (MemberTable)sourceComponent;
        MemberTableModel model = source.getMemberTableModel();
        model.remove(source.getSelectedRows());
        model.selectionChanged(null);
    }

    private static abstract class AbstractRelationMemberConverter<T extends PrimitiveId> {
        private AbstractRelationMemberConverter() {
        }

        protected RelationMember importPrimitive(MemberTable destination, T data) {
            OsmPrimitive p = destination.getLayer().data.getPrimitiveById((PrimitiveId)data);
            if (p == null) {
                Logging.warn(I18n.tr("Cannot add {0} since it is not part of dataset", data));
                return null;
            }
            return this.getMember(destination, data, p);
        }

        protected abstract RelationMember getMember(MemberTable var1, T var2, OsmPrimitive var3);
    }
}

