/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class FilterWorker {
    private FilterWorker() {
    }

    public static boolean executeFilters(Collection<OsmPrimitive> all, Filter ... filters) throws SearchParseError {
        return FilterWorker.executeFilters(all, FilterMatcher.of(filters));
    }

    public static boolean executeFilters(Collection<OsmPrimitive> all, FilterMatcher filterMatcher) {
        boolean changed = FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(all, Relation.class::isInstance), filterMatcher);
        changed |= FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(all, Way.class::isInstance), filterMatcher);
        return changed |= FilterWorker.doExecuteFilters(SubclassFilteredCollection.filter(all, Node.class::isInstance), filterMatcher);
    }

    private static boolean doExecuteFilters(Collection<OsmPrimitive> all, FilterMatcher filterMatcher) {
        boolean changed = false;
        for (OsmPrimitive primitive : all) {
            FilterMatcher.FilterType hiddenType = filterMatcher.isHidden(primitive);
            if (hiddenType != FilterMatcher.FilterType.NOT_FILTERED) {
                changed |= primitive.setDisabledState(true);
                primitive.setHiddenType(hiddenType == FilterMatcher.FilterType.EXPLICIT);
                continue;
            }
            FilterMatcher.FilterType disabledType = filterMatcher.isDisabled(primitive);
            if (disabledType != FilterMatcher.FilterType.NOT_FILTERED) {
                changed |= primitive.setDisabledState(false);
                primitive.setDisabledType(disabledType == FilterMatcher.FilterType.EXPLICIT);
                continue;
            }
            changed |= primitive.unsetDisabledState();
        }
        return changed;
    }

    public static boolean executeFilters(OsmPrimitive primitive, FilterMatcher filterMatcher) {
        return FilterWorker.doExecuteFilters(Collections.singleton(primitive), filterMatcher);
    }

    public static boolean clearFilterFlags(Collection<OsmPrimitive> prims) {
        boolean changed = false;
        for (OsmPrimitive osm : prims) {
            changed |= osm.unsetDisabledState();
        }
        return changed;
    }
}

