/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.auth;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Arrays;
import org.rzo.netty.ahessian.auth.AuthToken;

public class SimpleAuthToken
implements AuthToken {
    byte[] _password;
    byte[] _receivedBytes;
    int _receivedLength = 0;
    boolean _loggedOn = false;
    int _length = -1;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SimpleAuthToken.class);

    public void setPassword(String password) {
        this._password = this.ensureLength(password.getBytes());
        this._receivedBytes = new byte[this._password.length];
    }

    public void setLength(int length) {
        this._length = length;
    }

    @Override
    public int authenticate(ChannelHandlerContext ctx, ByteBuf e) {
        ByteBuf b = e;
        int toCopy = Math.min(this._receivedBytes.length - this._receivedLength, b.readableBytes());
        byte[] bytes = new byte[toCopy];
        b.readBytes(bytes);
        System.arraycopy(bytes, 0, this._receivedBytes, this._receivedLength, bytes.length);
        this._receivedLength += toCopy;
        if (this._receivedLength == this._password.length) {
            if (Arrays.equals(this._receivedBytes, this._password)) {
                logger.info("authenticated");
                if (b.readableBytes() != 0) {
                    ctx.fireChannelRead((Object)e);
                }
                return 1;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public void sendPassword(ChannelHandlerContext ctx) {
        ctx.write((Object)Unpooled.wrappedBuffer((byte[])this._password));
    }

    @Override
    public boolean isLoggedOn() {
        return this._loggedOn;
    }

    void setLoggedOn(boolean loggedOn) {
        this._loggedOn = loggedOn;
    }

    @Override
    public void disconnected() {
        this.setLoggedOn(false);
    }

    byte[] ensureLength(byte[] bytes) {
        if (bytes.length == this._length || this._length <= 0) {
            return bytes;
        }
        return Arrays.copyOf(bytes, this._length);
    }

    byte[] getPassword() {
        return this._password;
    }
}

