/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.program.database.data.InstanceSettingsDB;
import ghidra.program.model.address.Address;
import ghidra.util.datastruct.FixedSizeHashMap;
import java.util.LinkedHashMap;

class SettingsCache {
    private static final int CACHE_SIZE = 200;
    private LinkedHashMap<AddressNamePair, InstanceSettingsDB> map = new FixedSizeHashMap(200, 200);

    SettingsCache() {
    }

    public void remove(Address address, String name) {
        AddressNamePair key = new AddressNamePair(address, name);
        this.map.remove(key);
    }

    void clear() {
        this.map.clear();
    }

    InstanceSettingsDB getInstanceSettings(Address address, String name) {
        AddressNamePair key = new AddressNamePair(address, name);
        return this.map.get(key);
    }

    void put(Address address, String name, InstanceSettingsDB settings) {
        AddressNamePair key = new AddressNamePair(address, name);
        this.map.put(key, settings);
    }

    class AddressNamePair {
        Address address;
        String name;

        AddressNamePair(Address address, String name) {
            this.address = address;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddressNamePair)) {
                return false;
            }
            AddressNamePair other = (AddressNamePair)obj;
            return other.address.equals(this.address) && other.name.equals(this.name);
        }

        public int hashCode() {
            return this.address.hashCode() + this.name.hashCode();
        }
    }
}

