/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.LongIterator;
import ghidra.util.datastruct.NoSuchIndexException;
import ghidra.util.prop.PropertySet;
import java.util.NoSuchElementException;

class LongIteratorImpl
implements LongIterator {
    private PropertySet pm;
    private long start;
    private long end;
    private long current;
    private boolean hasBoundaries;
    private boolean doesHaveNext;
    private boolean doesHavePrevious;

    LongIteratorImpl(PropertySet pm) {
        this(pm, 0L, true);
    }

    LongIteratorImpl(PropertySet pm, long start, boolean before) {
        this.pm = pm;
        this.start = before ? start : start + 1L;
        this.current = start;
        this.init(true);
    }

    LongIteratorImpl(PropertySet pm, long start, long end) {
        this(pm, start, end, true);
    }

    LongIteratorImpl(PropertySet pm, long start, long end, boolean atStart) {
        this.pm = pm;
        this.start = start;
        this.end = end;
        this.hasBoundaries = true;
        this.current = atStart ? start : end;
        this.init(atStart);
    }

    @Override
    public boolean hasNext() {
        if (this.doesHaveNext) {
            return true;
        }
        this.findNext();
        return this.doesHaveNext;
    }

    @Override
    public long next() {
        if (this.hasNext()) {
            this.doesHaveNext = false;
            this.doesHavePrevious = true;
            return this.current;
        }
        throw new NoSuchElementException("No more indexes.");
    }

    @Override
    public boolean hasPrevious() {
        if (this.doesHavePrevious) {
            return true;
        }
        this.findPrevious();
        return this.doesHavePrevious;
    }

    @Override
    public long previous() {
        if (this.hasPrevious()) {
            this.doesHavePrevious = false;
            this.doesHaveNext = true;
            return this.current;
        }
        throw new NoSuchElementException("No more indexes.");
    }

    private void findNext() {
        try {
            long nextIndex = this.pm.getNextPropertyIndex(this.current);
            if (this.hasBoundaries && nextIndex > this.end) {
                this.doesHaveNext = false;
                return;
            }
            this.current = nextIndex;
            this.doesHaveNext = true;
            this.doesHavePrevious = false;
        }
        catch (NoSuchIndexException e) {
            return;
        }
    }

    private void findPrevious() {
        try {
            long prevIndex = this.pm.getPreviousPropertyIndex(this.current);
            if (this.hasBoundaries && prevIndex < this.start) {
                this.doesHavePrevious = false;
                return;
            }
            this.current = prevIndex;
            this.doesHavePrevious = true;
            this.doesHaveNext = false;
        }
        catch (NoSuchIndexException e) {
            return;
        }
    }

    private void init(boolean atStart) {
        if (this.pm.hasProperty(this.current)) {
            if (atStart) {
                this.doesHaveNext = true;
            } else {
                this.doesHavePrevious = true;
            }
        }
    }
}

