/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToOverrideService;
import ghidra.app.services.GoToService;
import ghidra.app.services.GoToServiceListener;
import ghidra.app.services.QueryData;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.task.TaskMonitor;

class DualListingGoToService
implements GoToService {
    private ListingCodeComparisonPanel dualListing;
    private boolean isLeftSide;
    private GoToOverrideService overrideService;
    private GoToService goToService;

    DualListingGoToService(GoToService goToService, ListingCodeComparisonPanel dualListing, boolean isLeftSide) {
        this.goToService = goToService;
        this.dualListing = dualListing;
        this.isLeftSide = isLeftSide;
    }

    @Override
    public GoToOverrideService getOverrideService() {
        return this.overrideService;
    }

    @Override
    public boolean goTo(ProgramLocation loc) {
        return this.dualGoTo(loc);
    }

    @Override
    public boolean goTo(Navigatable navigatable, Program program, Address address, Address refAddress) {
        return this.dualGoTo(new ProgramLocation(program, address));
    }

    @Override
    public boolean goTo(ProgramLocation loc, Program program) {
        return this.dualGoTo(loc);
    }

    @Override
    public boolean goTo(Navigatable navigatable, ProgramLocation loc, Program program) {
        return this.dualGoTo(loc);
    }

    @Override
    public boolean goTo(Navigatable navigatable, Address goToAddress) {
        return this.dualGoTo(goToAddress);
    }

    private boolean validateAddress(Address addr) {
        AddressSetView addresses;
        if (addr == null) {
            return false;
        }
        AddressSetView addressSetView = addresses = this.isLeftSide ? this.dualListing.getLeftAddresses() : this.dualListing.getRightAddresses();
        if (!addresses.contains(addr)) {
            this.dualListing.setStatusInfo("\"" + addr.toString() + "\" is outside the current listing's view.");
            return false;
        }
        return true;
    }

    private boolean dualGoTo(ProgramLocation loc) {
        if (loc == null) {
            return false;
        }
        if (!this.validateAddress(loc.getAddress())) {
            return false;
        }
        ListingPanel listingPanel = this.isLeftSide ? this.dualListing.getLeftPanel() : this.dualListing.getRightPanel();
        return listingPanel.goTo(loc);
    }

    private boolean dualGoTo(Address addr) {
        if (!this.validateAddress(addr)) {
            return false;
        }
        ListingPanel listingPanel = this.isLeftSide ? this.dualListing.getLeftPanel() : this.dualListing.getRightPanel();
        return listingPanel.goTo(addr);
    }

    @Override
    public boolean goTo(Address currentAddress, Address goToAddress) {
        return this.dualGoTo(goToAddress);
    }

    @Override
    public boolean goTo(Address goToAddress) {
        return this.dualGoTo(goToAddress);
    }

    @Override
    public boolean goTo(Address goToAddress, Program program) {
        return this.dualGoTo(goToAddress);
    }

    @Override
    public boolean goToExternalLocation(ExternalLocation extLoc, boolean checkNavigationOption) {
        throw new UnsupportedOperationException("Connot Go To an external address from a dual listing view.");
    }

    @Override
    public boolean goToExternalLocation(Navigatable navigatable, ExternalLocation extLoc, boolean checkNavigationOption) {
        throw new UnsupportedOperationException("Connot Go To an external address from a dual listing view.");
    }

    @Override
    public boolean goToQuery(Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
        throw new UnsupportedOperationException("Go To Address or Label is not allowed in a dual listing view.");
    }

    @Override
    public boolean goToQuery(Navigatable navigatable, Address fromAddr, QueryData queryData, GoToServiceListener listener, TaskMonitor monitor) {
        throw new UnsupportedOperationException("Go To Address or Label is not allowed in a dual listing view.");
    }

    @Override
    public void setOverrideService(GoToOverrideService override) {
        this.overrideService = override;
    }

    @Override
    public Navigatable getDefaultNavigatable() {
        return this.goToService.getDefaultNavigatable();
    }
}

