/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

public enum AnalyzerType {
    BYTE_ANALYZER("Byte Analyzer", "Triggered when bytes are added (memory block added)."),
    INSTRUCTION_ANALYZER("Instructions Analyzer", "Triggered when instructions are created."),
    FUNCTION_ANALYZER("Function Analyzer", "Triggered when functions are created."),
    FUNCTION_MODIFIERS_ANALYZER("Function-modifiers Analyzer", "Triggered when a function's modifier changes"),
    FUNCTION_SIGNATURES_ANALYZER("Function-Signatures Analyzer", "Triggered when a function's signature changes."),
    DATA_ANALYZER("Data Analyzer", "Triggered when data is created."),
    ONE_SHOT_ANALYZER("One Shot Analzyer", "Not triggered by any event, only executed when analysis is run manually (One shots run before all others)");

    private String name;
    private String description;

    private AnalyzerType(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }
}

