/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.app.cmd.memory.MoveBlockListener;
import ghidra.app.cmd.memory.MoveBlockTask;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;

class MoveBlockModel
implements DomainObjectListener {
    private Program program;
    private MemoryBlock block;
    private Address blockStart;
    private Address newStartAddr;
    private Address newEndAddr;
    private MoveBlockListener listener;
    private String message;

    MoveBlockModel(Program program) {
        this.program = program;
        this.message = "";
        program.addListener((DomainObjectListener)this);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(4)) {
            this.block = this.program.getMemory().getBlock(this.blockStart);
        }
    }

    void initialize(MemoryBlock blockToInitialize) {
        this.block = blockToInitialize;
        this.blockStart = this.newStartAddr = blockToInitialize.getStart();
        this.newEndAddr = blockToInitialize.getEnd();
        this.listener.stateChanged();
    }

    void setMoveBlockListener(MoveBlockListener listener) {
        this.listener = listener;
    }

    String getName() {
        return this.block.getName();
    }

    Address getStartAddress() {
        return this.block.getStart();
    }

    Address getEndAddress() {
        return this.block.getEnd();
    }

    String getLengthString() {
        long length = this.block.getSize();
        return length + "  (0x" + Long.toHexString(length) + ")";
    }

    Address getNewStartAddress() {
        return this.newStartAddr;
    }

    Address getNewEndAddress() {
        return this.newEndAddr;
    }

    String getMessage() {
        return this.message;
    }

    void setNewStartAddress(Address newStart) {
        this.message = "";
        this.newStartAddr = newStart;
        this.newEndAddr = this.getEndAddress(newStart);
        if (newStart.equals((Object)this.block.getStart())) {
            this.message = "Block is already at " + newStart;
        } else if (this.newEndAddr == null) {
            this.message = "Start Address is too big";
        }
        this.listener.stateChanged();
    }

    void setNewEndAddress(Address newEnd) {
        this.message = "";
        this.newEndAddr = newEnd;
        this.newStartAddr = this.getStartAddress(newEnd);
        if (this.newStartAddr == null) {
            this.message = "End Address is too small";
        }
        this.listener.stateChanged();
    }

    MoveBlockTask makeTask() {
        return new MoveBlockTask(this.program, this.block.getStart(), this.newStartAddr, this.listener);
    }

    void dispose() {
        this.program.removeListener((DomainObjectListener)this);
        this.program = null;
    }

    AddressFactory getAddressFactory() {
        return this.program.getAddressFactory();
    }

    private Address getEndAddress(Address start) {
        try {
            return start.addNoWrap(this.block.getSize() - 1L);
        }
        catch (AddressOverflowException addressOverflowException) {
            return null;
        }
    }

    private Address getStartAddress(Address end) {
        try {
            return end.subtractNoWrap(this.block.getSize() - 1L);
        }
        catch (AddressOverflowException addressOverflowException) {
            return null;
        }
    }
}

