/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveUtils;
import ghidra.app.plugin.core.datamgr.editor.DataTypeEditorManager;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.InvalidArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

public class CloseArchiveAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public CloseArchiveAction(DataTypeManagerPlugin plugin) {
        super("Close Archive", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Close Archive"}, null, "File"));
        this.setDescription("Closes a data type archive and removes it from the tool (does not affect program file associations).");
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths.length == 0) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (node instanceof FileArchiveNode || node instanceof InvalidArchiveNode || node instanceof ProjectArchiveNode) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionContext context) {
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        DataTypeEditorManager editorManager = this.plugin.getEditorManager();
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (TreePath path : selectionPaths) {
            Object pathComponent = path.getLastPathComponent();
            if (pathComponent instanceof InvalidArchiveNode) {
                InvalidArchiveNode invalidArchiveNode = (InvalidArchiveNode)pathComponent;
                Archive archive = invalidArchiveNode.getArchive();
                archive.close();
                continue;
            }
            Archive archive = null;
            Object node = path.getLastPathComponent();
            if (node instanceof ArchiveNode) {
                ArchiveNode archiveNode = (ArchiveNode)node;
                archive = archiveNode.getArchive();
            }
            if (archive == null) continue;
            archives.add(archive);
            if (editorManager.checkEditors(archive.getDataTypeManager(), true)) continue;
            return;
        }
        if (ArchiveUtils.canClose(archives, (Component)gtree)) {
            for (Archive archive : archives) {
                editorManager.dismissEditors(archive.getDataTypeManager());
                archive.close();
            }
        }
    }
}

