/*
 * Decompiled with CFR 0.152.
 */
package ghidra.closedpatternmining;

import ghidra.closedpatternmining.SequenceItem;
import java.util.Collection;

public class FrequentSequenceItem
implements Comparable<FrequentSequenceItem> {
    private int support;
    private SequenceItem frequentItem;

    public FrequentSequenceItem(int support, SequenceItem frequentItem) {
        if (support <= 0) {
            throw new IllegalArgumentException("support must be positive");
        }
        this.support = support;
        this.frequentItem = frequentItem;
    }

    public int getSupport() {
        return this.support;
    }

    public SequenceItem getItem() {
        return this.frequentItem;
    }

    public int hashCode() {
        return 23 * this.support + this.frequentItem.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrequentSequenceItem other = (FrequentSequenceItem)obj;
        if (!other.getItem().equals(this.frequentItem)) {
            return false;
        }
        return other.getSupport() == this.support;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("support (number of sequences containing the item): ");
        sb.append(Integer.toString(this.support));
        sb.append(", ");
        sb.append(this.frequentItem.toString());
        sb.append("\n");
        return sb.toString();
    }

    public static String getPrettyString(Collection<FrequentSequenceItem> items) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        if (items.size() == 0) {
            sb.append("empty!");
        } else {
            for (FrequentSequenceItem fItem : items) {
                sb.append(fItem.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(FrequentSequenceItem arg0) {
        int itemCompare = this.getItem().compareTo(arg0.getItem());
        if (itemCompare == 0) {
            return this.support - arg0.getSupport();
        }
        return itemCompare;
    }
}

