##
## Tcl Resources for XSchem
##

##
## Toolbar buttons
##
## Original artwork derived from http://www.entypo.com/
## Colours inverted, and then converted from SVG to base64-encoded GIF
## Author: Neil Johnson
## Released under the license CC BY-SA 4.0.
## https://creativecommons.org/licenses/by-sa/4.0/
##
##

## FILE

image create photo imgFileNew -data "
R0lGODlhGAAYAPUgAAAAAAQEBAgICAkJCQsLCxISEhsbG0BAQEFBQV5eXl9fX2BgYGFhYWlpaWpq
amtra3h4eJOTk5aWlp6enp+fn7+/v8HBwcTExMXFxdvb2+Pj4+Tk5O/v7/n5+fr6+v39/f///wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAbSQJDw
4+kYj0ik5yNsgi4KxGFKrU4RCoxTOBEAvuBwWDDZgiQAQsLRaLvbjgQBIDGjDRuzc2Og2wF4IBwa
G4UbGhwgfH5bd3kQBQaSBgUQin11jYB5DWIADZeMTo4gFhESqBIRFqGZo5t6TYuuTaQZFRa5FhUZ
rX+BDwABwwEAD76awMLExsivgbe6u72zv3mxzrWwpqmqrNXJnJ6g4M+PkZOV2UKkg4aHieXagdjy
7Glrb29xc7RCFAM8CQQwgIIZDAukWFmIgIGWLUSSSDyypEkQADs=
"

image create photo imgFileNewSym -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgQEBAUFBQYGBgkJCQoKCgwMDA0NDQ4ODhkZGSMjIysrKzEx
MTIyMjo6Oj4+Pj8/P0BAQEFBQUhISElJSUpKSktLS01NTU5OTk9PT1FRUVNTU1VVVVZWVldXV1hY
WFlZWWNjY2RkZGZmZmdnZ2hoaGlpaWtra3BwcHFxcXJycnV1dYGBgYODg4aGhoiIiI2NjZSUlJqa
mpubm5ycnJ6enqCgoKGhoaioqK2trbW1tba2tre3t7q6uru7u729vb6+vr+/v8DAwMHBwcPDw8TE
xMvLy8zMzM3NzdbW1tzc3OXl5ebm5uzs7PDw8PPz8/T09PX19fb29vf39/j4+Pn5+fr6+vv7+/z8
/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gF2Cg4SFg1tYWVuGjIZWRSQlPlpdXE04KicomygkLT1Vg1NEGwkI
HD5bWjQOAQCvrwgVPKFdU0MfBq8KJllYGgALEhHEECM/i11WRCICsAkkWFcUACZdWNiJyVhGIa6v
BRtFW1cTACiNWkccBbABHkRYXeXnjFZHGgiwAiJDtfToClExwkEBLAMehEwZBLBQFCAgDjzLMGQh
Q3MBBVVBsgLBNwQYhlgp1HCQkhsvMBgkkIEIpS5V/mEktEPHlCUXEHQYIk8Qjx6CSnJ5EmNGFygu
WACptQVIhRZBZ3bZEgTDhBk6biSJMijLiAHW5knVIkMChhg7lEghhCVCPbFZb7XYkCHkCRdDbd+W
7KJFy5a7eN0G3NtoUN7BUgsbFhzUAoAGKThJnozCxAIAKgRlgcEAlufPngU8yCGICxMYFiaoXs2a
NYUNNZwM4pLliu3buHNfwaIFcCAAOw==
"

image create photo imgFileOpen -data "
R0lGODlhGAAYAPYAAAAAAAEBAQMDAwQEBAUFBQcHBwgICAkJCQsLCw0NDRISEhMTExcXFxkZGRwc
HB0dHR4eHiEhISYmJisrKywsLDAwMDExMTIyMjY2Njc3Nzk5OUREREVFRUZGRk5OTlRUVFlZWVpa
Wl1dXV5eXmBgYGhoaGlpaW1tbW5ubm9vb3BwcHl5eXp6en19fYGBgYKCgouLi5OTk5SUlJWVlZ2d
naenp6ioqKmpqbW1tbq6ury8vL29vcDAwMHBwcLCwsTExMbGxsfHx8nJydDQ0NHR0dLS0tnZ2dra
2uDg4Ojo6Ovr6+zs7PDw8Pf39/j4+Pn5+fz8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAfQgFOCg4SFhoeIiYU8LSUmJicwQoqFUisIAJkADSM4S1GUUkwimpoH
GjE5PT49ra0/R05TUkgfpZoBAgO7vLsIJEZSUUQeAATHyAS9ywEZNVBTTUZAQdXW19hBQEVKUiwp
Jyri4+Tl4ygqLAoEt+3umQQLDwXv9ZoGEBYJ9vYJFxwK+NVT0AEEA4HvGIQ44QChOwcoXERw2C7C
CxkSKN6SMMPGBI2lKNzQUQGkJgs7hmAwmQkDkSQbWALYkOQJjROOHuncydNEiRM0nlAaSnRoIAA7
"

image create photo imgFileSave -data "
R0lGODlhGAAYAPU6AAAAAAEBAQICAgMDAwQEBAUFBQcHBzExMT4+Pj8/P0FBQUNDQ0REREVFRUdH
R0hISElJSV9fX2BgYGFhYWJiYmVlZWdnZ2hoaGlpaW1tbW5ubm9vb3BwcHNzc3R0dJOTk6Ghoaam
pqqqqq2trbGxsbKysrOzs7a2trq6usHBwcLCwsPDw8TExMbGxsfHx8rKytXV1ebm5urq6uzs7O3t
7e7u7vX19fr6+vz8/P7+/v///wAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAbDQJ1w
SCwaj8hkcUbyYC6UiHQqnWxAMiNpQQAIHlGppGKxOAyHUK3oEQAAhRQxB2PFVoVAYmQjYt5wckM3
CgAdLgVvECh+gHFENwgAHIhvAR2Nb4+DkpSJbxiZgZCdlaCiBSY5QzgfFiInnwChQ39vAxomKykp
Ki0vJxkDgLRCtrcFycrJw8SigNDRzrXS1dHFOsfW1dja29fP39Dd4tzh5bNEbeiAAh5EJAxd6AQN
JUQzJU4Y/P3+/R5K0FBCsKBBIkEAADs=
"

image create photo imgFileMerge -data "
R0lGODlhGAAYAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgwMDA0NDQ8PDxER
ERISEhMTExQUFBUVFRgYGBsbGxwcHB0dHSEhISIiIiMjIyQkJCUlJSYmJikpKSoqKiwsLC0tLS4u
Li8vLzAwMDMzMzQ0NDg4ODk5OTo6Ojs7Oz09PUFBQUJCQkNDQ0REREVFRUdHR0lJSU5OTk9PT1BQ
UFFRUVJSUlNTU1RUVFtbW2BgYGFhYWVlZWhoaGpqanFxcXJycnZ2dnt7e3x8fISEhIaGhomJiYqK
ioyMjI+Pj5CQkJGRkZWVlZaWlpqamp6enp+fn6CgoKKioqWlpaampqioqK6urq+vr7CwsLGxsbKy
srS0tLe3t7i4uLy8vL+/v8DAwMTExMXFxcbGxsjIyMrKysvLy83Nzc7Ozs/Pz9HR0dLS0tTU1NXV
1dbW1tfX19jY2Nzc3N7e3uHh4eLi4ubm5ufn5+jo6Onp6erq6uzs7O7u7vDw8PHx8fLy8vPz8/T0
9PX19fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgA
AAj+ABcJHEiwIEFFBhMqFMhn0MKHAhEl6YII4kJALWh8qThmDJkzb+5ULJgoD5swXKh0EICDTKEI
ECqAkHFkjZ9EAhUJgqOEBYQCBAIASDDjjAABAwogeBCiSR2Bgba4cGBAQAChAABMsBFBwoIBWQeE
yLKojxUTCLIq8HCiAQABJ6xMmSJlCQ8MBnSoGaRFhQEAEmw00cIlBIAUVfwMNARnyQ4xhcDIsFrB
xxichlaUkOKw4CE6hN70OPrgh5uBh4BEEaRQ0Z4gDwAwyAHnoBw9CwkZ4QDgAIo0hmzjTvinSQiw
IbQIwqNY4KEfUAIVLMSGiIgDADoo6ZNniJDLizKOk+C86In5JDsogNVApE4fJRYg3GByBcsHACgS
HzgQNOyFInMscscNDGSVwAYgLABAACZYMcAABCj1gAhO2CHQIFzA8MABVmGlVQ0ZZKDBCDUg0cYf
OC2iyCBxMBHDBEAJRdQZZZRhBhpw4DHSQXq4MYYXWXzAkksWGWTICxrtWORAElG0ZEINPZkQQgMF
BAA7
"

image create photo imgFileReload -data "
R0lGODlhGAAYAPZLAAAAAAEBAQICAgQEBAUFBQcHBwgICAsLCw0NDQ4ODg8PDxMTExQUFBoaGhsb
GxwcHB8fHyAgICEhIScnJysrKywsLDg4OD4+Pj8/P0BAQEFBQUJCQkZGRk9PT1VVVVZWVmFhYWdn
Z2hoaGlpaWtra2xsbHNzc4yMjJaWlpqamqSkpKWlpaqqqq2trbOzs7a2tri4uL6+vsHBwcPDw8TE
xMXFxcbGxsfHx8jIyMzMzM7OztPT09XV1dvb297e3uTk5OXl5evr6+3t7e/v7/Hx8fLy8vb29vf3
9/n5+fv7+/39/f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAfOgEuCg4SFhoeIiYqLjIREOkiNiDsgN0aKR0FAP5ydQS0JHDGXSJuc
QEFHLx4RDQ6vrw8MAQYWLEs4EK4NEh8wGAsAwsPEAAQYLjUExAsZBQLF0QohPDTLwwIFwxQkI94j
JR0EDiQ5Sz0lIiQU0SOGNhMmPoYj7YY+J0KH9cXuhUlFlOyzJ2kJP2L+JB0cdiEFiocQI0ZMcWHY
gADRMmYMQIACAo0ghyGooELDgQEEUqpcyZLAgAMbVgzZMUOGzZs4c96csWNIwZ9AgwpdFAgAOw==
"

## EDIT

image create photo imgEditUndo -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgMDAwUFBQcHBw0NDQ4ODg8PDxAQEBERERMTExQUFBUVFRcX
FxgYGBkZGRsbGxwcHB0dHR4eHiAgICIiIioqKiwsLENDQ0REREtLS1NTU1RUVFxcXGFhYWdnZ2ho
aGlpaWpqamxsbHJycnR0dHV1dXd3d3h4eHx8fICAgISEhIWFhYaGhoqKipCQkJGRkZSUlJWVlZqa
mpubm52dnZ6enqWlpa6urrW1tba2tr29vcLCwsbGxszMzNHR0dPT09TU1NbW1tfX19ra2tzc3N3d
3d7e3t/f3+Dg4OHh4eTk5OXl5ebm5ufn5+rq6u3t7fT09PX19ff39/n5+fr6+vv7+/z8/P39/f7+
/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAfXgFuCg4SFhoeIiYqLjIJHR42HWk4sM5GFWVArECCXhE8lFAAhnoJG
JBIDACKlQCQPAgAAFyQoMDtNilo/IgsBssAEFBonOUtahlpBHwbAzs4YLkVXhVcsFs/ZsgwfQ1aE
WkojCNm/zgEKHEKYRCYJ5gAFBwXwAAEJKEWGQykNsQAZcNygIaMFiQ0WCEyoQcXQkRMRYrEaNAUJ
jxgeInTocQhUhVGHsDBxoaFFFUNZoqRwMAKRFiw2WAhBhimKiheKpPjQkQWREiWLoiShWUoQlm9F
kyq9FAgAOw==
"

image create photo imgEditRedo -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgUFBQcHBw0NDQ4ODhAQEBERERISEhUVFRcXFxgYGBoaGhwc
HB0dHR4eHiAgICEhISMjIyoqKkNDQ0REREtLS1NTU1ZWVl1dXWBgYGdnZ2hoaGlpaWpqamtra2xs
bG1tbXJycnNzc3R0dHV1dXZ2dnd3d3h4eHt7e3x8fH9/f4KCgoODg4SEhIWFhYeHh4qKipCQkJGR
kZKSkpSUlJqamp6enqWlpaysrLW1tb29vcHBwcbGxsvLy9DQ0NLS0tPT09XV1dbW1tra2tvb29zc
3N3d3d/f3+Dg4OTk5OXl5ejo6O3t7fX19ff39/n5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAfYgFeCg4SFhoeIiYqLjIhGRo2JNCxLVpGGHAsqTVWXhB0ADiJMlp5X
HgACDSBHjFZLOzMoIRQAqQwgQIlWSTolFRADtsMBCR4/pYRSQy21w8/DBRtByVdSQhgH0Nu2Ei5T
hEMZBwHQ5dAFHEjJRScI57YBBAYExAckRFSDUDcPAxMXRMCwcQNHjgq2BChIQaRQDwwONNTgkeQJ
IVQCHJhAUijKCwsxmHQyBCrCiCaFrAR5gaNKNUIfFqRwMnJQlR0+LCaSscLJyyu8nCxSoiSRFH2m
kipdmjQQADs=
"

image create photo imgEditCopy -data "
R0lGODlhGAAYAPZVAAAAAAEBAQMDAwYGBgwMDBAQEBISEhUVFRkZGRoaGhsbGxwcHB8fHyQkJCcn
JzMzMzk5OTw8PD09PT4+PkFBQUxMTE5OTlJSUlRUVFtbW11dXV9fX2FhYWdnZ2lpaWtra2xsbG5u
bm9vb3JycnR0dHh4eHt7e4eHh4yMjI2NjY6OjpCQkJGRkZOTk5WVlZaWlpeXl5iYmJmZmZqamp2d
naGhoaWlpaampqqqqrCwsLS0tL29vb+/v8DAwMHBwcTExMfHx8jIyNDQ0NPT09vb2+Dg4OLi4uPj
4+Tk5OXl5ebm5ufn5+vr6+/v7/T09Pn5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gFVVKAkAhoeGAQ45go2OgiOIkgADNI+XHgANLTAvnjInBQAvl4+Z
E1CPSAqjpY6nqY6rra6CsKqspLVVt4JTVEUMAC5VUYJRUVOvAKiNPxkVOkAkDyBSUh8WOMvNgjMA
Cki8zMgSACHcsVU9HCVNVTcbKdcpGjbpu7u9VU5HS1KPqDAx8q7RvhoGHix5FOUCgRL4BL0AJ84R
lAkAPCxD0MGDhw4mXtRw8mhKjhU+HJEQIEljPkc4MESYQBMCiR9BngQUsoOIoylRoAhN5QIAgySP
oFAA8CFfDKNILS5tuksJj5w7e77cumsIi5FVfKzIMcWkih75voUbN6EcABEO+XI0WCDuFLIIB1QI
CgQAOw==
"

image create photo imgEditCut -data "
R0lGODlhGAAYAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQsLCwwMDA0NDQ4ODhAQ
EBERERISEhMTExUVFRYWFhcXFxoaGhsbGx0dHR4eHh8fHyIiIiMjIyQkJCUlJScnJysrKywsLC0t
LS8vLzExMTMzMzU1NTY2Njg4ODk5OTo6Ojs7Ozw8PD4+Pj8/P0JCQkNDQ0REREVFRUhISExMTE5O
Tk9PT1JSUlZWVldXV1hYWFlZWVtbW1xcXF1dXV9fX2FhYWRkZGVlZWdnZ2hoaGlpaWpqamtra2xs
bG1tbW9vb3BwcHFxcXJycnNzc3R0dHd3d3h4eH9/f4GBgYWFhYmJiYqKioyMjI2NjZOTk5WVlZeX
l5qampubm52dnZ6enp+fn6KioqOjo6Wlpaqqqqurq7KysrOzs7S0tLa2tre3t7m5ubu7u8HBwcLC
wsPDw8XFxcbGxsfHx8jIyMrKysvLy8zMzM3Nzc7Ozs/Pz9HR0dPT09XV1djY2NnZ2dra2t3d3d7e
3uDg4OHh4eLi4uPj4+Xl5ebm5urq6uvr6+zs7O/v7/Dw8PHx8fT09PX19fb29vf39/j4+Pn5+fr6
+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgA
AAj+ADEJHEiwoMGDlywdXFjwkJknQJZ8CcTQ4CVFXVQYCBDgwxQ/FQlaQpMigQkdLx5ksEJpYSWF
AikVURAjTiRDOArY+HOJ4KVJifLgIQQJ0yQaAI4onHQlQ4s2MAU+otNjg4QaaSxN2jGAByJMlJg8
IEEmKqEsKBwIALDCjKVKWDpkOLJFyocAD2aEYYSpjhMPAQBAyDGG0KVLfZRQQKCBAQQMEQ6QqLLH
zRAIBkQ4mdNy4J0nJkKUCDKlRwQBDYisUbNEBpevBS85+sOmTyNMcm4MABDAhJZAhCYhjDTojW3c
ugEAKGDBR51IB+1AOSGiBJDSpxVUWADAQYstsAWQXuKTZHHjx5FJUBEj5MJyzZwFwpWLpO4HAXnB
LMKUJ8qIwIMV9hNXPCQCVhNjlTXQIWCw8MBaK5yhFVJKGdXUU1FhAgkePnAwAVaWUGKEAjDAEUkh
NxBgAyA9DfRTInrkQRQmI5VUQg4uOLBSZwa95KIiXqgwAEcgfBRSQYiU0cQPRnghyJEHWSJJi1BW
eWRAADs=
"

image create photo imgEditPaste -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgkJCQoKCgsLCwwMDA8PDxAQEBERERMT
ExQUFBUVFRsbGxwcHB8fHyQkJCkpKSsrKy0tLS4uLjExMTQ0NDg4ODo6Ojs7Ozw8PD09PUREREVF
RUZGRkdHR0lJSUpKSkxMTE5OTk9PT1JSUlNTU1VVVVdXV1hYWF5eXl9fX2BgYGFhYWJiYmNjY2Rk
ZGdnZ2hoaHBwcHt7e39/f4GBgYeHh4iIiJCQkJGRkZiYmJ6enp+fn6CgoKKioqOjo6SkpKWlpamp
qaqqqq6urrCwsLGxsbOzs7S0tLa2trm5ubu7u729vcDAwMLCwsPDw8jIyMrKys3Nzc7Ozs/Pz9HR
0dLS0tTU1NfX19jY2Nra2uDg4OHh4eLi4uTk5Ofn5+jo6Ozs7O3t7fDw8PHx8fLy8vPz8/T09PX1
9fb29vj4+Pn5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf7gHaCg4SFhXVoXVaGjIxWNyxIjZN0Z0IoESNck4xuWDsYARdAc5yF
alEyCgAQOGl1poJ0aEYcBAADM1qxsmU6FAUAAhxNvHZxWTQSA7gTRWi8bVItDQDWDzxkvGhOKgfW
AA41YbCmaEkkAuAJKVxysW9DG+C4JVGlpnJIH+rgIEpxYsGpEsIAuAAdjrDhJefLilUACmgoYsbU
my1EgjxB0oLBgQ9AKprCYmMBghFOlLgQgcQNrxwLrA3wwATMFXyc6qyJQW9AjzgBY9HZYoIeAB/G
7MwpkgGcgBNUkoqBEfOAhRdQ1CSdkqKCBxc/xuDkxWUJEy9w5pRLGggAOw==
"

image create photo imgEditDelete -data "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgMDAwYGBgcHBw0NDRAQEBQUFBUVFRkZGRoaGi4uLjAwMDEx
MTw8PD09PUBAQEZGRklJSVNTU1RUVFhYWICAgIGBgYuLi4+Pj5KSkpOTk5ubm6ioqKmpqaqqqra2
tre3t8PDw8bGxsfHx8zMzM3Nzdra2vHx8fLy8vPz8/T09Pb29vn5+fr6+vz8/P39/f7+/v///wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAalwJlw
SCwaj8ikcslsMl8wI+zFlKVMqBaxhTKlZMrVhhH5ED8RxmalTF0Ug4lIJhNNBgtMSukqTQoGFCMk
FQYEEiQuSzEgEAAIFRYJAA8eMU0wHQ4DAAACDR1RTiwaBwEBBhkqTkKkpqiqrJmbnZ+hTYyOkJKU
lkt9f4GDhYeJbW9xITExIXcKF3tJYmRmQ2gMHGxJVidZWygnX0+iRFOs5+jp6ulBADs=
"

image create photo imgEditDuplicate -data "
R0lGODlhGAAYAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQsLCwwMDA0NDRERERIS
EhMTExQUFBkZGRoaGhwcHB0dHR4eHh8fHyIiIiQkJCcnJygoKCkpKSsrKywsLC4uLi8vLzMzMzQ0
NDY2Njk5OTs7Oz09PT4+Pj8/P0BAQEFBQUREREdHR0lJSUpKSktLS09PT1JSUlRUVFVVVVdXV1pa
WlxcXF1dXWBgYGJiYmNjY2RkZGdnZ2lpaWpqamtra2xsbG1tbW5ubnJycnR0dHV1dXp6ent7e39/
f4GBgYKCgoiIiIqKio2NjZGRkZOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnaKioqSk
pKmpqaurq62tra6urra2tri4uLu7u7y8vL6+vsDAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8nJycrK
ys3Nzc/Pz9DQ0NTU1NXV1dbW1tnZ2dra2tvb297e3t/f3+Dg4OLi4uTk5Ofn5+np6evr6+zs7O3t
7e7u7vHx8fLy8vPz8/b29vf39/n5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgA
AAj+ABsJHEiwESNFg8gMCSEizqKCEAcWggNlBogKCyJYARSRICE3VYC42IAAgMkEMeh0HATHixIa
GQiYFKAhA4ABFMYUHJRHDZYbGAyYBCCgQQknSzYEINDEz8A8XnpwKCAgwFACEWy0SdTnCQQCMdgM
JEFBAdUBBNIW+EBlTyKBd4o4mLBloIcFACzgaEKlCpUsZP48FIgIj5Yrcwb6kCCBiBxChyIr6pjo
0GSBYDq0QBOIS5UpoKVEGU06SugoVrYEaiGET5sKA4bKnj30wIRER574OXOANu0ABmIDCLAozJc+
Z4QOFyBgtoACDURMGMookJ1AyU1OQDGiuckGKZKYgHlTY6jAQozMKIfRxYqF2BF2kNEz+ckFkwTV
A2DAxNAeIw880IMbBK0hA34DqSfACmUYlIcNQRBI0CBIICiQGQUM4ARHjSSChyCDERSFhY1gSIAY
BCnCSEQjApBfAQU02JGIJJZB1Qs/8KDjjjzyAIQJJKbRgFW++TbAAgTVoYMKKDTp5JNPnsBCDgQx
gkhkWGapJZaIBAQAOw==
"

image create photo imgEditMove -data "
R0lGODlhGAAYAPZDAAAAAAEBAQICAgYGBgcHBwkJCQsLCxQUFBkZGRoaGhsbGx8fHyEhISIiIiMj
IyUlJTc3Nzs7Oz4+Pj8/P0VFRUdHR0lJSUtLS05OTlJSUmRkZGdnZ2lpaWpqanNzc3h4eH19fYqK
io2NjZCQkJiYmJmZmZycnJ+fn6GhoaampqqqqrS0tLi4uMLCwsPDw9TU1NbW1uDg4OPj4+Tk5OXl
5efn5+jo6Ovr6+zs7O7u7vPz8/X19fj4+Pn5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAe5gEOCg4SFhoeIiYqLiTYwQoyIOCYgQJGFQTkjDxAxNDOgoaAyN5CF
Nh8MAgMJCq6vrwcZP4YdDgEAubq7uhI+higTBLzEub6GPCoWBggbHM/Q0BoilocsFxi0l4YuJdWL
Oj2GPTqRQCQt24Y/GBUriEAiGtH0GwgFFCk7hj4SxcQDIpzg5+/frgANOKzLcACWwwQDBCzwQMOQ
kBsyRImiEQMCgxA4vm0D8oHEDXWEhLyogbKly5dDAgEAOw==
"

image create photo imgEditPushSch -data "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgYGBhAQEBMTExUVFRYWFhgYGBoaGhsbGxwcHB0dHSAgIC4u
LjExMTc3Nz4+PnR0dHh4eHx8fIODg4SEhIeHh4iIiIuLi5KSkpOTk5aWlpycnKCgoLCwsNzc3N7e
3t/f3+Dg4OLi4uTk5OXl5ebm5ufn5+np6ezs7PPz8/T09Pb29vr6+vz8/P39/f7+/v///wAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAalQJlw
SCwaj8ikcsmEfTacqHTzgTFdEYB2q424rlnu1gsWj79LrLmLVqrX5HTYHHfPxfVibHUyjSBrABAj
JicrMUQtHg8LCQOBAwkLDh0sRDAhGAUCgVoBBBYgVkUkFwoBgQEIFSJIMSgUDYEMEyWISDAqE7Ji
DBIpo0kxKhSnnggTKbdLrxcHAQEFFbZMRCQZCAYXrdVFIhsaId1GLysrL+Pp6kpBADs=
"

image create photo imgEditPushSym -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgQEBAYGBgcHBwgICAkJCQoKCgsLCwwMDA8PDxMTExQUFBUV
FRkZGRoaGhsbGxwcHB0dHR4eHh8fHyQkJCUlJSkpKSoqKjU1NTY2Njc3Nzk5OTw8PD09PT4+Pj8/
P0pKSktLS0xMTE9PT1BQUFFRUVJSUlNTU1dXV2BgYGFhYWJiYmNjY2ZmZmdnZ2hoaGlpaWpqam1t
bW9vb3BwcHFxcXJycn19fX5+fn9/f4CAgIGBgYKCgoODg4aGhpKSkpOTk5SUlJaWlqenp6ioqKmp
qaqqqq2tra6urq+vr7CwsLGxsbKysrOzs7S0tLa2tre3t7i4uL+/v8DAwMHBwcLCwsPDw8XFxdDQ
0NHR0djY2NnZ2dra2tvb293d3d7e3t/f3+Hh4eTk5Ozs7O3t7e7u7u/v7/Dw8PHx8fb29vf39/j4
+Pr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gHOCg3FuXEU9NTU+RlxucYORkWtQMB4YFA8PFRgeMVFskoNyXTke
CgIRHyQkHxECCh86XnKSclo0DAYbM0NPVlZPQzIbBQ01WpJdNAYNKU1nomZLKA0GNV6Ccms5DA0u
YnCignBgLA0NO6FxUB4FKWJvgoVu9ZBzb2AnBSBShTAHODARJ4hJBxAgOjAZBEfJhgQyDHkIMENN
LUFEAGgEQGRUmhgAPnQpkmHCEEkZN3aMFCRChiM9KIB4gnIjR0lOPFT4UeMBCSvkypgBYhOImTLy
5lQZAeGGjQcjqsyJQ+bFhQU2F1hoMUYcFREQcPio8IGmHDZYSgywOaDElTXAtZro/EFSghCGVFQQ
0EhABRWCc1q+5OIBgIw0F+NQSXHgQAoq9+SgASnSTQwEG5YAhpPlxIksm5NoSDDjUZQPBVCESTqH
jRgxoQTlM0EgxBRIbHSgYxGGoBw4cC6WW8HAAY82g7zUaIZiiRlRZZKYYHDAxhdJWmo0KKAhhhAn
Vao4CRJDAwEHNraIkuNFBwgFASB4GDHCw4MACkLw+HJRFBspMnyQQQWaVJDBBzNMEds487jRxRE8
1fADEl48IkogADs=
"

image create photo imgEditPop -data "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgYGBhAQEBMTExUVFRYWFhgYGBoaGhsbGxwcHB0dHSAgIC4u
LjExMTc3Nz4+PnR0dHh4eHx8fIODg4SEhIeHh4iIiIuLi5KSkpOTk5aWlpycnKCgoLCwsNzc3N7e
3t/f3+Dg4OLi4uTk5OXl5ebm5ufn5+np6ezs7PPz8/T09Pb29vr6+vz8/P39/f7+/v///wAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAakQJlw
SCwaj8ikcvharV7LpGijCUWPpAzCcBFdhzHU5RAIFCql2DWmoigCAEAAMUmplTDVpBHvAxgSKTBJ
YRR8fn0ME2lIJBdviH1zFV5FMCEYBQKRfgEEFiCDQy0eDwsJA5wAAwkLDh0sRDErJyYjEKoQIyYn
K3dGLhGqES5RwcPFS8ecxMbCzMlKy5HNys/U0UnTiNV4Hxsc4eIbH6Jf5+jpX0EAOw==
"

## OPTION


## VIEW

image create photo imgViewZoomIn -data "
R0lGODlhGAAYAPUAAAAAAAEBAQYGBggICBERERISEhMTExQUFBoaGjc3Nzg4OD4+PkFBQUJCQklJ
SUpKSktLS0xMTF5eXl9fX2BgYGxsbHd3d3l5eXp6enx8fIODg4SEhIWFhZGRkZKSkpOTk5SUlLu7
u7y8vL29vcDAwMHBwcLCws/Pz9DQ0NHR0dbW1tfX19ra2tvb29zc3N3d3eDg4O7u7u/v7/X19fb2
9vf39/r6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAb+wJ1w
ONTljjkdcckcxlAkEkrWbOpmIY3kwWA8JhsRTVm1vTwOA2DNNjw8LFvztsqo2fg1waK6MVkWAwFs
AggIAmwBAxctSzMdBINsCTAwCXgBBR81RCEOeQALNzcLoBAiRBt3eKKkoAYbQjoyE6Cho6WgEjFG
Jw9rAgkLCwoVODgVCsMJiAAQKEckDGsIMDqjOEI4ozowCGsNJkclDdTW2Nrc3uDiOSi/AMHDxcfJ
y80QKUkxtaCtuXkmyCCjyh8uUAc4dILH6mAeCCOI0PBQQNIaSpYwGQDBiUiLC4IIGWoGQBEGF0xu
qLhQwFYbDCv8MLHR4gOEAwgjgHAhp4ogDhojOEyA0KABBAocRtQgU4WIjBQlSqSg0tQnkiRNgwAA
Ow==
"

image create photo imgViewZoomOut -data "
R0lGODlhGAAYAPUAAAAAAAEBAQYGBggICBERERISEhMTExQUFBoaGjc3Nz4+PkFBQUJCQklJSUpK
SktLS0xMTF5eXl9fX2BgYHd3d3l5eXp6enx8fIODg4SEhIWFhZGRkZKSkpOTk5SUlLu7u7y8vL29
vcDAwMHBwcLCws/Pz9DQ0NHR0dbW1tfX19ra2tvb29zc3N3d3eDg4O7u7u/v7/X19fb29vf39/r6
+vv7+/39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAb2QJxw
OLzZjrYbcckcvkwikQnWbN5iH0zEsVg4JBmQTFmttTgNA2DNNjg4Klqzlrqo2fg1gYKqMVUUAwF5
eQEDFStLMRsEg4SFBR0zRB8Nj5cADyBEGXeYeQYZQjcwEp+XES9GJQ5rAgkKsbKzCQJrDyZHIgtr
CC43NcHCwTcuCGsMJEcjDL2/w8PFxwDJRyatAK+z2wq1tydJL6anhBIwZJ3keAcalNjqmSFEMhwF
jp8BBh6TRCsVgvgGWGDBpAaKCgU+GbCQwg8TGis6PDhA6AAEDyzkVLkhI4QGCQ8YMHgwQUOIGWSq
EIFxYsSIE1RUbkSSRGUQADs=
"

image create photo imgViewZoomBox -data "
R0lGODlhGAAYAPZMAAAAAAEBAQICAgQEBAUFBQYGBgcHBwgICAoKCgsLCwwMDBYWFhcXFxoaGhsb
Gx0dHSMjIysrKzQ0NDY2NkBAQEFBQUJCQkNDQ0lJSUpKSk1NTVFRUVJSUlZWVldXV1tbW1xcXF5e
XmJiYmNjY2RkZGlpaWpqamtra3t7e4aGho+Pj5aWlpeXl5ubm6ampqurq66urq+vr7i4uLq6uru7
u76+vsfHx8jIyM7OztXV1dzc3OHh4eLi4uTk5Ofn5+rq6uzs7O3t7e7u7u/v7/Pz8/T09Pn5+fr6
+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gEyCg4SFTEtJR0dISoaOhT4rHxsoNo+XPCoRBgIMIjZKS0E1LSum
p6YsMkMzEwEAsA0ojDAVBLC4uAIaOC4KuQIbih0DCA7HyMcPJDkvC6+wByBHRhYAIT892tvaQUs3
HAO4ESxJRhQAJZeCRTQcCwoSKj5L5+nrgkQ3Ly4zO4L21OFjciQHDiCDAg5kEmREBhkJ0QnE1+MB
ABYR7w3s4QDAiowT13H0CHLhyI8AJZrsiJKJwo0sS8IkmVIjxZg1Q146OegIBgARTpQYSrRoCRMh
EgRoMQhJCgi5okotcKHGoCU6UmCgwLWr164WPMQQQmgJEmpG0qpdq/ZIqEECgQAAOw==

"

image create photo imgViewToggleColors -data "
R0lGODlhGAAYAPZjAAAAAAEBAQICAg8PDxERERISEhMTExQUFBUVFRYWFhkZGRsbGx4eHiUlJSYm
JicnJykpKSoqKj4+PkJCQkNDQ0RERE5OTk9PT1FRUVJSUlRUVFdXV1hYWFlZWVpaWltbW2JiYmNj
Y2RkZGdnZ2hoaGpqamtra2xsbG9vb3BwcHFxcXJycnNzc3R0dICAgIGBgYKCgo6Ojo+Pj5CQkJGR
kZKSkpycnJ2dnZ6enqCgoKGhoa2tra6urrCwsLGxsbKysrS0tLq6ur29vb6+vr+/v8LCwsPDw8rK
ysvLy8zMzM3NzdHR0dTU1NXV1dbW1tfX19ra2tvb29zc3N7e3uLi4uTk5Onp6evr6+zs7O3t7e7u
7u/v7/Hx8fLy8vn5+fr6+vv7+/39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gGOCg4RQJShShIqLiksUFUuMilNDSGKETBYXTIRiSENThEIjIUhe
g1c7O1eDXkghI0OESSARMFyCXltWVltfglwvESFJikcvNV1hWkg2Ly83SVphXTQwSIteXF1gTSoO
CAYDBA0rTWBdXKeMYEwcChIzOgYAAQYeTmCSglopChtBtlRZAKBgAhZb9oFB4kBCEEEDC9ZzkETf
IChLmGTZYiNBDFZjIkoscGNLFiZLopSgcGGHFRcGgAwSWXCACys9MFAwgaLCBR4vY84kKHHACys/
NOyUknFjRxlYIBItWADHFi1NUhJa6KCCrJBTAzhQYpGRlhUMPATRQjNBi4RsCpt0gCcjBz0BBz48
KatIGzcnLB6EG+egxd506wgdcUFD2ZYkN2DAwKFkC7UZL7DNAgHhlqAvu3r9GhMMQgglhIaQEGEK
1Q4fUXO9OlGE0BQiSS4NYnIhQ5NOSYxQ2TdoyYQJkYjvM1QiCvFAADs=
"

image create photo imgViewRedraw -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgkJCQoKCgsLCwwMDA8PDxAQEBERERMT
ExQUFBUVFRsbGxwcHB8fHyQkJCkpKSsrKy0tLS4uLjExMTQ0NDg4ODo6Ojs7Ozw8PD09PUREREVF
RUZGRkdHR0lJSUpKSkxMTE5OTk9PT1JSUlNTU1VVVVdXV1hYWF5eXl9fX2BgYGFhYWJiYmNjY2Rk
ZGdnZ2hoaHBwcHt7e39/f4GBgYeHh4iIiJCQkJGRkZiYmJ6enp+fn6CgoKKioqOjo6SkpKWlpamp
qaqqqq6urrCwsLGxsbOzs7S0tLa2trm5ubu7u729vcDAwMLCwsPDw8jIyMrKys3Nzc7Ozs/Pz9HR
0dLS0tTU1NfX19jY2Nra2uDg4OHh4eLi4uTk5Ofn5+jo6Ozs7O3t7fDw8PHx8fLy8vPz8/T09PX1
9fb29vj4+Pn5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf7gHaCg4SFhXVoXVaGjIxWNyxIjZN0Z0IoESNck4xuWDsYARdAc5yF
alEyCgAQOGl1poJ0aEYcBAADM1qxsmU6FAUAAhxNvHZxWTQSA7gTRWi8bVItDQDWDzxkvGhOKgfW
AA41YbCmaEkkAuAJKVxysW9DG+C4JVGlpnJIH+rgIEpxYsGpEsIAuAAdjrDhJefLilUACmgoYsbU
my1EgjxB0oLBgQ9AKprCYmMBghFOlLgQgcQNrxwLrA3wwATMFXyc6qyJQW9AjzgBY9HZYoIeAB/G
7MwpkgGcgBNUkoqBEfOAhRdQ1CSdkqKCBxc/xuDkxWUJEy9w5pRLGggAOw==
"

## PROPERTIES


## LAYERS


## TOOLS

image create photo imgToolInsertSymbol -data "
R0lGODlhGAAYAPYAAAAAAAEBAQYGBgcHBwkJCQoKCgsLCw4ODhQUFBUVFRcXFxgYGBoaGhsbGxwc
HB0dHSEhISQkJCYmJisrKzU1NTc3Nzw8PD09PT4+PkBAQEFBQUJCQkVFRUlJSUtLS1ZWVmRkZGdn
Z2hoaGlpaW1tbXBwcHFxcXJycnd3d3h4eH9/f4CAgIyMjI2NjY6Ojo+Pj5GRkZOTk5WVlZaWlpeX
l5iYmJ6enqurq7CwsLS0tLi4uLm5ub+/v8LCwsXFxcrKytLS0tnZ2dra2tzc3N7e3uDg4OTk5OXl
5ejo6Onp6erq6uzs7O/v7/Hx8fLy8vPz8/b29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gFmCg4SFhoeIiYMsJyIjj5CRkpAhJy0MAwCam5ydnQMNmhEZGKWm
p6gYGRGcMVlUsLGys1RZMZwzioJYWIQzuIVJSYRKPj21gr+buYNNMDVXgzYbHzxSycCCVzwYHD/R
WSoEEjdQ2MuDUykKCSZMvTogJEFV55rMVkUYmhM5UVlXqlTpZQ8Asyc0IGgy4MGItipSCCq7JwhJ
hwKbFshYwgQHihdOCuaCsuMBJwEUVpSooIACECtZJhrMQiSEgU4BENwEcEDFkZjAhIDQcAGVhaIX
NowYAhQdFisCo0qNaqWXTFdUpmqNWuvWplGpwppapclBJk9oPQ1w0OJEiEkLcCVVcqGrrt26gQAA
Ow==
"

image create photo imgToolInsertText -data "
R0lGODlhGAAYAPQUAAAAAAMDAwQEBAUFBQcHBwoKChsbGzIyMjMzM3l5eXp6epOTk8HBwcLCwsPD
w8fHx83Nzd7e3ufn5/n5+f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAA
AAAALAAAAAAYABgAAAWQICWOZGmeaKqubFs+DiPPTuQahTDsg1AkpolEMiHhdDyfwgQ5HCAk2Ixm
KzUIhIbLxNgxtqXu4DuSThk1ygTSYDwWgcDigX4ceb0fRXIg6AIAAAF5BndJBUt8fgOAgoRmU2lr
bW9xc3VgYmRgIppRMWdpVlhaI4Y7PkAlTQhQpjl4SkFDRWWgkVWcuru8vS0hADs=
"

image create photo imgToolInsertWire -data "
R0lGODlhGAAYAPUAAAQEBA8PDzs7Ozw8PD09PUREREVFRU5OTk9PT1BQUGJiYmNjY2RkZGVlZWho
aGlpaXd3d3h4eHx8fH19fX5+foaGhoeHh5OTk5SUlJubm6WlpaampsHBwcnJycrKysvLy8/Pz9DQ
0NTU1NXV1dnZ2dra2ujo6O7u7u/v7/Hx8fLy8vz8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAaMQJdw
SHSxWMWkcqjqeFTLqBAkYTQoIakydSlYLAZMSlsUQRyrlSMyIhNJkoXJpJiU3EOWZoA4EDYteEMn
GQEBGSiCRBwAAByKi42PkEKMjpSVkpgulpOUnZugmKKQhIaIkHoCCQkDgIpwciYLEySKIhEPaWtt
gikYBhUVYWOKIRMMDFiYKh4fUJtHWkEAOw==
"

image create photo imgToolInsertLine -data "
R0lGODlhGAAYAPMJAAQEBAcHByAgICEhIcHBwcLCwsjIyMnJyfLy8v///wAAAAAAAAAAAAAAAAAA
AAAAACH5BAAAAAAALAAAAAAYABgAAAQ1MMlJq7046827/2AojmTZIUZBrGxbGAh2CAFg33gwHPJQ
40Ad74JStY6vmGnJbDqf0Kg0EwEAOw==
"

image create photo imgToolInsertRect -data "
R0lGODlhGAAYAPQWAAAAAAgICAkJCQsLCxsbG0BAQEFBQV5eXl9fX2BgYGFhYWlpaWpqapaWlp6e
np+fn8TExMXFxeTk5Pn5+fr6+v39/f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAA
AAAALAAAAAAYABgAAAWUoCVW1GSeKEpVYmtBiFHMdD0bSOSKTgD8wGAw4NhZGoDBgbFoOpuMwwDQ
MCIJEqNLQqBaAVhti+vdXbNiC7lqBqPF6284HW/P4V2265xW5+VvWnV7bn2DLXx0f3aBRociiXhl
hHeCi5SNO49HhYqTiJ2SeqBKTE9OUVOjIg8CQq9AAg9GEQkyNrgGCjo7JCm/JystIQA7
"

image create photo imgToolInsertPolygon -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwkJCQoKCgsLCxAQEBERERUVFRcX
FxkZGRwcHB4eHiAgICEhISQkJCcnJyoqKiwsLDMzMzo6Ojs7Ozw8PEZGRktLS1FRUVdXV15eXmJi
YmNjY2hoaGlpaW5ubm9vb3FxcXNzc35+foCAgIGBgYKCgoSEhIqKipKSkpWVlZeXl5ycnJ+fn6Cg
oKioqKysrLy8vMHBwcXFxcfHx8rKysvLy8zMzNTU1NXV1dfX19ra2t/f3+Hh4ePj4+Tk5OXl5enp
6evr6+7u7vDw8PHx8fLy8vPz8/b29vj4+Pn5+fz8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAe5gFSCg4SFhoeIiYqLhEUxjIlNNRWQiDkeApWGSCoGAJqFMhcAn6BU
UzseA6SmU0wnDqSliVA8N0WCTjYWsrOHU0MgGy9HU0AcCb2KSTQNABQuPi0Lvb6nU4M6GAUAAhMZ
D6vKg1BGRU9UQSgIsgQHAdW+PyQhOEozEvDx1YNCKQoEPqzosG+foCUwIugjQKBgPCpRamhwSBGA
lB4e9FXcR0QEg40OS0AA6ZCFiREkUqpcybKlqZeQAgEAOw==
"

image create photo imgToolInsertArc -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgYGBgcHBwgICAkJCQoKCgsLCwwMDA8PDxMTExQUFBUVFRgY
GBkZGRoaGhsbGxwcHB0dHR4eHh8fHyAgICIiIiYmJikpKSoqKisrKzQ0NDU1NTY2Njc3Nzs7Ozw8
PD09PT4+Pj8/P0RERElJSUpKSktLS1BQUFFRUVJSUlNTU11dXWBgYGFhYWNjY2ZmZmdnZ2hoaGlp
aWpqam1tbW9vb3BwcHFxcXJycn19fX5+fn9/f4CAgIGBgYKCgoODg5CQkJKSkpOTk5SUlJeXl5mZ
maGhoaOjo6enp6ioqKmpqaqqqq2tra6urq+vr7CwsLGxsbKysrOzs7S0tLa2tre3t7i4uL+/v8DA
wNDQ0NHR0djY2NnZ2dra2tvb29zc3N3d3d/f3+Dg4OTk5OXl5efn5+zs7O3t7e7u7u/v7/Dw8PHx
8fX19fb29vf39/j4+Pr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gHeCg3VyXUo/NzdAS11ydYORkW9VMiEZFBASFxsiM1ZwkoN2Xjsh
CQIRIyUFAK4KJDxfdpJ2WzYLBR41RVZODK6uAg03W5JeNgUMLFJqgmURwcEEN1+DbzsLDDBjdIPQ
0sENPaF1VSEELGNzkeDhAQAkV4UyBh9R3u3R0gEOCQo0DIUIUKMNLX3BBmCQgWRFABFelGSYUETU
HXAHNLQw4qWOEAcamPygIIKKRTMYLKg4QuZgFBAVguCAgEKLxTQxkpyxc/BOFhMQcsysabGOGjeQ
ImU5AUEHkAolLUq9MyVETCUaJBCZanFIhJBdBtJg03OqnTUzAECUM+OAByiE+bjScdIBQY1HVkQQ
WCGG3dQ5YlIMIIEFEhweDBi8EBNXEh0xLhY08BFn0JcbylQ8SSMKjZMUCwzgACNpyw0GBDrMGDJF
i5YpQ2ZwGNAABxdRdr70GJEgAIQQKFCEgBAgAQkfYcpGgnOFhogMFR48qKBBRA0sobgW8sIkiKIg
Tb48EhUIADs=
"

image create photo imgToolInsertCircle -data "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgYGBgcHBwgICAkJCQoKCgsLCwwMDBMTExQUFBUVFRkZGRoa
GhsbGxwcHB0dHR4eHh8fHykpKSoqKjQ0NDU1NTY2Njc3Nzw8PD09PT4+Pj8/P0pKSktLS0xMTFBQ
UFFRUVJSUlNTU2BgYGFhYWNjY2dnZ2hoaGlpaWpqam1tbW9vb3BwcHFxcXJycn19fX5+fn9/f4CA
gIGBgYKCgoODg5KSkpOTk5SUlKenp6ioqKmpqaqqqq2tra6urq+vr7CwsLGxsbKysrOzs7S0tLa2
tre3t7i4uL+/v8DAwMHBwdDQ0NHR0djY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+zs7O3t7e7u7u/v
7/Dw8PHx8fb29vf39/j4+Pr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gGWCgmRjYE87NS0tNjxPYGODkpJdRigaFBINDRMUGilHXpODZFAx
GgkCDxsgIBsPAgkbMlFkk2RNLAoFGCs6RUxMRToqFwQLLU2TUCwFCyRDWaNYQSMLBS1RhF0xCgsn
VmKjgmJVJgsLM6JjRhoEJFZh44NhVSMEHEiGKAYZQuLzBokJguGAikMaAqzgYisgoS0qAGyAsqNC
BB0OR+F4UKEHDQkcimScRETDhBstGoBgMlLSkg8OXrhw8GFJy0FKPDiAYWPCBpE3y5Q8WRFCjqBl
NnZ8ogGAii0NHZLRkkIiFDApDmAIAtChmB8XEKyAdGQDgRFU5AUMQyXEgA5rSSJ5kYHOBJWuk8RQ
KaGAAY0vg6K0cCYCCJZRV36EUGDAhZRJTVosGHAhBQ4iS5YQwZHCwgAGLpyMIhNlBocEARpo+PBB
Q4MACTrQmBJ1khckKjZUmLBpQoUNK5KIcmgISg+ULW74iAJpVCAAOw==
"

image create photo imgToolSearch -data "
R0lGODlhGAAYAPZ3AAAAAAMDAwQEBAUFBQcHBwgICAkJCQoKCgwMDA8PDxAQEBERERISEhcXFxkZ
GRoaGhsbGxwcHB0dHR4eHiIiIiUlJSYmJicnJygoKCkpKSsrKy0tLS4uLjExMTMzMzQ0NDg4ODk5
OTs7Ozw8PEBAQEFBQUNDQ0hISElJSU5OTlFRUVJSUlpaWltbW2BgYGVlZWtra25ubm9vb3FxcXJy
cnR0dHV1dXZ2dnd3d3t7e3x8fICAgIGBgYKCgoaGhoqKiouLi5CQkJGRkZKSkpWVlZeXl5iYmJmZ
mZ+fn6ampqenp6qqqq6urrKysrOzs7S0tLW1tbe3t7i4uLm5ubq6ur29vb+/v8HBwcLCwsTExMnJ
ycrKyszMzNDQ0NPT09XV1dra2ufn5+jo6Orq6uvr6+zs7O7u7u/v7/Dw8PHx8fLy8vPz8/T09PX1
9fb29vf39/j4+Pn5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gHeCg4SFhoeIiYh0YVFCPD1EVWmKhGpWOSUOBAYTKD5cb5VsUygG
DRwhIRoMByxYcopWKAcXO1pmZVgxFAIrXXaIYjoEF1Blc3Z2cWVFGwkwcIhRJQ07ZYZmNwofWrGG
Qw8cW9+FTSMSRGuHPAUhZsGGXy4MNmeHPQYgY/GFYC8LaNwzRGSChitxDmVJ8QCImkNVUDCIgc1Q
EAgZoogylMbHAQpFyBCqA8VEgBPwEHFpQWADjidfwGQJYiIBgA5ONhp6g2VFAgUiXLxIAUEAAAAI
TkhZdyhOFxgfIjBY4CBDCQwEABRAQaUNIjtwtBCpMeNHlDFIPhgVgGLKnEQxctacOaPmjR03STwE
ADBARZVKhtAs8TAAgAUjgA2dUUKigowuiQ25YXLES+TLmA0FAgA7
"

image create photo imgToolJoinTrim -data "
R0lGODlhGAAYAPU9AAAAAAEBAQMDAwQEBAUFBQsLCw0NDQ4ODhAQEBERERMTExQUFBkZGRoaGh8f
HycnJykpKSoqKi4uLlRUVFdXV1hYWF9fX2NjY2RkZGVlZWhoaGlpaW9vb3BwcHJycnNzc3l5eXx8
fIqKio2NjZCQkJiYmJubm5+fn6amprm5ub6+vr+/v8TExMbGxsjIyMnJycvLy87Ozs/Pz9HR0dLS
0tPT09TU1NbW1tjY2Nvb2/r6+vz8/P39/f///wAAAAAAACH5BAAAAAAALAAAAAAYABgAAAaowJ5w
SCwSeTuecbnkqUwsJlMm6+lilYelpZQSRZ6bTbMAREo7LzHDyHwOAMQk1VX3NgABIVC4wOxEeAAA
BBwzaYBCgnkYNIlDiwENHjOPPSgXG5oYIlWWn6CholI3JJmaFyiWOCEOAYMAG584HAOwso87Mx0E
t5YwFwUBAwKxiTwrFAkABh0cDhmJOycSAAoYMzkgI8cvGBAVMDo9NTWWLicqdZ9I649BADs=
"

image create photo imgToolBreak -data "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgMDAwoKCgsLCw8PDxAQEBERERMTExUVFRYWFicnJywsLDEx
MVFRUVJSUlNTU1RUVFZWVldXV1hYWFpaWlxcXF1dXWFhYWJiYmNjY2VlZWZmZmlpaXR0dHZ2dnl5
eZqamqKioqamprS0tLa2tre3t7q6uru7u7+/v8DAwMTExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzfj4+Pn5+fr6+vv7+/z8/P39/f7+/v///wAAAAAAACH5BAAAAAAALAAAAAAYABgAAAazwJ5w
SCwaj8ik0phDhTie6Ia0JOZSl0UAwPVUi7OKgAvwfoU6GmdANp9lGkJAMHYvdyrKAVCwSBQdZzoj
DgAHFCwyFiBnPDUdDA8rNj0mJmdCMCInO0I3N5g9PDqdXzs6PKGfQjsnIjChJSU9Ny0QDBktqV8f
EzEvFwgADSI6Zx0JEBgFAAYTKqVVHgB0AQQYLqHTXAMcM8aY29QRMaE94gEJFSc4mCQbUR4cICbt
5vf4RkEAOw==
"



## SYMBOL


## HIGHLIGHT


## SIMULATE


## HELP




## ACTION BUTTONS

image create photo imgSimulate -data "
R0lGODlhGAAYAPUAAAAAAAEBAQQEBAkJCQ8PDxoaGhsbGx4eHi8vLzY2Njw8PD09PUVFRUxMTE1N
TVVVVV5eXnZ2dnp6ep2dnaCgoKGhoaioqL6+vsHBwcLCwtDQ0NHR0dbW1tfX19ra2tzc3OPj4+Tk
5OXl5ejo6Onp6e/v7/Hx8fj4+Pn5+fr6+vv7+/7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgAAAZ7QJZw
SCwaj8ikcslsKlMajslpHCkaFtKJOhQdBAbIBbXihgwAACEh8aio5zQA/JiAnHE5IICQZEpMeXoA
AwwVH29JgoMABRGAimiMaY6QSItyhRSISph8EhiWkXJ0dniSa22JTV5gYmRcIwsOWVtcLCkbHVO3
vb6/wFRBADs=
"

image create photo imgNetlist -data "
R0lGODlhGAAYAPZcAAAAAAEBAQICAgQEBAUFBQcHBwgICAsLCwwMDA0NDQ4ODhERERoaGh4eHh8f
HyAgICEhISIiIiUlJSgoKCkpKSsrKy0tLS4uLi8vLzc3Nzw8PD4+Pj8/P0BAQEFBQUZGRkdHR0hI
SExMTFJSUlRUVFZWVlhYWFxcXGBgYGVlZWZmZmhoaHV1dXZ2dnd3d3l5eX5+fn9/f4KCgoaGhoeH
h4mJiZaWlpeXl5mZmaCgoKGhoaOjo6+vr7CwsLGxsbW1tba2trq6uru7u7y8vL6+vsDAwMHBwcLC
wsPDw8XFxc/Pz9nZ2dra2tvb29zc3N7e3uHh4ePj4+np6fPz8/f39/j4+Pn5+fr6+vv7+/z8/P39
/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAAAAAAALAAAAAAYABgAAAf+gFyCg4NaVodWWoSLjIM+Gh0dGj6NlYM2AJkANpaWmJqcnY2fmaGi
i6Sbp4yppquCra9UQi0rG5oAGyssQFSdVEEiCriZCCE/vp1aRSUJuAgjQoqrRyYGmQUkRJ1bWVdY
W1xZSScEAyVGWVxbWFdZ4YNLMx8pTOpVSCgoRr5ZTCkfaCwRtOXJCwgVbkiZNkWJkimCtEjBcSFC
iyZboMiYkCGHOlFadmSQEANKjQgHUAwxcgRKFUZVoBwxMgTFgQg1GlwTQICAgRZOGDlxYaCnAAAG
HDi4pilABR5crki9wqWHhQC4DDzwsIBYAQocNojdwIFCAWILPKhgQKyt20wiDFTowPC2riYMOqLA
AMEhkt+/gCNxAAEjCjtEiBMrPgQuEAA7
"

image create photo imgWaves -data "
R0lGODlhGAAYAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4O
Dg8PDxAQEBMTExQUFBUVFRYWFhcXFxoaGhwcHB0dHR8fHyEhISIiIiMjIyUlJScnJykpKSoqKi0t
LTAwMDExMTIyMjMzMzQ0ND09PT8/P0BAQEFBQUREREZGRkdHR0hISElJSUpKSktLS1RUVFVVVVZW
VldXV1hYWFpaWltbW1xcXF1dXV9fX2FhYWNjY2RkZGVlZWZmZmdnZ2lpaWtra2xsbG1tbW5ubm9v
b3BwcHFxcXJycnR0dHV1dXZ2dnd3d3t7e35+fn9/f4ODg4SEhIaGhoeHh4iIiImJiYqKiouLi4yM
jI2NjY6Ojo+Pj5OTk5aWlpiYmJmZmZqamp2dnaSkpKenp6ioqKmpqaysrLCwsLGxsbKysrS0tLi4
uLm5ubq6uru7u729vb6+vr+/v8HBwcTExMXFxcfHx8jIyMnJycrKyszMzM3Nzc7Ozs/Pz9DQ0NHR
0dLS0tPT09TU1NXV1dbW1tfX19jY2NnZ2dra2tvb29zc3N3d3d7e3uDg4OHh4eLi4uTk5OXl5ebm
5ufn5+jo6Onp6erq6uvr6+zs7O3t7e/v7/Hx8fLy8vPz8/T09Pf39/j4+Pn5+fr6+vv7+/z8/P39
/f7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAYABgA
AAj+AFEJHEiwoMGDCBMeLJVJUB9GnRQaJKWIzJMdN4RQQUNo1MFEcgadQvXpThIMAhQ0KBAggxA1
iDiZQnXK058mKqCQMgXHxYEHH2rwYNEBQoIIN8wcquQojQsHEICMGnXDAAYkhC5pwtQHiwkFCyJs
EPGBAoIIPwidKiWGiBhIMwWOsqSnC4wIAAAEQLAizCJSNCUhuoRqlKRHm0qhMmWpDpksUaqMoZPJ
4CQ1WZQUefLFjSPFqERxAjUS0p5FI0MFmhJCwACWCkxAmfMI1EBRiazU0FLKFB4aDBZgQAGjhAUH
CTQgiRMJ06Q6OCYs2DFVh4IJOexMwhRJjhINCRzjWCDR4sSFBQtm5DFVaouNK4pEDQQFSc6TrwEI
CBAwooqgUDQxwgckNH3SiUeokNJIG188YQQTXLBBiUGYyCGGFFFoQYYdmMxkyiaPVKKYJYdEMhIp
i3yRggF5ASBBDF7oYQmCi0ECxhBilHJKIUFIgEAFIIzAQQQLKFCCFXxgosklgxxxwQE4TOXDAw+8
sEaIiJyBgwQJQMDBCjvI4IEDBrDwhimkQKGCE4B4MtIpnSCiRhAZCEAAAwkIoMESeHxC0yBzKHLQ
KIOgUYUQOPQARRmLgCbRQJ4w4ochiT1q6aWWBgQAOw==
"
