/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.DigestAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.parser.NewSessionTicketParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.NewSessionTicketPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.NewSessionTicketSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.Mac;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewSessionTicketHandler
extends HandshakeMessageHandler<NewSessionTicketMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NewSessionTicketHandler(TlsContext context) {
        super(context);
    }

    @Override
    public NewSessionTicketParser getParser(byte[] message, int pointer) {
        return new NewSessionTicketParser(pointer, message, this.tlsContext.getChooser().getSelectedProtocolVersion(), this.tlsContext.getConfig());
    }

    public NewSessionTicketPreparator getPreparator(NewSessionTicketMessage message) {
        return new NewSessionTicketPreparator(this.tlsContext.getChooser(), message);
    }

    public NewSessionTicketSerializer getSerializer(NewSessionTicketMessage message) {
        return new NewSessionTicketSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(NewSessionTicketMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().isTLS13()) {
            this.adjustPskSets(message);
        }
    }

    private void adjustPskSets(NewSessionTicketMessage message) {
        LOGGER.debug("Adjusting PSK-Sets");
        List<PskSet> pskSets = this.tlsContext.getPskSets();
        if (pskSets == null) {
            pskSets = new LinkedList<PskSet>();
        }
        PskSet pskSet = new PskSet();
        pskSet.setCipherSuite(this.tlsContext.getChooser().getSelectedCipherSuite());
        if (message.getTicket().getTicketAgeAdd() != null) {
            pskSet.setTicketAgeAdd((byte[])message.getTicket().getTicketAgeAdd().getValue());
        } else {
            LOGGER.warn("No TicketAge specified in SessionTicket");
        }
        if (message.getTicket().getIdentity() != null) {
            pskSet.setPreSharedKeyIdentity((byte[])message.getTicket().getIdentity().getValue());
        } else {
            LOGGER.warn("No Identity in ticket. Using new byte[] instead");
            pskSet.setPreSharedKeyIdentity(new byte[0]);
        }
        pskSet.setTicketAge(this.getTicketAge());
        pskSet.setPreSharedKey(this.derivePsk(message));
        LOGGER.debug("Adding PSK Set");
        pskSets.add(pskSet);
        this.tlsContext.setPskSets(pskSets);
    }

    private String getTicketAge() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        LocalDateTime ticketDate = LocalDateTime.now();
        return ticketDate.format(dateTimeFormatter);
    }

    private byte[] derivePsk(NewSessionTicketMessage message) {
        try {
            LOGGER.debug("Deriving PSK from current session");
            HKDFAlgorithm hkdfAlgortihm = AlgorithmResolver.getHKDFAlgorithm(this.tlsContext.getChooser().getSelectedCipherSuite());
            DigestAlgorithm digestAlgo = AlgorithmResolver.getDigestAlgorithm(this.tlsContext.getChooser().getSelectedProtocolVersion(), this.tlsContext.getChooser().getSelectedCipherSuite());
            int macLength = Mac.getInstance(hkdfAlgortihm.getMacAlgorithm().getJavaName()).getMacLength();
            byte[] resumptionMasterSecret = HKDFunction.deriveSecret(hkdfAlgortihm, digestAlgo.getJavaName(), this.tlsContext.getMasterSecret(), "res master", this.tlsContext.getDigest().getRawBytes());
            LOGGER.debug("Derived ResumptionMasterSecret: " + ArrayConverter.bytesToHexString((byte[])resumptionMasterSecret));
            byte[] psk = HKDFunction.expandLabel(hkdfAlgortihm, resumptionMasterSecret, "resumption", (byte[])message.getTicket().getTicketNonce().getValue(), macLength);
            LOGGER.debug("Derived PSK: " + ArrayConverter.bytesToHexString((byte[])psk));
            return psk;
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            LOGGER.error("DigestAlgorithm for psk derivation unknown");
            throw new WorkflowExecutionException(ex.toString());
        }
    }
}

