/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.pm.exchange.converters.op;

import com.projectlibre.core.pm.exchange.converters.op.OpImportState;
import com.projectlibre.core.pm.exchange.converters.op.OpRangeConverter;
import com.projectlibre.pm.calendar.WorkCalendar;
import com.projectlibre.pm.calendar.WorkCalendarException;
import com.projectlibre.pm.calendar.WorkDay;
import com.projectlibre.pm.calendar.WorkWeek;
import com.projectlibre1.configuration.CircularDependencyException;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.util.DateTime;

public class OpCalendarConverter {
    public void to(WorkingCalendar workingCalendar, WorkCalendar workCalendar, OpImportState opImportState) {
        workingCalendar.setId(workCalendar.getId().getLocalId());
        String string = workCalendar.getName();
        workingCalendar.setName(workCalendar.getName());
        WorkingCalendar workingCalendar2 = CalendarService.getInstance().getStandardInstance();
        WorkingCalendar workingCalendar3 = null;
        if (workCalendar.getBase() != null) {
            workingCalendar3 = opImportState.getMappedOpBaseCalendar(workCalendar.getId());
            if (workingCalendar3 == null) {
                workingCalendar3 = workingCalendar2;
            }
            try {
                workingCalendar.setBaseCalendar(workingCalendar3);
            }
            catch (CircularDependencyException circularDependencyException) {
                circularDependencyException.printStackTrace();
            }
        }
        OpRangeConverter opRangeConverter = new OpRangeConverter();
        WorkWeek workWeek = workCalendar.getWeek();
        for (int i = 0; i < 7; ++i) {
            com.projectlibre1.pm.calendar.WorkDay workDay;
            WorkDay workDay2 = workWeek.getDay(i);
            if (workDay2 == null) {
                workDay = null;
                if (workCalendar.getBase() == null && workingCalendar2.getWeekDay(i).isWorking()) {
                    workDay = com.projectlibre1.pm.calendar.WorkDay.getNonWorkingDay();
                }
            } else {
                switch (workDay2.getType()) {
                    case NON_WORKING: {
                        workDay = com.projectlibre1.pm.calendar.WorkDay.getNonWorkingDay();
                        break;
                    }
                    default: {
                        workDay = new com.projectlibre1.pm.calendar.WorkDay();
                        opRangeConverter.to(workDay, workDay2);
                        if (workCalendar.getBase() != null || !workingCalendar2.getWeekDay(i).hasSameWorkHours(workDay)) break;
                        workDay = null;
                    }
                }
            }
            workingCalendar.setWeekDay(i, workDay);
        }
        for (WorkCalendarException workCalendarException : workCalendar.getExceptions()) {
            long l = workCalendarException.getStart();
            while (l < workCalendarException.getEnd()) {
                com.projectlibre1.pm.calendar.WorkDay workDay = new com.projectlibre1.pm.calendar.WorkDay(l, l);
                opRangeConverter.to(workDay, workCalendarException);
                workingCalendar.addOrReplaceException(workDay);
                l = DateTime.nextDay(l);
            }
        }
        workingCalendar.removeEmptyDays();
        for (int i = 0; i < 7; ++i) {
            System.out.println(workingCalendar.getWeekDay(i));
        }
    }
}

